/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.log;

import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.log.HoodieMergedLogRecordScanner;
import org.apache.hudi.common.util.ClosableIterator;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.io.storage.HoodieFileReader;

public class HoodieFileSliceReader<T>
implements Iterator<HoodieRecord<T>> {
    private final Iterator<HoodieRecord<T>> recordsIterator;

    public static HoodieFileSliceReader getFileSliceReader(Option<HoodieFileReader> baseFileReader, HoodieMergedLogRecordScanner scanner, Schema schema, Properties props, Option<Pair<String, String>> simpleKeyGenFieldsOpt) throws IOException {
        if (baseFileReader.isPresent()) {
            ClosableIterator baseIterator = baseFileReader.get().getRecordIterator(schema);
            while (baseIterator.hasNext()) {
                scanner.processNextRecord(((HoodieRecord)baseIterator.next()).wrapIntoHoodieRecordPayloadWithParams(schema, props, simpleKeyGenFieldsOpt, scanner.isWithOperationField(), scanner.getPartitionNameOverride(), false));
            }
        }
        return new HoodieFileSliceReader(scanner.iterator());
    }

    private HoodieFileSliceReader(Iterator<HoodieRecord<T>> recordsItr) {
        this.recordsIterator = recordsItr;
    }

    @Override
    public boolean hasNext() {
        return this.recordsIterator.hasNext();
    }

    @Override
    public HoodieRecord<T> next() {
        return this.recordsIterator.next();
    }
}

