/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.execution;

import java.util.Iterator;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.queue.HoodieExecutor;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.execution.HoodieLazyInsertIterable;
import org.apache.hudi.io.WriteHandleFactory;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.util.ExecutorFactory;

public class SparkLazyInsertIterable<T>
extends HoodieLazyInsertIterable<T> {
    private final boolean useWriterSchema;

    public SparkLazyInsertIterable(Iterator<HoodieRecord<T>> recordItr, boolean areRecordsSorted, HoodieWriteConfig config, String instantTime, HoodieTable hoodieTable, String idPrefix, TaskContextSupplier taskContextSupplier, WriteHandleFactory writeHandleFactory) {
        this(recordItr, areRecordsSorted, config, instantTime, hoodieTable, idPrefix, taskContextSupplier, false, writeHandleFactory);
    }

    public SparkLazyInsertIterable(Iterator<HoodieRecord<T>> recordItr, boolean areRecordsSorted, HoodieWriteConfig config, String instantTime, HoodieTable hoodieTable, String idPrefix, TaskContextSupplier taskContextSupplier, boolean useWriterSchema, WriteHandleFactory writeHandleFactory) {
        super(recordItr, areRecordsSorted, config, instantTime, hoodieTable, idPrefix, taskContextSupplier, writeHandleFactory);
        this.useWriterSchema = useWriterSchema;
    }

    @Override
    protected List<WriteStatus> computeNext() {
        HoodieExecutor<List<WriteStatus>> bufferedIteratorExecutor = null;
        try {
            List<WriteStatus> result;
            Schema schema = new Schema.Parser().parse(this.hoodieConfig.getSchema());
            if (this.useWriterSchema) {
                schema = HoodieAvroUtils.addMetadataFields(schema);
            }
            ValidationUtils.checkState((result = (bufferedIteratorExecutor = ExecutorFactory.create(this.hoodieConfig, this.inputItr, this.getInsertHandler(), SparkLazyInsertIterable.getTransformer(schema, this.hoodieConfig), this.hoodieTable.getPreExecuteRunnable())).execute()) != null && !result.isEmpty());
            List<WriteStatus> list = result;
            return list;
        }
        catch (Exception e) {
            throw new HoodieException(e);
        }
        finally {
            if (null != bufferedIteratorExecutor) {
                bufferedIteratorExecutor.shutdownNow();
                bufferedIteratorExecutor.awaitTermination();
            }
        }
    }
}

