/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index.bucket;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.model.HoodieClusteringGroup;
import org.apache.hudi.avro.model.HoodieClusteringPlan;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.fs.HoodieWrapperFileSystem;
import org.apache.hudi.common.model.ConsistentHashingNode;
import org.apache.hudi.common.model.HoodieConsistentHashingMetadata;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.ClusteringUtils;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.data.HoodieJavaRDD;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.HoodieIndexException;
import org.apache.hudi.index.bucket.BucketIndexLocationMapper;
import org.apache.hudi.index.bucket.ConsistentBucketIdentifier;
import org.apache.hudi.index.bucket.HoodieBucketIndex;
import org.apache.hudi.table.HoodieTable;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.api.java.function.VoidFunction;
import scala.Tuple2;

public class HoodieSparkConsistentBucketIndex
extends HoodieBucketIndex {
    private static final Logger LOG = LogManager.getLogger(HoodieSparkConsistentBucketIndex.class);

    public HoodieSparkConsistentBucketIndex(HoodieWriteConfig config) {
        super(config);
    }

    @Override
    public HoodieData<WriteStatus> updateLocation(HoodieData<WriteStatus> writeStatuses, HoodieEngineContext context, HoodieTable hoodieTable) throws HoodieIndexException {
        throw new HoodieIndexException("Consistent hashing index does not support update location without the instant parameter");
    }

    @Override
    public HoodieData<WriteStatus> updateLocation(HoodieData<WriteStatus> writeStatuses, HoodieEngineContext context, HoodieTable hoodieTable, String instantTime) throws HoodieIndexException {
        HoodieInstant instant = hoodieTable.getMetaClient().getActiveTimeline().findInstantsAfterOrEquals(instantTime, 1).firstInstant().get();
        ValidationUtils.checkState(instant.getTimestamp().equals(instantTime), "Cannot get the same instant, instantTime: " + instantTime);
        if (!instant.getAction().equals("replacecommit")) {
            return writeStatuses;
        }
        Option<Pair<HoodieInstant, HoodieClusteringPlan>> instantPlanPair = ClusteringUtils.getClusteringPlan(hoodieTable.getMetaClient(), HoodieTimeline.getReplaceCommitRequestedInstant(instantTime));
        if (!instantPlanPair.isPresent()) {
            return writeStatuses;
        }
        HoodieClusteringPlan plan = instantPlanPair.get().getRight();
        HoodieJavaRDD.getJavaRDD(context.parallelize(plan.getInputGroups().stream().map(HoodieClusteringGroup::getExtraMetadata).collect(Collectors.toList()))).mapToPair((PairFunction & Serializable)m -> new Tuple2(m.get("clustering.group.partition"), m)).groupByKey().foreach((VoidFunction & Serializable)input -> {
            String partition = (String)input._1();
            ArrayList<ConsistentHashingNode> childNodes = new ArrayList<ConsistentHashingNode>();
            int seqNo = 0;
            for (Map m : (Iterable)input._2()) {
                String nodesJson = (String)m.get("clustering.group.child.node");
                childNodes.addAll(ConsistentHashingNode.fromJsonString(nodesJson));
                seqNo = Integer.parseInt((String)m.get("clustering.group.sequence.no"));
            }
            Option<HoodieConsistentHashingMetadata> metadataOption = HoodieSparkConsistentBucketIndex.loadMetadata(hoodieTable, partition);
            ValidationUtils.checkState(metadataOption.isPresent(), "Failed to load metadata for partition: " + partition);
            HoodieConsistentHashingMetadata meta = metadataOption.get();
            ValidationUtils.checkState(meta.getSeqNo() == seqNo, "Non serialized update to hashing metadata, old seq: " + meta.getSeqNo() + ", new seq: " + seqNo);
            meta.setChildrenNodes(childNodes);
            List<ConsistentHashingNode> newNodes = new ConsistentBucketIdentifier(meta).getNodes().stream().map(n -> new ConsistentHashingNode(n.getValue(), n.getFileIdPrefix(), ConsistentHashingNode.NodeTag.NORMAL)).collect(Collectors.toList());
            HoodieConsistentHashingMetadata newMeta = new HoodieConsistentHashingMetadata(meta.getVersion(), meta.getPartitionPath(), instantTime, meta.getNumBuckets(), seqNo + 1, newNodes);
            HoodieSparkConsistentBucketIndex.saveMetadata(hoodieTable, newMeta, true);
        });
        return writeStatuses;
    }

    @Override
    public boolean rollbackCommit(String instantTime) {
        return true;
    }

    @Override
    protected BucketIndexLocationMapper getLocationMapper(HoodieTable table, List<String> partitionPath) {
        return new ConsistentBucketIndexLocationMapper(table, partitionPath);
    }

    public HoodieConsistentHashingMetadata loadOrCreateMetadata(HoodieTable table, String partition) {
        Option<HoodieConsistentHashingMetadata> metadataOption = HoodieSparkConsistentBucketIndex.loadMetadata(table, partition);
        if (metadataOption.isPresent()) {
            return metadataOption.get();
        }
        HoodieConsistentHashingMetadata metadata = new HoodieConsistentHashingMetadata(partition, this.numBuckets);
        if (HoodieSparkConsistentBucketIndex.saveMetadata(table, metadata, false)) {
            return metadata;
        }
        metadataOption = HoodieSparkConsistentBucketIndex.loadMetadata(table, partition);
        ValidationUtils.checkState(metadataOption.isPresent(), "Failed to load or create metadata, partition: " + partition);
        return metadataOption.get();
    }

    public static Option<HoodieConsistentHashingMetadata> loadMetadata(HoodieTable table, String partition) {
        Path metadataPath = FSUtils.getPartitionPath(table.getMetaClient().getHashingMetadataPath(), partition);
        Path partitionPath = FSUtils.getPartitionPath(table.getMetaClient().getBasePathV2(), partition);
        try {
            FileStatus maxMetadataFile;
            Predicate<FileStatus> hashingMetaCommitFilePredicate = fileStatus -> {
                String filename = fileStatus.getPath().getName();
                return filename.contains(".commit");
            };
            Predicate<FileStatus> hashingMetadataFilePredicate = fileStatus -> {
                String filename = fileStatus.getPath().getName();
                return filename.contains(".hashing_meta");
            };
            FileStatus[] metaFiles = table.getMetaClient().getFs().listStatus(metadataPath);
            TreeSet commitMetaTss = Arrays.stream(metaFiles).filter(hashingMetaCommitFilePredicate).map(commitFile -> HoodieConsistentHashingMetadata.getTimestampFromFile(commitFile.getPath().getName())).sorted().collect(Collectors.toCollection(TreeSet::new));
            FileStatus[] hashingMetaFiles = (FileStatus[])Arrays.stream(metaFiles).filter(hashingMetadataFilePredicate).sorted(Comparator.comparing(f -> f.getPath().getName())).toArray(FileStatus[]::new);
            String maxCommitMetaFileTs = commitMetaTss.isEmpty() ? null : (String)commitMetaTss.last();
            FileStatus fileStatus2 = maxMetadataFile = hashingMetaFiles.length > 0 ? hashingMetaFiles[hashingMetaFiles.length - 1] : null;
            if (maxMetadataFile != null && HoodieConsistentHashingMetadata.getTimestampFromFile(maxMetadataFile.getPath().getName()).equals("00000000000000")) {
                return HoodieSparkConsistentBucketIndex.loadMetadataFromGivenFile(table, maxMetadataFile);
            }
            if (maxCommitMetaFileTs != null && maxMetadataFile != null && maxCommitMetaFileTs.equals(HoodieConsistentHashingMetadata.getTimestampFromFile(maxMetadataFile.getPath().getName()))) {
                return HoodieSparkConsistentBucketIndex.loadMetadataFromGivenFile(table, maxMetadataFile);
            }
            HoodieTimeline completedCommits = table.getMetaClient().getActiveTimeline().getCommitTimeline().filterCompletedInstants();
            ArrayList fixed = new ArrayList();
            Arrays.stream(hashingMetaFiles).forEach(hashingMetaFile -> {
                boolean isRehashingCommitted;
                Path path = hashingMetaFile.getPath();
                String timestamp = HoodieConsistentHashingMetadata.getTimestampFromFile(path.getName());
                if (maxCommitMetaFileTs != null && timestamp.compareTo(maxCommitMetaFileTs) <= 0) {
                    return;
                }
                boolean bl = isRehashingCommitted = completedCommits.containsInstant(timestamp) || timestamp.equals("00000000000000");
                if (isRehashingCommitted) {
                    if (!commitMetaTss.contains(timestamp)) {
                        try {
                            HoodieSparkConsistentBucketIndex.createCommitMarker(table, path, partitionPath);
                        }
                        catch (IOException e) {
                            throw new HoodieIOException("Exception while creating marker file " + path.getName() + " for partition " + partition, e);
                        }
                    }
                    fixed.add(hashingMetaFile);
                } else if (HoodieSparkConsistentBucketIndex.recommitMetadataFile(table, hashingMetaFile, partition)) {
                    fixed.add(hashingMetaFile);
                }
            });
            return fixed.isEmpty() ? Option.empty() : HoodieSparkConsistentBucketIndex.loadMetadataFromGivenFile(table, (FileStatus)fixed.get(fixed.size() - 1));
        }
        catch (FileNotFoundException e) {
            return Option.empty();
        }
        catch (IOException e) {
            LOG.error((Object)("Error when loading hashing metadata, partition: " + partition), (Throwable)e);
            throw new HoodieIndexException("Error while loading hashing metadata", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean saveMetadata(HoodieTable table, HoodieConsistentHashingMetadata metadata, boolean overwrite) {
        HoodieWrapperFileSystem fs = table.getMetaClient().getFs();
        Path dir = FSUtils.getPartitionPath(table.getMetaClient().getHashingMetadataPath(), metadata.getPartitionPath());
        Path fullPath = new Path(dir, metadata.getFilename());
        try (FSDataOutputStream fsOut = fs.create(fullPath, overwrite);){
            byte[] bytes = metadata.toBytes();
            fsOut.write(bytes);
            fsOut.close();
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            LOG.warn((Object)("Failed to update bucket metadata: " + metadata), (Throwable)e);
            return false;
        }
    }

    private static void createCommitMarker(HoodieTable table, Path fileStatus, Path partitionPath) throws IOException {
        Path fullPath;
        HoodieWrapperFileSystem fs = table.getMetaClient().getFs();
        if (fs.exists(fullPath = new Path(partitionPath, HoodieConsistentHashingMetadata.getTimestampFromFile(fileStatus.getName()) + ".commit"))) {
            return;
        }
        FileIOUtils.createFileInPath(fs, fullPath, Option.of("".getBytes()));
    }

    private static Option<HoodieConsistentHashingMetadata> loadMetadataFromGivenFile(HoodieTable table, FileStatus metaFile) {
        try {
            if (metaFile == null) {
                return Option.empty();
            }
            byte[] content = FileIOUtils.readAsByteArray((InputStream)table.getMetaClient().getFs().open(metaFile.getPath()));
            return Option.of(HoodieConsistentHashingMetadata.fromBytes(content));
        }
        catch (FileNotFoundException e) {
            return Option.empty();
        }
        catch (IOException e) {
            LOG.error((Object)("Error when loading hashing metadata, for path: " + metaFile.getPath().getName()), (Throwable)e);
            throw new HoodieIndexException("Error while loading hashing metadata", e);
        }
    }

    private static boolean recommitMetadataFile(HoodieTable table, FileStatus metaFile, String partition) {
        Path partitionPath = FSUtils.getPartitionPath(table.getMetaClient().getBasePathV2(), partition);
        String timestamp = HoodieConsistentHashingMetadata.getTimestampFromFile(metaFile.getPath().getName());
        if (table.getPendingCommitTimeline().containsInstant(timestamp)) {
            return false;
        }
        Option<HoodieConsistentHashingMetadata> hoodieConsistentHashingMetadataOption = HoodieSparkConsistentBucketIndex.loadMetadataFromGivenFile(table, metaFile);
        if (!hoodieConsistentHashingMetadataOption.isPresent()) {
            return false;
        }
        HoodieConsistentHashingMetadata hoodieConsistentHashingMetadata = hoodieConsistentHashingMetadataOption.get();
        Predicate<String> hoodieFileGroupIdPredicate = hoodieBaseFile -> hoodieConsistentHashingMetadata.getNodes().stream().anyMatch(node -> node.getFileIdPrefix().equals(hoodieBaseFile));
        if (table.getBaseFileOnlyView().getLatestBaseFiles(partition).map(fileIdPrefix -> FSUtils.getFileIdPfxFromFileId(fileIdPrefix.getFileId())).anyMatch(hoodieFileGroupIdPredicate)) {
            try {
                HoodieSparkConsistentBucketIndex.createCommitMarker(table, metaFile.getPath(), partitionPath);
                return true;
            }
            catch (IOException e) {
                throw new HoodieIOException("Exception while creating marker file " + metaFile.getPath().getName() + " for partition " + partition, e);
            }
        }
        return false;
    }

    public class ConsistentBucketIndexLocationMapper
    implements BucketIndexLocationMapper {
        private final Map<String, ConsistentBucketIdentifier> partitionToIdentifier;

        public ConsistentBucketIndexLocationMapper(HoodieTable table, List<String> partitions) {
            this.partitionToIdentifier = partitions.stream().collect(Collectors.toMap(p -> p, p -> {
                HoodieConsistentHashingMetadata metadata = HoodieSparkConsistentBucketIndex.this.loadOrCreateMetadata(table, (String)p);
                return new ConsistentBucketIdentifier(metadata);
            }));
        }

        @Override
        public Option<HoodieRecordLocation> getRecordLocation(HoodieKey key) {
            String partitionPath = key.getPartitionPath();
            ConsistentHashingNode node = this.partitionToIdentifier.get(partitionPath).getBucket(key, HoodieSparkConsistentBucketIndex.this.indexKeyFields);
            if (!StringUtils.isNullOrEmpty(node.getFileIdPrefix())) {
                return Option.of(new HoodieRecordLocation(null, FSUtils.createNewFileId(node.getFileIdPrefix(), 0)));
            }
            LOG.error((Object)("Consistent hashing node has no file group, partition: " + partitionPath + ", meta: " + this.partitionToIdentifier.get(partitionPath).getMetadata().getFilename() + ", record_key: " + key.toString()));
            throw new HoodieIndexException("Failed to getBucket as hashing node has no file group");
        }
    }
}

