/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.avro.Schema;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieUpsertException;
import org.apache.hudi.io.HoodieMergeHandle;
import org.apache.hudi.keygen.BaseKeyGenerator;
import org.apache.hudi.table.HoodieTable;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

@NotThreadSafe
public class HoodieConcatHandle<T, I, K, O>
extends HoodieMergeHandle<T, I, K, O> {
    private static final Logger LOG = LogManager.getLogger(HoodieConcatHandle.class);
    private final Iterator<HoodieRecord<T>> recordItr;

    public HoodieConcatHandle(HoodieWriteConfig config, String instantTime, HoodieTable<T, I, K, O> hoodieTable, Iterator<HoodieRecord<T>> recordItr, String partitionPath, String fileId, TaskContextSupplier taskContextSupplier, Option<BaseKeyGenerator> keyGeneratorOpt) {
        super(config, instantTime, hoodieTable, Collections.emptyIterator(), partitionPath, fileId, taskContextSupplier, keyGeneratorOpt);
        this.recordItr = recordItr;
    }

    public HoodieConcatHandle(HoodieWriteConfig config, String instantTime, HoodieTable hoodieTable, Map<String, HoodieRecord<T>> keyToNewRecords, String partitionPath, String fileId, HoodieBaseFile dataFileToBeMerged, TaskContextSupplier taskContextSupplier) {
        super(config, instantTime, hoodieTable, Collections.emptyMap(), partitionPath, fileId, dataFileToBeMerged, taskContextSupplier, Option.empty());
        this.recordItr = keyToNewRecords.values().iterator();
    }

    @Override
    public void write(HoodieRecord oldRecord) {
        Schema oldSchema = this.config.populateMetaFields() ? this.writeSchemaWithMetaFields : this.writeSchema;
        String key = oldRecord.getRecordKey(oldSchema, this.keyGeneratorOpt);
        try {
            this.writeToFile(new HoodieKey(key, this.partitionPath), oldRecord, oldSchema, this.config.getPayloadConfig().getProps(), true);
        }
        catch (IOException | RuntimeException e) {
            String errMsg = String.format("Failed to write old record into new file for key %s from old file %s to new file %s with writerSchema %s", key, this.getOldFilePath(), this.newFilePath, this.writeSchemaWithMetaFields.toString(true));
            LOG.debug((Object)("Old record is " + oldRecord));
            throw new HoodieUpsertException(errMsg, e);
        }
        ++this.recordsWritten;
    }

    @Override
    protected void writeIncomingRecords() throws IOException {
        while (this.recordItr.hasNext()) {
            HoodieRecord<T> record = this.recordItr.next();
            if (this.needsUpdateLocation()) {
                record.unseal();
                record.setNewLocation(new HoodieRecordLocation(this.instantTime, this.fileId));
                record.seal();
            }
            this.writeInsertRecord(record);
        }
    }
}

