/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import java.io.IOException;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.MetadataValues;
import org.apache.hudi.common.util.ClosableIterator;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.io.storage.HoodieFileReader;

public abstract class HoodieBootstrapFileReader<T>
implements HoodieFileReader<T> {
    private final HoodieFileReader<T> skeletonFileReader;
    private final HoodieFileReader<T> dataFileReader;
    private final Option<String[]> partitionFields;
    private final Object[] partitionValues;

    public HoodieBootstrapFileReader(HoodieFileReader<T> skeletonFileReader, HoodieFileReader<T> dataFileReader, Option<String[]> partitionFields, Object[] partitionValues) {
        this.skeletonFileReader = skeletonFileReader;
        this.dataFileReader = dataFileReader;
        this.partitionFields = partitionFields;
        this.partitionValues = partitionValues;
    }

    @Override
    public String[] readMinMaxRecordKeys() {
        return this.skeletonFileReader.readMinMaxRecordKeys();
    }

    @Override
    public BloomFilter readBloomFilter() {
        return this.skeletonFileReader.readBloomFilter();
    }

    @Override
    public Set<String> filterRowKeys(Set<String> candidateRowKeys) {
        return this.skeletonFileReader.filterRowKeys(candidateRowKeys);
    }

    @Override
    public ClosableIterator<HoodieRecord<T>> getRecordIterator(final Schema readerSchema, Schema requestedSchema) throws IOException {
        final ClosableIterator<HoodieRecord<T>> skeletonIterator = this.skeletonFileReader.getRecordIterator(readerSchema, requestedSchema);
        final ClosableIterator<HoodieRecord<T>> dataFileIterator = this.dataFileReader.getRecordIterator(HoodieAvroUtils.removeMetadataFields(readerSchema), requestedSchema);
        return new ClosableIterator<HoodieRecord<T>>(){

            @Override
            public void close() {
                skeletonIterator.close();
                dataFileIterator.close();
            }

            @Override
            public boolean hasNext() {
                return skeletonIterator.hasNext() && dataFileIterator.hasNext();
            }

            @Override
            public HoodieRecord<T> next() {
                HoodieRecord dataRecord = (HoodieRecord)dataFileIterator.next();
                HoodieRecord skeletonRecord = (HoodieRecord)skeletonIterator.next();
                HoodieRecord ret = dataRecord.prependMetaFields(readerSchema, readerSchema, new MetadataValues().setCommitTime(skeletonRecord.getRecordKey(readerSchema, HoodieRecord.COMMIT_TIME_METADATA_FIELD)).setCommitSeqno(skeletonRecord.getRecordKey(readerSchema, HoodieRecord.COMMIT_SEQNO_METADATA_FIELD)).setRecordKey(skeletonRecord.getRecordKey(readerSchema, HoodieRecord.RECORD_KEY_METADATA_FIELD)).setPartitionPath(skeletonRecord.getRecordKey(readerSchema, HoodieRecord.PARTITION_PATH_METADATA_FIELD)).setFileName(skeletonRecord.getRecordKey(readerSchema, HoodieRecord.FILENAME_METADATA_FIELD)), null);
                if (HoodieBootstrapFileReader.this.partitionFields.isPresent()) {
                    for (int i = 0; i < HoodieBootstrapFileReader.this.partitionValues.length; ++i) {
                        int position = readerSchema.getField(((String[])HoodieBootstrapFileReader.this.partitionFields.get())[i]).pos();
                        HoodieBootstrapFileReader.this.setPartitionField(position, HoodieBootstrapFileReader.this.partitionValues[i], ret.getData());
                    }
                }
                return ret;
            }
        };
    }

    protected abstract void setPartitionField(int var1, Object var2, T var3);

    @Override
    public Schema getSchema() {
        return HoodieAvroUtils.addMetadataFields(this.dataFileReader.getSchema());
    }

    @Override
    public void close() {
        this.skeletonFileReader.close();
        this.dataFileReader.close();
    }

    @Override
    public long getTotalRecords() {
        return Math.min(this.skeletonFileReader.getTotalRecords(), this.dataFileReader.getTotalRecords());
    }
}

