/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.io.storage.HoodieFileReader;
import org.apache.hudi.io.storage.HoodieFileReaderFactory;
import org.apache.hudi.io.storage.HoodieSparkBootstrapFileReader;
import org.apache.hudi.io.storage.HoodieSparkParquetReader;
import org.apache.spark.sql.internal.SQLConf;

public class HoodieSparkFileReaderFactory
extends HoodieFileReaderFactory {
    @Override
    protected HoodieFileReader newParquetFileReader(Configuration conf, Path path) {
        conf.setIfUnset(SQLConf.PARQUET_BINARY_AS_STRING().key(), SQLConf.PARQUET_BINARY_AS_STRING().defaultValueString());
        conf.setIfUnset(SQLConf.PARQUET_INT96_AS_TIMESTAMP().key(), SQLConf.PARQUET_INT96_AS_TIMESTAMP().defaultValueString());
        conf.setIfUnset(SQLConf.CASE_SENSITIVE().key(), SQLConf.CASE_SENSITIVE().defaultValueString());
        conf.setIfUnset("spark.sql.legacy.parquet.nanosAsLong", "false");
        return new HoodieSparkParquetReader(conf, path);
    }

    @Override
    protected HoodieFileReader newHFileFileReader(Configuration conf, Path path) throws IOException {
        throw new HoodieIOException("Not support read HFile");
    }

    @Override
    protected HoodieFileReader newOrcFileReader(Configuration conf, Path path) {
        throw new HoodieIOException("Not support read orc file");
    }

    @Override
    public HoodieFileReader newBootstrapFileReader(HoodieFileReader skeletonFileReader, HoodieFileReader dataFileReader, Option<String[]> partitionFields, Object[] partitionValues) {
        return new HoodieSparkBootstrapFileReader(skeletonFileReader, dataFileReader, partitionFields, partitionValues);
    }
}

