/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.model.HoodieMetadataColumnStats;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.config.SerializableConfiguration;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodiePartitionMetadata;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.HoodieMetadataException;
import org.apache.hudi.metadata.HoodieMetadataPayload;
import org.apache.hudi.metadata.HoodieTableMetadata;

public class FileSystemBackedTableMetadata
implements HoodieTableMetadata {
    private static final int DEFAULT_LISTING_PARALLELISM = 1500;
    private final transient HoodieEngineContext engineContext;
    private final SerializableConfiguration hadoopConf;
    private final String datasetBasePath;
    private final boolean assumeDatePartitioning;

    public FileSystemBackedTableMetadata(HoodieEngineContext engineContext, SerializableConfiguration conf, String datasetBasePath, boolean assumeDatePartitioning) {
        this.engineContext = engineContext;
        this.hadoopConf = conf;
        this.datasetBasePath = datasetBasePath;
        this.assumeDatePartitioning = assumeDatePartitioning;
    }

    @Override
    public FileStatus[] getAllFilesInPartition(Path partitionPath) throws IOException {
        FileSystem fs = partitionPath.getFileSystem(this.hadoopConf.get());
        return FSUtils.getAllDataFilesInPartition(fs, partitionPath);
    }

    @Override
    public List<String> getAllPartitionPaths() throws IOException {
        Path basePath = new Path(this.datasetBasePath);
        FileSystem fs = basePath.getFileSystem(this.hadoopConf.get());
        if (this.assumeDatePartitioning) {
            return FSUtils.getAllPartitionFoldersThreeLevelsDown(fs, this.datasetBasePath);
        }
        return this.getPartitionPathWithPathPrefixes(Collections.singletonList(""));
    }

    @Override
    public List<String> getPartitionPathWithPathPrefixes(List<String> relativePathPrefixes) {
        return relativePathPrefixes.stream().flatMap(relativePathPrefix -> {
            try {
                return this.getPartitionPathWithPathPrefix((String)relativePathPrefix).stream();
            }
            catch (IOException e) {
                throw new HoodieIOException("Error fetching partition paths with relative path: " + relativePathPrefix, e);
            }
        }).collect(Collectors.toList());
    }

    private List<String> getPartitionPathWithPathPrefix(String relativePathPrefix) throws IOException {
        CopyOnWriteArrayList<Path> pathsToList = new CopyOnWriteArrayList<Path>();
        pathsToList.add(StringUtils.isNullOrEmpty(relativePathPrefix) ? new Path(this.datasetBasePath) : new Path(this.datasetBasePath, relativePathPrefix));
        CopyOnWriteArrayList<String> partitionPaths = new CopyOnWriteArrayList<String>();
        while (!pathsToList.isEmpty()) {
            int listingParallelism = Math.min(1500, pathsToList.size());
            List dirToFileListing = this.engineContext.flatMap(pathsToList, path -> {
                FileSystem fileSystem2 = path.getFileSystem(this.hadoopConf.get());
                return Arrays.stream(fileSystem2.listStatus(path));
            }, listingParallelism);
            pathsToList.clear();
            int fileListingParallelism = Math.min(1500, dirToFileListing.size());
            if (dirToFileListing.isEmpty()) continue;
            List<Pair> result = this.engineContext.map(dirToFileListing, fileStatus -> {
                FileSystem fileSystem2 = fileStatus.getPath().getFileSystem(this.hadoopConf.get());
                if (fileStatus.isDirectory()) {
                    if (HoodiePartitionMetadata.hasPartitionMetadata(fileSystem2, fileStatus.getPath())) {
                        return Pair.of(Option.of(FSUtils.getRelativePartitionPath(new Path(this.datasetBasePath), fileStatus.getPath())), Option.empty());
                    }
                    if (!fileStatus.getPath().getName().equals(".hoodie")) {
                        return Pair.of(Option.empty(), Option.of(fileStatus.getPath()));
                    }
                } else if (fileStatus.getPath().getName().startsWith(".hoodie_partition_metadata")) {
                    String partitionName = FSUtils.getRelativePartitionPath(new Path(this.datasetBasePath), fileStatus.getPath().getParent());
                    return Pair.of(Option.of(partitionName), Option.empty());
                }
                return Pair.of(Option.empty(), Option.empty());
            }, fileListingParallelism);
            partitionPaths.addAll(result.stream().filter(entry -> ((Option)entry.getKey()).isPresent()).map(entry -> (String)((Option)entry.getKey()).get()).collect(Collectors.toList()));
            pathsToList.addAll(result.stream().filter(entry -> ((Option)entry.getValue()).isPresent()).map(entry -> (Path)((Option)entry.getValue()).get()).collect(Collectors.toList()));
        }
        return partitionPaths;
    }

    @Override
    public Map<String, FileStatus[]> getAllFilesInPartitions(Collection<String> partitionPaths) throws IOException {
        if (partitionPaths == null || partitionPaths.isEmpty()) {
            return Collections.emptyMap();
        }
        int parallelism = Math.min(1500, partitionPaths.size());
        List<Pair> partitionToFiles = this.engineContext.map(new ArrayList<String>(partitionPaths), partitionPathStr -> {
            Path partitionPath = new Path(partitionPathStr);
            FileSystem fs = partitionPath.getFileSystem(this.hadoopConf.get());
            return Pair.of(partitionPathStr, FSUtils.getAllDataFilesInPartition(fs, partitionPath));
        }, parallelism);
        return partitionToFiles.stream().collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
    }

    @Override
    public Option<String> getSyncedInstantTime() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Option<String> getLatestCompactionTime() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public void reset() {
    }

    @Override
    public Option<BloomFilter> getBloomFilter(String partitionName, String fileName) throws HoodieMetadataException {
        throw new HoodieMetadataException("Unsupported operation: getBloomFilter for " + fileName);
    }

    @Override
    public Map<Pair<String, String>, BloomFilter> getBloomFilters(List<Pair<String, String>> partitionNameFileNameList) throws HoodieMetadataException {
        throw new HoodieMetadataException("Unsupported operation: getBloomFilters!");
    }

    @Override
    public Map<Pair<String, String>, HoodieMetadataColumnStats> getColumnStats(List<Pair<String, String>> partitionNameFileNameList, String columnName) throws HoodieMetadataException {
        throw new HoodieMetadataException("Unsupported operation: getColumnsStats!");
    }

    @Override
    public HoodieData<HoodieRecord<HoodieMetadataPayload>> getRecordsByKeyPrefixes(List<String> keyPrefixes, String partitionName, boolean shouldLoadInMemory) {
        throw new HoodieMetadataException("Unsupported operation: getRecordsByKeyPrefixes!");
    }
}

