/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.avro.model.HoodieRestoreMetadata;
import org.apache.hudi.avro.model.HoodieRollbackMetadata;
import org.apache.hudi.avro.model.HoodieRollbackPlan;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.io.HoodieAppendHandle;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.hudi.table.HoodieCompactionHandler;
import org.apache.hudi.table.HoodieSparkCopyOnWriteTable;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.hudi.table.action.bootstrap.HoodieBootstrapWriteMetadata;
import org.apache.hudi.table.action.bootstrap.SparkBootstrapDeltaCommitActionExecutor;
import org.apache.hudi.table.action.compact.HoodieSparkMergeOnReadTableCompactor;
import org.apache.hudi.table.action.compact.RunCompactionActionExecutor;
import org.apache.hudi.table.action.compact.ScheduleCompactionActionExecutor;
import org.apache.hudi.table.action.deltacommit.SparkBulkInsertDeltaCommitActionExecutor;
import org.apache.hudi.table.action.deltacommit.SparkBulkInsertPreppedDeltaCommitActionExecutor;
import org.apache.hudi.table.action.deltacommit.SparkDeleteDeltaCommitActionExecutor;
import org.apache.hudi.table.action.deltacommit.SparkInsertDeltaCommitActionExecutor;
import org.apache.hudi.table.action.deltacommit.SparkInsertPreppedDeltaCommitActionExecutor;
import org.apache.hudi.table.action.deltacommit.SparkUpsertDeltaCommitActionExecutor;
import org.apache.hudi.table.action.deltacommit.SparkUpsertPreppedDeltaCommitActionExecutor;
import org.apache.hudi.table.action.restore.MergeOnReadRestoreActionExecutor;
import org.apache.hudi.table.action.rollback.BaseRollbackPlanActionExecutor;
import org.apache.hudi.table.action.rollback.MergeOnReadRollbackActionExecutor;
import org.apache.hudi.table.action.rollback.RestorePlanActionExecutor;

public class HoodieSparkMergeOnReadTable<T>
extends HoodieSparkCopyOnWriteTable<T>
implements HoodieCompactionHandler<T> {
    HoodieSparkMergeOnReadTable(HoodieWriteConfig config, HoodieEngineContext context, HoodieTableMetaClient metaClient) {
        super(config, context, metaClient);
    }

    @Override
    public HoodieWriteMetadata<HoodieData<WriteStatus>> upsert(HoodieEngineContext context, String instantTime, HoodieData<HoodieRecord<T>> records) {
        return new SparkUpsertDeltaCommitActionExecutor<T>((HoodieSparkEngineContext)context, this.config, (HoodieTable)this, instantTime, records).execute();
    }

    @Override
    public HoodieWriteMetadata<HoodieData<WriteStatus>> insert(HoodieEngineContext context, String instantTime, HoodieData<HoodieRecord<T>> records) {
        return new SparkInsertDeltaCommitActionExecutor<T>((HoodieSparkEngineContext)context, this.config, (HoodieTable)this, instantTime, records).execute();
    }

    @Override
    public HoodieWriteMetadata<HoodieData<WriteStatus>> bulkInsert(HoodieEngineContext context, String instantTime, HoodieData<HoodieRecord<T>> records, Option<BulkInsertPartitioner> userDefinedBulkInsertPartitioner) {
        return new SparkBulkInsertDeltaCommitActionExecutor<T>((HoodieSparkEngineContext)context, this.config, (HoodieTable)this, instantTime, records, userDefinedBulkInsertPartitioner).execute();
    }

    @Override
    public HoodieWriteMetadata<HoodieData<WriteStatus>> delete(HoodieEngineContext context, String instantTime, HoodieData<HoodieKey> keys2) {
        return new SparkDeleteDeltaCommitActionExecutor((HoodieSparkEngineContext)context, this.config, (HoodieTable)this, instantTime, keys2).execute();
    }

    @Override
    public HoodieWriteMetadata<HoodieData<WriteStatus>> upsertPrepped(HoodieEngineContext context, String instantTime, HoodieData<HoodieRecord<T>> preppedRecords) {
        return new SparkUpsertPreppedDeltaCommitActionExecutor<T>((HoodieSparkEngineContext)context, this.config, (HoodieTable)this, instantTime, preppedRecords).execute();
    }

    @Override
    public HoodieWriteMetadata<HoodieData<WriteStatus>> insertPrepped(HoodieEngineContext context, String instantTime, HoodieData<HoodieRecord<T>> preppedRecords) {
        return new SparkInsertPreppedDeltaCommitActionExecutor<T>((HoodieSparkEngineContext)context, this.config, (HoodieTable)this, instantTime, preppedRecords).execute();
    }

    @Override
    public HoodieWriteMetadata<HoodieData<WriteStatus>> bulkInsertPrepped(HoodieEngineContext context, String instantTime, HoodieData<HoodieRecord<T>> preppedRecords, Option<BulkInsertPartitioner> userDefinedBulkInsertPartitioner) {
        return new SparkBulkInsertPreppedDeltaCommitActionExecutor<T>((HoodieSparkEngineContext)context, this.config, (HoodieTable)this, instantTime, preppedRecords, userDefinedBulkInsertPartitioner).execute();
    }

    @Override
    public Option<HoodieCompactionPlan> scheduleCompaction(HoodieEngineContext context, String instantTime, Option<Map<String, String>> extraMetadata) {
        ScheduleCompactionActionExecutor scheduleCompactionExecutor = new ScheduleCompactionActionExecutor(context, this.config, this, instantTime, extraMetadata, WriteOperationType.COMPACT);
        return scheduleCompactionExecutor.execute();
    }

    @Override
    public HoodieWriteMetadata<HoodieData<WriteStatus>> compact(HoodieEngineContext context, String compactionInstantTime) {
        RunCompactionActionExecutor compactionExecutor = new RunCompactionActionExecutor(context, this.config, this, compactionInstantTime, new HoodieSparkMergeOnReadTableCompactor(), new HoodieSparkCopyOnWriteTable(this.config, context, this.getMetaClient()), WriteOperationType.COMPACT);
        return compactionExecutor.execute();
    }

    @Override
    public HoodieBootstrapWriteMetadata<HoodieData<WriteStatus>> bootstrap(HoodieEngineContext context, Option<Map<String, String>> extraMetadata) {
        return new SparkBootstrapDeltaCommitActionExecutor((HoodieSparkEngineContext)context, this.config, (HoodieTable)this, extraMetadata).execute();
    }

    @Override
    public Option<HoodieCompactionPlan> scheduleLogCompaction(HoodieEngineContext context, String instantTime, Option<Map<String, String>> extraMetadata) {
        ScheduleCompactionActionExecutor scheduleLogCompactionExecutor = new ScheduleCompactionActionExecutor(context, this.config, this, instantTime, extraMetadata, WriteOperationType.LOG_COMPACT);
        return scheduleLogCompactionExecutor.execute();
    }

    @Override
    public HoodieWriteMetadata<HoodieData<WriteStatus>> logCompact(HoodieEngineContext context, String logCompactionInstantTime) {
        RunCompactionActionExecutor logCompactionExecutor = new RunCompactionActionExecutor(context, this.config, this, logCompactionInstantTime, new HoodieSparkMergeOnReadTableCompactor(), this, WriteOperationType.LOG_COMPACT);
        return logCompactionExecutor.execute();
    }

    @Override
    public void rollbackBootstrap(HoodieEngineContext context, String instantTime) {
        new RestorePlanActionExecutor(context, this.config, this, instantTime, "00000000000000").execute();
        new MergeOnReadRestoreActionExecutor(context, this.config, this, instantTime, "00000000000000").execute();
    }

    @Override
    public Option<HoodieRollbackPlan> scheduleRollback(HoodieEngineContext context, String instantTime, HoodieInstant instantToRollback, boolean skipTimelinePublish, boolean shouldRollbackUsingMarkers) {
        return new BaseRollbackPlanActionExecutor(context, this.config, this, instantTime, instantToRollback, skipTimelinePublish, shouldRollbackUsingMarkers).execute();
    }

    @Override
    public Iterator<List<WriteStatus>> handleInsertsForLogCompaction(String instantTime, String partitionPath, String fileId, Map<String, HoodieRecord<?>> recordMap, Map<HoodieLogBlock.HeaderMetadataType, String> header) {
        HoodieAppendHandle appendHandle = new HoodieAppendHandle(this.config, instantTime, this, partitionPath, fileId, recordMap.values().iterator(), this.taskContextSupplier, header);
        appendHandle.write(recordMap);
        List<WriteStatus> writeStatuses = appendHandle.close();
        return Collections.singletonList(writeStatuses).iterator();
    }

    @Override
    public HoodieRollbackMetadata rollback(HoodieEngineContext context, String rollbackInstantTime, HoodieInstant commitInstant, boolean deleteInstants, boolean skipLocking) {
        return new MergeOnReadRollbackActionExecutor(context, this.config, this, rollbackInstantTime, commitInstant, deleteInstants, skipLocking).execute();
    }

    @Override
    public HoodieRestoreMetadata restore(HoodieEngineContext context, String restoreInstantTimestamp, String savepointToRestoreTimestamp) {
        return new MergeOnReadRestoreActionExecutor(context, this.config, this, restoreInstantTimestamp, savepointToRestoreTimestamp).execute();
    }

    @Override
    public void finalizeWrite(HoodieEngineContext context, String instantTs, List<HoodieWriteStat> stats) throws HoodieIOException {
        super.finalizeWrite(context, instantTs, stats);
    }
}

