/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.bootstrap;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.avro.model.HoodieFileStatus;
import org.apache.hudi.client.bootstrap.BootstrapWriteStatus;
import org.apache.hudi.common.bootstrap.FileStatusUtils;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.BootstrapFileMapping;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.io.HoodieBootstrapHandle;
import org.apache.hudi.keygen.KeyGeneratorInterface;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.bootstrap.BootstrapMetadataHandler;
import org.apache.hudi.table.action.bootstrap.ParquetBootstrapMetadataHandler;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public abstract class BaseBootstrapMetadataHandler
implements BootstrapMetadataHandler {
    private static final Logger LOG = LogManager.getLogger(ParquetBootstrapMetadataHandler.class);
    protected HoodieWriteConfig config;
    protected HoodieTable table;
    protected HoodieFileStatus srcFileStatus;

    public BaseBootstrapMetadataHandler(HoodieWriteConfig config, HoodieTable table, HoodieFileStatus srcFileStatus) {
        this.config = config;
        this.table = table;
        this.srcFileStatus = srcFileStatus;
    }

    @Override
    public BootstrapWriteStatus runMetadataBootstrap(String srcPartitionPath, String partitionPath, KeyGeneratorInterface keyGenerator) {
        Path sourceFilePath = FileStatusUtils.toPath(this.srcFileStatus.getPath());
        HoodieBootstrapHandle bootstrapHandle = new HoodieBootstrapHandle(this.config, "00000000000001", this.table, partitionPath, FSUtils.createNewFileIdPfx(), this.table.getTaskContextSupplier());
        try {
            Schema avroSchema = this.getAvroSchema(sourceFilePath);
            List<String> recordKeyColumns = keyGenerator.getRecordKeyFieldNames().stream().map(HoodieAvroUtils::getRootLevelFieldName).collect(Collectors.toList());
            Schema recordKeySchema = HoodieAvroUtils.generateProjectionSchema(avroSchema, recordKeyColumns);
            LOG.info((Object)("Schema to be used for reading record keys: " + recordKeySchema));
            this.executeBootstrap(bootstrapHandle, sourceFilePath, keyGenerator, partitionPath, recordKeySchema);
        }
        catch (Exception e) {
            throw new HoodieException(e.getMessage(), e);
        }
        BootstrapWriteStatus writeStatus = (BootstrapWriteStatus)bootstrapHandle.writeStatuses().get(0);
        BootstrapFileMapping bootstrapFileMapping = new BootstrapFileMapping(this.config.getBootstrapSourceBasePath(), srcPartitionPath, partitionPath, this.srcFileStatus, writeStatus.getFileId());
        writeStatus.setBootstrapSourceFileMapping(bootstrapFileMapping);
        return writeStatus;
    }

    abstract Schema getAvroSchema(Path var1) throws IOException;

    abstract void executeBootstrap(HoodieBootstrapHandle<?, ?, ?, ?> var1, Path var2, KeyGeneratorInterface var3, String var4, Schema var5) throws Exception;
}

