/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.rollback;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.model.HoodieRollbackRequest;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.IOType;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieRollbackException;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.rollback.BaseRollbackPlanActionExecutor;
import org.apache.hudi.table.marker.MarkerBasedRollbackUtils;
import org.apache.hudi.table.marker.WriteMarkers;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class MarkerBasedRollbackStrategy<T, I, K, O>
implements BaseRollbackPlanActionExecutor.RollbackStrategy {
    private static final Logger LOG = LogManager.getLogger(MarkerBasedRollbackStrategy.class);
    protected final HoodieTable<?, ?, ?, ?> table;
    protected final transient HoodieEngineContext context;
    protected final HoodieWriteConfig config;
    protected final String basePath;
    protected final String instantTime;

    public MarkerBasedRollbackStrategy(HoodieTable<?, ?, ?, ?> table, HoodieEngineContext context, HoodieWriteConfig config, String instantTime) {
        this.table = table;
        this.context = context;
        this.basePath = table.getMetaClient().getBasePath();
        this.config = config;
        this.instantTime = instantTime;
    }

    @Override
    public List<HoodieRollbackRequest> getRollbackRequests(HoodieInstant instantToRollback) {
        try {
            List<String> markerPaths = MarkerBasedRollbackUtils.getAllMarkerPaths(this.table, this.context, instantToRollback.getTimestamp(), this.config.getRollbackParallelism());
            int parallelism = Math.max(Math.min(markerPaths.size(), this.config.getRollbackParallelism()), 1);
            return this.context.map(markerPaths, markerFilePath -> {
                String typeStr = markerFilePath.substring(markerFilePath.lastIndexOf(".") + 1);
                IOType type = IOType.valueOf(typeStr);
                switch (type) {
                    case MERGE: 
                    case CREATE: {
                        String fileToDelete = WriteMarkers.stripMarkerSuffix(markerFilePath);
                        Path fullDeletePath = new Path(this.basePath, fileToDelete);
                        String partitionPath = FSUtils.getRelativePartitionPath(new Path(this.basePath), fullDeletePath.getParent());
                        return new HoodieRollbackRequest(partitionPath, "", "", Collections.singletonList(fullDeletePath.toString()), Collections.emptyMap());
                    }
                    case APPEND: {
                        return this.getRollbackRequestForAppend(instantToRollback, WriteMarkers.stripMarkerSuffix(markerFilePath));
                    }
                }
                throw new HoodieRollbackException("Unknown marker type, during rollback of " + instantToRollback);
            }, parallelism);
        }
        catch (Exception e) {
            throw new HoodieRollbackException("Error rolling back using marker files written for " + instantToRollback, e);
        }
    }

    protected HoodieRollbackRequest getRollbackRequestForAppend(HoodieInstant instantToRollback, String markerFilePath) throws IOException {
        Path baseFilePathForAppend = new Path(this.basePath, markerFilePath);
        String fileId = FSUtils.getFileIdFromFilePath(baseFilePathForAppend);
        String baseCommitTime = FSUtils.getCommitTime(baseFilePathForAppend.getName());
        String relativePartitionPath = FSUtils.getRelativePartitionPath(new Path(this.basePath), baseFilePathForAppend.getParent());
        Path partitionPath = FSUtils.getPartitionPath(this.config.getBasePath(), relativePartitionPath);
        Option<HoodieLogFile> latestLogFileOption = FSUtils.getLatestLogFile(this.table.getMetaClient().getFs(), partitionPath, fileId, HoodieFileFormat.HOODIE_LOG.getFileExtension(), baseCommitTime);
        if (latestLogFileOption.isPresent() && baseCommitTime.equals(instantToRollback.getTimestamp())) {
            Path fullDeletePath = new Path(partitionPath, latestLogFileOption.get().getFileName());
            return new HoodieRollbackRequest(relativePartitionPath, "", "", Collections.singletonList(fullDeletePath.toString()), Collections.emptyMap());
        }
        Map<String, Long> logFilesWithBlocsToRollback = new HashMap<String, Long>();
        if (latestLogFileOption.isPresent()) {
            HoodieLogFile latestLogFile = latestLogFileOption.get();
            logFilesWithBlocsToRollback = Collections.singletonMap(latestLogFile.getFileStatus().getPath().toString(), -1L);
        }
        return new HoodieRollbackRequest(relativePartitionPath, fileId, baseCommitTime, Collections.emptyList(), logFilesWithBlocsToRollback);
    }
}

