/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.plans.logcal;

import java.io.Serializable;
import org.apache.hudi.DefaultSource;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.plans.logcal.HoodieQuery;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.sources.BaseRelation;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.MapLike;

public final class HoodieQuery$
implements scala.Serializable {
    public static HoodieQuery$ MODULE$;
    private final String FUNC_NAME;

    static {
        new HoodieQuery$();
    }

    public String FUNC_NAME() {
        return this.FUNC_NAME;
    }

    public LogicalPlan resolve(SparkSession spark, HoodieQuery func) {
        Seq<Expression> args2 = func.args();
        Expression qual$1 = (Expression)args2.head();
        InternalRow x$1 = qual$1.eval$default$1();
        TableIdentifier identifier = spark.sessionState().sqlParser().parseTableIdentifier(qual$1.eval(x$1).toString());
        CatalogTable catalogTable = spark.sessionState().catalog().getTableMetadata(identifier);
        Map options = ((MapLike)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)catalogTable.location().toString())}))).$plus$plus(this.parseOptions((Seq<Expression>)((Seq)args2.tail())));
        DefaultSource hoodieDataSource = new DefaultSource();
        BaseRelation relation = hoodieDataSource.createRelation(spark.sqlContext(), (scala.collection.immutable.Map<String, String>)options.toMap(Predef$.MODULE$.$conforms()));
        return new LogicalRelation(relation, relation.schema().toAttributes(), (Option)new Some((Object)catalogTable), false);
    }

    private scala.collection.immutable.Map<String, String> parseOptions(Seq<Expression> args2) {
        Map options = Map$.MODULE$.empty();
        Expression qual$1 = (Expression)args2.head();
        InternalRow x$12 = qual$1.eval$default$1();
        String queryMode = qual$1.eval(x$12).toString();
        Seq instants = (Seq)((TraversableLike)args2.tail()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.eval(x$1.eval$default$1()).toString(), Seq$.MODULE$.canBuildFrom());
        String string = queryMode;
        if (!"read_optimized".equals(string)) {
            throw new AnalysisException("hudi_query doesn't support other query modes for now.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
        }
        Predef$.MODULE$.assert(instants.isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "No expressions have to be provided in read_optimized mode.");
        Map map = (Map)options.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.datasource.query.type"), (Object)"read_optimized"));
        return options.toMap(Predef$.MODULE$.$conforms());
    }

    public HoodieQuery apply(Seq<Expression> args2) {
        return new HoodieQuery(args2);
    }

    public Option<Seq<Expression>> unapply(HoodieQuery x$0) {
        return x$0 == null ? None$.MODULE$ : new Some(x$0.args());
    }

    private Object readResolve() {
        return MODULE$;
    }

    private HoodieQuery$() {
        MODULE$ = this;
        this.FUNC_NAME = "hudi_query";
    }
}

