/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.PartitionPathEncodeUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.keygen.BaseKeyGenerator;
import org.apache.hudi.keygen.BuiltinKeyGenerator;
import org.apache.hudi.keygen.ComplexKeyGenerator;
import org.apache.hudi.keygen.KeyGenUtils;
import org.apache.hudi.keygen.SparkKeyGeneratorInterface;
import org.apache.hudi.keygen.factory.HoodieSparkKeyGeneratorFactory;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.hudi.command.SqlKeyGenerator$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001df\u0001\u0002\u000f\u001e\u0001)B\u0001B\r\u0001\u0003\u0002\u0003\u0006Ia\r\u0005\u0006w\u0001!\t\u0001\u0010\u0005\t\u0001\u0002A)\u0019!C\u0005\u0003\"Aa\n\u0001EC\u0002\u0013%q\n\u0003\u0005T\u0001!\u0015\r\u0011\"\u0003U\u0011\u0015I\u0006\u0001\"\u0011[\u0011\u0015I\u0006\u0001\"\u0011q\u0011\u0015I\u0006\u0001\"\u0011x\u0011\u001d\t\u0019\u0002\u0001C!\u0003+Aq!a\u0005\u0001\t\u0003\nI\u0002C\u0004\u0002\u0014\u0001!\t%!\b\t\u000f\u0005\r\u0002\u0001\"\u0011\u0002&!9\u0011q\u0007\u0001\u0005B\u0005\u0015\u0002bBA\u001d\u0001\u0011%\u00111\b\u0005\u000f\u0003\u0017\u0002\u0001\u0013aA\u0001\u0002\u0013%\u0011QJA.\u000f\u001d\t\t'\bE\u0001\u0003G2a\u0001H\u000f\t\u0002\u0005\u0015\u0004BB\u001e\u0012\t\u0003\t\u0019\bC\u0005\u0002vE\u0011\r\u0011\"\u0001\u0002x!A\u0011\u0011P\t!\u0002\u0013\t\t\u0006C\u0005\u0002|E\u0011\r\u0011\"\u0001\u0002x!A\u0011QP\t!\u0002\u0013\t\t\u0006C\u0005\u0002\u0000E\u0011\r\u0011\"\u0003\u0002\u0002\"A\u0011qS\t!\u0002\u0013\t\u0019\tC\u0005\u0002\u001aF\u0011\r\u0011\"\u0003\u0002\u0002\"A\u00111T\t!\u0002\u0013\t\u0019\tC\u0005\u0002\u001eF\t\t\u0011\"\u0003\u0002 \ny1+\u001d7LKf<UM\\3sCR|'O\u0003\u0002\u001f?\u000591m\\7nC:$'B\u0001\u0011\"\u0003\u0011AW\u000fZ5\u000b\u0005\t\u001a\u0013aA:rY*\u0011A%J\u0001\u0006gB\f'o\u001b\u0006\u0003M\u001d\na!\u00199bG\",'\"\u0001\u0015\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001Y\u0003C\u0001\u00171\u001b\u0005i#B\u0001\u00180\u0003\u0019YW-_4f]*\u0011\u0001%J\u0005\u0003c5\u00121CQ;jYRLgnS3z\u000f\u0016tWM]1u_J\fQ\u0001\u001d:paN\u0004\"\u0001N\u001d\u000e\u0003UR!AN\u001c\u0002\r\r|gNZ5h\u0015\tAt&\u0001\u0004d_6lwN\\\u0005\u0003uU\u0012q\u0002V=qK\u0012\u0004&o\u001c9feRLWm]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005uz\u0004C\u0001 \u0001\u001b\u0005i\u0002\"\u0002\u001a\u0003\u0001\u0004\u0019\u0014a\u00049beRLG/[8o'\u000eDW-\\1\u0016\u0003\t\u00032a\u0011$I\u001b\u0005!%\"A#\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d#%AB(qi&|g\u000e\u0005\u0002J\u00196\t!J\u0003\u0002LC\u0005)A/\u001f9fg&\u0011QJ\u0013\u0002\u000b'R\u0014Xo\u0019;UsB,\u0017!D2p[BdW\r_&fs\u001e+g.F\u0001Q!\ta\u0013+\u0003\u0002S[\t\u00192i\\7qY\u0016D8*Z=HK:,'/\u0019;pe\u0006qqN]5hS:\fGnS3z\u000f\u0016tW#A+\u0011\u0007\r3e\u000b\u0005\u0002-/&\u0011\u0001,\f\u0002\u001b'B\f'o[&fs\u001e+g.\u001a:bi>\u0014\u0018J\u001c;fe\u001a\f7-Z\u0001\rO\u0016$(+Z2pe\u0012\\U-\u001f\u000b\u00037\u001a\u0004\"\u0001X2\u000f\u0005u\u000b\u0007C\u00010E\u001b\u0005y&B\u00011*\u0003\u0019a$o\\8u}%\u0011!\rR\u0001\u0007!J,G-\u001a4\n\u0005\u0011,'AB*ue&twM\u0003\u0002c\t\")qM\u0002a\u0001Q\u00061!/Z2pe\u0012\u0004\"!\u001b8\u000e\u0003)T!a\u001b7\u0002\u000f\u001d,g.\u001a:jG*\u0011Q.J\u0001\u0005CZ\u0014x.\u0003\u0002pU\niq)\u001a8fe&\u001c'+Z2pe\u0012$\"aW9\t\u000bI<\u0001\u0019A:\u0002\u0007I|w\u000f\u0005\u0002uk6\t\u0011%\u0003\u0002wC\t\u0019!k\\<\u0015\ta|\u0018q\u0002\t\u0003svl\u0011A\u001f\u0006\u0003\u0017nT!\u0001`\u0012\u0002\rUt7/\u00194f\u0013\tq(P\u0001\u0006V)\u001aC4\u000b\u001e:j]\u001eDq!!\u0001\t\u0001\u0004\t\u0019!A\u0006j]R,'O\\1m%><\b\u0003BA\u0003\u0003\u0017i!!a\u0002\u000b\u0007\u0005%\u0011%\u0001\u0005dCR\fG._:u\u0013\u0011\ti!a\u0002\u0003\u0017%sG/\u001a:oC2\u0014vn\u001e\u0005\u0007\u0003#A\u0001\u0019\u0001%\u0002\rM\u001c\u0007.Z7b\u0003A9W\r\u001e)beRLG/[8o!\u0006$\b\u000eF\u0002\\\u0003/AQaZ\u0005A\u0002!$2aWA\u000e\u0011\u0015\u0011(\u00021\u0001t)\u0015A\u0018qDA\u0011\u0011\u001d\t\ta\u0003a\u0001\u0003\u0007Aa!!\u0005\f\u0001\u0004A\u0015AF4fiJ+7m\u001c:e\u0017\u0016Lh)[3mI:\u000bW.Z:\u0015\u0005\u0005\u001d\u0002#BA\u0015\u0003gYVBAA\u0016\u0015\u0011\ti#a\f\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003c\tAA[1wC&!\u0011QGA\u0016\u0005\u0011a\u0015n\u001d;\u0002-\u001d,G\u000fU1si&$\u0018n\u001c8QCRDg)[3mIN\fQdY8om\u0016\u0014H\u000fU1si&$\u0018n\u001c8QCRDGk\\*rYRK\b/\u001a\u000b\u00067\u0006u\u0012\u0011\t\u0005\u0007\u0003\u007fq\u0001\u0019A.\u0002\u001bA\f'\u000f^5uS>t\u0007+\u0019;i\u0011\u001d\t\u0019E\u0004a\u0001\u0003\u000b\nqA]8x)f\u0004X\rE\u0002D\u0003\u000fJ1!!\u0013E\u0005\u001d\u0011un\u001c7fC:\fAd];qKJ$s-\u001a;QCJ$\u0018\u000e^5p]B\u000bG\u000f\u001b$jK2$7\u000f\u0006\u0002\u0002PA1\u0011\u0011FA\u001a\u0003#\u0002B!a\u0015\u0002Z5\u0011\u0011Q\u000b\u0006\u0005\u0003/\ny#\u0001\u0003mC:<\u0017b\u00013\u0002V%!\u0011qGA/\u0013\r\ty&\f\u0002\u0011\u0005\u0006\u001cXmS3z\u000f\u0016tWM]1u_J\fqbU9m\u0017\u0016Lx)\u001a8fe\u0006$xN\u001d\t\u0003}E\u0019R!EA4\u0003[\u00022aQA5\u0013\r\tY\u0007\u0012\u0002\u0007\u0003:L(+\u001a4\u0011\u0007\r\u000by'C\u0002\u0002r\u0011\u0013AbU3sS\u0006d\u0017N_1cY\u0016$\"!a\u0019\u0002!A\u000b%\u000bV%U\u0013>sulU\"I\u000b6\u000bUCAA)\u0003E\u0001\u0016I\u0015+J)&{ejX*D\u0011\u0016k\u0015\tI\u0001\u001b\u001fJKu)\u0013(B\u0019~[U)W$F\u001d~\u001bE*Q*T?:\u000bU*R\u0001\u001c\u001fJKu)\u0013(B\u0019~[U)W$F\u001d~\u001bE*Q*T?:\u000bU*\u0012\u0011\u0002'QLW.Z:uC6\u0004H+[7f\r>\u0014X.\u0019;\u0016\u0005\u0005\r\u0005\u0003BAC\u0003'k!!a\"\u000b\t\u0005%\u00151R\u0001\u0007M>\u0014X.\u0019;\u000b\t\u00055\u0015qR\u0001\u0005i&lWMC\u0002\u0002\u0012\u001e\nAA[8eC&!\u0011QSAD\u0005E!\u0015\r^3US6,gi\u001c:nCR$XM]\u0001\u0015i&lWm\u001d;b[B$\u0016.\\3G_Jl\u0017\r\u001e\u0011\u0002%M\fH\u000eV5nKN$\u0018-\u001c9G_Jl\u0017\r^\u0001\u0014gFdG+[7fgR\fW\u000e\u001d$pe6\fG\u000fI\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002\"B!\u00111KAR\u0013\u0011\t)+!\u0016\u0003\r=\u0013'.Z2u\u0001")
public class SqlKeyGenerator
extends BuiltinKeyGenerator {
    private Option<StructType> partitionSchema;
    private ComplexKeyGenerator complexKeyGen;
    private Option<SparkKeyGeneratorInterface> originalKeyGen;
    private final TypedProperties props;
    private volatile byte bitmap$0;

    public static String ORIGINAL_KEYGEN_CLASS_NAME() {
        return SqlKeyGenerator$.MODULE$.ORIGINAL_KEYGEN_CLASS_NAME();
    }

    public static String PARTITION_SCHEMA() {
        return SqlKeyGenerator$.MODULE$.PARTITION_SCHEMA();
    }

    private /* synthetic */ List super$getPartitionPathFields() {
        return super.getPartitionPathFields();
    }

    private Option<StructType> partitionSchema$lzycompute() {
        SqlKeyGenerator sqlKeyGenerator = this;
        synchronized (sqlKeyGenerator) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                String partitionSchema = this.props.getString(SqlKeyGenerator$.MODULE$.PARTITION_SCHEMA(), "");
                this.partitionSchema = partitionSchema != null && new StringOps(Predef$.MODULE$.augmentString(partitionSchema)).nonEmpty() ? new Some((Object)StructType$.MODULE$.fromDDL(partitionSchema)) : None$.MODULE$;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.partitionSchema;
    }

    private Option<StructType> partitionSchema() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.partitionSchema$lzycompute() : this.partitionSchema;
    }

    private ComplexKeyGenerator complexKeyGen$lzycompute() {
        SqlKeyGenerator sqlKeyGenerator = this;
        synchronized (sqlKeyGenerator) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.complexKeyGen = new ComplexKeyGenerator(this.props);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.complexKeyGen;
    }

    private ComplexKeyGenerator complexKeyGen() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.complexKeyGen$lzycompute() : this.complexKeyGen;
    }

    private Option<SparkKeyGeneratorInterface> originalKeyGen$lzycompute() {
        SqlKeyGenerator sqlKeyGenerator = this;
        synchronized (sqlKeyGenerator) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.originalKeyGen = Option$.MODULE$.apply((Object)this.props.getString(SqlKeyGenerator$.MODULE$.ORIGINAL_KEYGEN_CLASS_NAME(), null)).map((Function1 & Serializable & scala.Serializable)originalKeyGenClassName -> {
                    ValidationUtils.checkArgument(new StringOps(Predef$.MODULE$.augmentString(originalKeyGenClassName)).nonEmpty());
                    String convertedKeyGenClassName = HoodieSparkKeyGeneratorFactory.convertToSparkKeyGenerator(originalKeyGenClassName);
                    TypedProperties keyGenProps = TypedProperties.fromMap($this.props);
                    keyGenProps.remove(SqlKeyGenerator$.MODULE$.ORIGINAL_KEYGEN_CLASS_NAME());
                    keyGenProps.put(HoodieWriteConfig.KEYGENERATOR_CLASS_NAME.key(), convertedKeyGenClassName);
                    return (SparkKeyGeneratorInterface)((Object)KeyGenUtils.createKeyGeneratorByClassName(keyGenProps));
                });
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.originalKeyGen;
    }

    private Option<SparkKeyGeneratorInterface> originalKeyGen() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.originalKeyGen$lzycompute() : this.originalKeyGen;
    }

    @Override
    public String getRecordKey(GenericRecord record) {
        return (String)this.originalKeyGen().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getKey(record).getRecordKey()).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.complexKeyGen().getRecordKey(record));
    }

    @Override
    public String getRecordKey(Row row) {
        return (String)this.originalKeyGen().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getRecordKey(row)).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.complexKeyGen().getRecordKey(row));
    }

    @Override
    public UTF8String getRecordKey(InternalRow internalRow, StructType schema) {
        return (UTF8String)this.originalKeyGen().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getRecordKey(internalRow, schema)).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.complexKeyGen().getRecordKey(internalRow, schema));
    }

    @Override
    public String getPartitionPath(GenericRecord record) {
        String partitionPath = (String)this.originalKeyGen().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getKey(record).getPartitionPath()).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.complexKeyGen().getPartitionPath(record));
        return this.convertPartitionPathToSqlType(partitionPath, false);
    }

    @Override
    public String getPartitionPath(Row row) {
        String partitionPath = (String)this.originalKeyGen().map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getPartitionPath(row)).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.complexKeyGen().getPartitionPath(row));
        return this.convertPartitionPathToSqlType(partitionPath, true);
    }

    @Override
    public UTF8String getPartitionPath(InternalRow internalRow, StructType schema) {
        UTF8String partitionPath = (UTF8String)this.originalKeyGen().map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getPartitionPath(internalRow, schema)).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.complexKeyGen().getPartitionPath(internalRow, schema));
        return UTF8String.fromString((String)this.convertPartitionPathToSqlType(partitionPath.toString(), true));
    }

    @Override
    public List<String> getRecordKeyFieldNames() {
        return (List)this.originalKeyGen().map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.getRecordKeyFieldNames()).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.complexKeyGen().getRecordKeyFieldNames());
    }

    @Override
    public List<String> getPartitionPathFields() {
        return (List)this.originalKeyGen().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            List list;
            SparkKeyGeneratorInterface sparkKeyGeneratorInterface = x0$1;
            if (sparkKeyGeneratorInterface instanceof BaseKeyGenerator) {
                BaseKeyGenerator baseKeyGenerator = (BaseKeyGenerator)((Object)sparkKeyGeneratorInterface);
                list = baseKeyGenerator.getPartitionPathFields();
            } else {
                list = (List)Option$.MODULE$.apply((Object)this.super$getPartitionPathFields()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Collections.emptyList());
            }
            return list;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.complexKeyGen().getPartitionPathFields());
    }

    private String convertPartitionPathToSqlType(String partitionPath, boolean rowType) {
        String[] partitionFragments;
        return this.partitionSchema().isDefined() ? (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])(partitionFragments = partitionPath.split("/")))).size() != ((SeqLike)this.partitionSchema().get()).size() ? partitionPath : new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionFragments)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])((StructType)this.partitionSchema().get()).fields()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            String string;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                StructField partitionField;
                String hiveStylePrefix;
                String partitionValue = (String)tuple2._1();
                boolean isHiveStyle = partitionValue.startsWith(hiveStylePrefix = new StringBuilder(1).append((partitionField = (StructField)tuple2._2()).name()).append("=").toString());
                String _partitionValue = isHiveStyle ? partitionValue.substring(hiveStylePrefix.length()) : partitionValue;
                DataType dataType = partitionField.dataType();
                if (TimestampType$.MODULE$.equals(dataType)) {
                    long timeMs = rowType ? SqlKeyGenerator$.MODULE$.org$apache$spark$sql$hudi$command$SqlKeyGenerator$$sqlTimestampFormat().parseMillis(_partitionValue) : (this.isConsistentLogicalTimestampEnabled() ? Timestamp.valueOf(_partitionValue).getTime() : TimeUnit.MILLISECONDS.convert(new StringOps(Predef$.MODULE$.augmentString(_partitionValue)).toLong(), TimeUnit.MICROSECONDS));
                    String timestampFormat = PartitionPathEncodeUtils.escapePathName(SqlKeyGenerator$.MODULE$.org$apache$spark$sql$hudi$command$SqlKeyGenerator$$timestampTimeFormat().print(timeMs));
                    string = isHiveStyle ? new StringBuilder(0).append(hiveStylePrefix).append(timestampFormat).toString() : timestampFormat;
                } else {
                    string = partitionValue;
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            String string2 = string;
            return string2;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("/")) : partitionPath;
    }

    public SqlKeyGenerator(TypedProperties props) {
        this.props = props;
        super(props);
    }
}

