/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.avro.model;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Conversion;
import org.apache.avro.Conversions;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class DecimalWrapper
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = -562900601579885202L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"DecimalWrapper\",\"namespace\":\"org.apache.hudi.avro.model\",\"doc\":\"A record wrapping Decimal logical type to be able to be used it w/in Avro's Union\",\"fields\":[{\"name\":\"value\",\"type\":{\"type\":\"bytes\",\"logicalType\":\"decimal\",\"precision\":30,\"scale\":15}}]}");
    private static SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<DecimalWrapper> ENCODER;
    private static final BinaryMessageDecoder<DecimalWrapper> DECODER;
    private ByteBuffer value;
    private static final Conversion<?>[] conversions;
    private static final DatumWriter<DecimalWrapper> WRITER$;
    private static final DatumReader<DecimalWrapper> READER$;

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<DecimalWrapper> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<DecimalWrapper> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<DecimalWrapper> createDecoder(SchemaStore resolver2) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver2);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static DecimalWrapper fromByteBuffer(ByteBuffer b) throws IOException {
        return (DecimalWrapper)((Object)DECODER.decode(b));
    }

    public DecimalWrapper() {
    }

    public DecimalWrapper(ByteBuffer value) {
        this.value = value;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.value;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public Conversion<?> getConversion(int field) {
        return conversions[field];
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.value = (ByteBuffer)value$;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public ByteBuffer getValue() {
        return this.value;
    }

    public void setValue(ByteBuffer value) {
        this.value = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(DecimalWrapper other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    static {
        MODEL$.addLogicalTypeConversion((Conversion)new Conversions.DecimalConversion());
        ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
        DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
        conversions = new Conversion[]{null, null};
        WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
        READER$ = MODEL$.createDatumReader(SCHEMA$);
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<DecimalWrapper>
    implements RecordBuilder<DecimalWrapper> {
        private ByteBuffer value;

        private Builder() {
            super(SCHEMA$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.value)) {
                this.value = (ByteBuffer)this.data().deepCopy(this.fields()[0].schema(), (Object)other.value);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
        }

        private Builder(DecimalWrapper other) {
            super(SCHEMA$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.value)) {
                this.value = (ByteBuffer)this.data().deepCopy(this.fields()[0].schema(), (Object)other.value);
                this.fieldSetFlags()[0] = true;
            }
        }

        public ByteBuffer getValue() {
            return this.value;
        }

        public Builder setValue(ByteBuffer value) {
            this.validate(this.fields()[0], value);
            this.value = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasValue() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearValue() {
            this.value = null;
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public DecimalWrapper build() {
            try {
                DecimalWrapper record = new DecimalWrapper();
                record.value = this.fieldSetFlags()[0] ? this.value : (ByteBuffer)this.defaultValue(this.fields()[0]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

