/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.clustering.update.strategy;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.hudi.client.clustering.update.strategy.BaseSparkUpdateStrategy;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieClusteringUpdateException;
import org.apache.hudi.table.HoodieTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkRejectUpdateStrategy<T>
extends BaseSparkUpdateStrategy<T> {
    private static final Logger LOG = LoggerFactory.getLogger(SparkRejectUpdateStrategy.class);

    public SparkRejectUpdateStrategy(HoodieEngineContext engineContext, HoodieTable table, Set<HoodieFileGroupId> fileGroupsInPendingClustering) {
        super(engineContext, table, fileGroupsInPendingClustering);
    }

    @Override
    public Pair<HoodieData<HoodieRecord<T>>, Set<HoodieFileGroupId>> handleUpdate(HoodieData<HoodieRecord<T>> taggedRecordsRDD) {
        List<HoodieFileGroupId> fileGroupIdsWithRecordUpdate = this.getGroupIdsWithUpdate(taggedRecordsRDD);
        fileGroupIdsWithRecordUpdate.forEach(fileGroupIdWithRecordUpdate -> {
            if (this.fileGroupsInPendingClustering.contains(fileGroupIdWithRecordUpdate)) {
                String msg = String.format("Not allowed to update the clustering file group %s. For pending clustering operations, we are not going to support update for now.", fileGroupIdWithRecordUpdate.toString());
                LOG.error(msg);
                throw new HoodieClusteringUpdateException(msg);
            }
        });
        return Pair.of(taggedRecordsRDD, Collections.emptySet());
    }
}

