/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.data.HoodiePairData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieDeltaWriteStat;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.HoodieStorageUtils;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathInfo;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.marker.WriteMarkers;
import org.apache.hudi.table.marker.WriteMarkersFactory;

public class CommitMetadataUtils {
    public static HoodieCommitMetadata reconcileMetadataForMissingFiles(HoodieTable table, String commitActionType, String instantTime, HoodieCommitMetadata commitMetadata, HoodieWriteConfig config, HoodieEngineContext context, Configuration hadoopConf, String classNameForContext) throws IOException {
        if (!table.getMetaClient().getTableType().equals((Object)HoodieTableType.MERGE_ON_READ) || !commitActionType.equals("deltacommit")) {
            return commitMetadata;
        }
        WriteMarkers markers = WriteMarkersFactory.get(config.getMarkersType(), table, instantTime);
        boolean hasLogFileInDeltaCommit = commitMetadata.getPartitionToWriteStats().values().stream().flatMap(Collection::stream).anyMatch(writeStat -> FSUtils.isLogFile(new Path(config.getBasePath(), writeStat.getPath()).getName()));
        if (hasLogFileInDeltaCommit) {
            HashSet<String> allLogFilesMarkerPath = new HashSet<String>(markers.getAppendedLogPaths(context, config.getFinalizeWriteParallelism()));
            HashSet<String> logFilesMarkerPath = new HashSet<String>();
            allLogFilesMarkerPath.stream().filter(logFilePath -> !logFilePath.endsWith("cdc")).forEach(logFilesMarkerPath::add);
            for (Map.Entry<String, List<HoodieWriteStat>> partitionAndWriteStats : commitMetadata.getPartitionToWriteStats().entrySet()) {
                for (HoodieWriteStat hoodieWriteStat : partitionAndWriteStats.getValue()) {
                    logFilesMarkerPath.remove(hoodieWriteStat.getPath());
                }
            }
            if (!logFilesMarkerPath.isEmpty()) {
                StorageConfiguration<Configuration> storageConf = HadoopFSUtils.getStorageConfWithCopy(hadoopConf);
                context.setJobStatus(classNameForContext, "Preparing data for missing files to assist with generating write stats");
                HoodiePairData<String, Map<String, HoodieWriteStat>> partitionToWriteStatHoodieData = CommitMetadataUtils.getPartitionToFileIdToFilesMap(commitMetadata, context);
                String basePathStr = config.getBasePath();
                HoodiePairData<String, Map<String, List<String>>> partitionToMissingLogFilesHoodieData = CommitMetadataUtils.getPartitionToFileIdToMissingLogFileMap(basePathStr, logFilesMarkerPath, context, config.getFileListingParallelism());
                context.setJobStatus(classNameForContext, "Generating writeStat for missing log files");
                List<Pair<String, List<HoodieWriteStat>>> additionalLogFileWriteStat = CommitMetadataUtils.getWriteStatsForMissingLogFiles(partitionToWriteStatHoodieData, partitionToMissingLogFilesHoodieData, storageConf, basePathStr);
                for (Pair<String, List<HoodieWriteStat>> partitionDeltaStats : additionalLogFileWriteStat) {
                    String partitionPath = partitionDeltaStats.getKey();
                    partitionDeltaStats.getValue().forEach(ws -> commitMetadata.addWriteStat(partitionPath, (HoodieWriteStat)ws));
                }
            }
        }
        return commitMetadata;
    }

    private static HoodiePairData<String, Map<String, HoodieWriteStat>> getPartitionToFileIdToFilesMap(HoodieCommitMetadata commitMetadata, HoodieEngineContext context) {
        ArrayList<Map.Entry<String, List<HoodieWriteStat>>> partitionToWriteStats = new ArrayList<Map.Entry<String, List<HoodieWriteStat>>>(commitMetadata.getPartitionToWriteStats().entrySet());
        return context.parallelize(partitionToWriteStats).mapToPair(t -> {
            HashMap fileIdToWriteStat = new HashMap();
            ((List)t.getValue()).forEach(writeStat -> {
                if (!fileIdToWriteStat.containsKey(writeStat.getFileId())) {
                    fileIdToWriteStat.put(writeStat.getFileId(), writeStat);
                }
            });
            return Pair.of(t.getKey(), fileIdToWriteStat);
        });
    }

    private static HoodiePairData<String, Map<String, List<String>>> getPartitionToFileIdToMissingLogFileMap(String basePathStr, Set<String> logFilesMarkerPath, HoodieEngineContext context, int parallelism) {
        ArrayList<String> logFilePaths = new ArrayList<String>(logFilesMarkerPath);
        HoodiePairData partitionPathLogFilePair = context.parallelize(logFilePaths).mapToPair(logFilePath -> {
            Path logFileFullPath = new Path(basePathStr, logFilePath);
            String partitionPath = HadoopFSUtils.getRelativePartitionPath(new Path(basePathStr), logFileFullPath.getParent());
            return Pair.of(partitionPath, Collections.singletonList(logFileFullPath.getName()));
        });
        HoodiePairData<String, Map<String, List<String>>> partitionPathToFileIdAndLogFileList = partitionPathLogFilePair.reduceByKey((strings, strings2) -> {
            ArrayList logFilePaths1 = new ArrayList(strings);
            logFilePaths1.addAll(strings2);
            return logFilePaths1;
        }, parallelism).mapToPair(t -> {
            String partitionPath = (String)t.getKey();
            Path fullPartitionPath = StringUtils.isNullOrEmpty(partitionPath) ? new Path(basePathStr) : new Path(basePathStr, partitionPath);
            List missingLogFiles = (List)t.getValue();
            HashMap fileIdtologFiles = new HashMap();
            missingLogFiles.forEach(logFile -> {
                String fileId = HadoopFSUtils.getFileIdFromLogPath(new Path(fullPartitionPath, logFile));
                if (!fileIdtologFiles.containsKey(fileId)) {
                    fileIdtologFiles.put(fileId, new ArrayList());
                }
                ((List)fileIdtologFiles.get(fileId)).add(logFile);
            });
            return Pair.of(partitionPath, fileIdtologFiles);
        });
        return partitionPathToFileIdAndLogFileList;
    }

    private static List<Pair<String, List<HoodieWriteStat>>> getWriteStatsForMissingLogFiles(HoodiePairData<String, Map<String, HoodieWriteStat>> partitionToWriteStatHoodieData, HoodiePairData<String, Map<String, List<String>>> partitionToMissingLogFilesHoodieData, StorageConfiguration<?> storageConf, String basePathStr) {
        return partitionToWriteStatHoodieData.join(partitionToMissingLogFilesHoodieData).map(v1 -> {
            StoragePath basePathLocal = new StoragePath(basePathStr);
            String partitionPath = (String)v1.getKey();
            Map fileIdToOriginalWriteStat = (Map)((Pair)v1.getValue()).getKey();
            Map missingFileIdToLogFileNames = (Map)((Pair)v1.getValue()).getValue();
            List missingLogFileNames = missingFileIdToLogFileNames.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            StoragePath fullPartitionPath = StringUtils.isNullOrEmpty(partitionPath) ? new StoragePath(basePathStr) : new StoragePath(basePathStr, partitionPath);
            HoodieStorage storage = HoodieStorageUtils.getStorage(fullPartitionPath, storageConf);
            List<Option<StoragePathInfo>> pathInfoOptList = FSUtils.getPathInfoUnderPartition(storage, fullPartitionPath, new HashSet<String>(missingLogFileNames), true);
            List<StoragePathInfo> pathInfoList = pathInfoOptList.stream().filter(fileStatusOpt -> fileStatusOpt.isPresent()).map(fileStatusOption -> (StoragePathInfo)fileStatusOption.get()).collect(Collectors.toList());
            HashMap<String, List> missingFileIdToLogFilesList = new HashMap<String, List>();
            pathInfoList.forEach(pathInfo -> {
                String fileId = FSUtils.getFileIdFromLogPath(pathInfo.getPath());
                missingFileIdToLogFilesList.putIfAbsent(fileId, new ArrayList());
                ((List)missingFileIdToLogFilesList.get(fileId)).add(pathInfo);
            });
            ArrayList missingWriteStats = new ArrayList();
            missingFileIdToLogFilesList.forEach((k, logFileStatuses) -> {
                String fileId = k;
                HoodieDeltaWriteStat originalWriteStat = (HoodieDeltaWriteStat)fileIdToOriginalWriteStat.get(fileId);
                logFileStatuses.forEach(pathInfo -> {
                    HoodieDeltaWriteStat writeStat = CommitMetadataUtils.getHoodieDeltaWriteStatFromPreviousStat(pathInfo, basePathLocal, partitionPath, fileId, originalWriteStat);
                    missingWriteStats.add(writeStat);
                });
            });
            return Pair.of(partitionPath, missingWriteStats);
        }).collectAsList();
    }

    private static HoodieDeltaWriteStat getHoodieDeltaWriteStatFromPreviousStat(StoragePathInfo pathInfo, StoragePath basePathLocal, String partitionPath, String fileId, HoodieDeltaWriteStat originalWriteStat) {
        HoodieDeltaWriteStat writeStat = new HoodieDeltaWriteStat();
        HoodieLogFile logFile = new HoodieLogFile(pathInfo);
        writeStat.setPath(basePathLocal, logFile.getPath());
        writeStat.setPartitionPath(partitionPath);
        writeStat.setFileId(fileId);
        writeStat.setTotalWriteBytes(logFile.getFileSize());
        writeStat.setFileSizeInBytes(logFile.getFileSize());
        writeStat.setLogVersion(logFile.getLogVersion());
        ArrayList<String> logFiles = new ArrayList<String>(originalWriteStat.getLogFiles());
        logFiles.add(logFile.getFileName());
        writeStat.setLogFiles(logFiles);
        writeStat.setBaseFile(originalWriteStat.getBaseFile());
        writeStat.setPrevCommit(logFile.getBaseCommitTime());
        return writeStat;
    }
}

