/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop.realtime;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.hadoop.HoodieParquetInputFormat;
import org.apache.hudi.hadoop.UseFileSplitsFromInputFormat;
import org.apache.hudi.hadoop.UseRecordReaderFromInputFormat;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.hadoop.realtime.HoodieEmptyRecordReader;
import org.apache.hudi.hadoop.realtime.HoodieMergeOnReadTableInputFormat;
import org.apache.hudi.hadoop.realtime.HoodieRealtimeRecordReader;
import org.apache.hudi.hadoop.realtime.RealtimeSplit;
import org.apache.hudi.hadoop.utils.HoodieRealtimeInputFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UseRecordReaderFromInputFormat
@UseFileSplitsFromInputFormat
public class HoodieParquetRealtimeInputFormat
extends HoodieParquetInputFormat {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieParquetRealtimeInputFormat.class);

    public HoodieParquetRealtimeInputFormat() {
        super(new HoodieMergeOnReadTableInputFormat());
    }

    @Override
    public RecordReader<NullWritable, ArrayWritable> getRecordReader(InputSplit split, JobConf jobConf, Reporter reporter) throws IOException {
        ValidationUtils.checkArgument(split instanceof RealtimeSplit, "HoodieRealtimeRecordReader can only work on RealtimeSplit and not with " + split);
        RealtimeSplit realtimeSplit = (RealtimeSplit)split;
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(HadoopFSUtils.getStorageConfWithCopy((Configuration)jobConf)).setBasePath(realtimeSplit.getBasePath()).build();
        HoodieTableConfig tableConfig = metaClient.getTableConfig();
        this.addProjectionToJobConf(realtimeSplit, jobConf, tableConfig);
        LOG.info("Creating record reader with readCols :" + jobConf.get("hive.io.file.readcolumn.names") + ", Ids :" + jobConf.get("hive.io.file.readcolumn.ids"));
        if (HadoopFSUtils.isLogFile(realtimeSplit.getPath())) {
            return new HoodieRealtimeRecordReader(realtimeSplit, jobConf, new HoodieEmptyRecordReader(realtimeSplit, jobConf));
        }
        return new HoodieRealtimeRecordReader(realtimeSplit, jobConf, super.getRecordReader(split, jobConf, reporter));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addProjectionToJobConf(RealtimeSplit realtimeSplit, JobConf jobConf, HoodieTableConfig tableConfig) {
        if (HoodieRealtimeInputFormatUtils.canAddProjectionToJobConf(realtimeSplit, jobConf)) {
            JobConf jobConf2 = jobConf;
            synchronized (jobConf2) {
                LOG.info("Before adding Hoodie columns, Projections :" + jobConf.get("hive.io.file.readcolumn.names") + ", Ids :" + jobConf.get("hive.io.file.readcolumn.ids"));
                if (HoodieRealtimeInputFormatUtils.canAddProjectionToJobConf(realtimeSplit, jobConf)) {
                    Option<String[]> partitions;
                    ArrayList<Object> fieldsToAdd = new ArrayList<Object>();
                    if (!realtimeSplit.getDeltaLogPaths().isEmpty()) {
                        HoodieRealtimeInputFormatUtils.addVirtualKeysProjection((Configuration)jobConf, realtimeSplit.getVirtualKeyInfo());
                        String preCombineKey = tableConfig.getPreCombineField();
                        if (!StringUtils.isNullOrEmpty(preCombineKey)) {
                            fieldsToAdd.add(preCombineKey);
                        }
                    }
                    if ((partitions = tableConfig.getPartitionFields()).isPresent()) {
                        fieldsToAdd.addAll(Arrays.asList((Object[])partitions.get()));
                    }
                    HoodieRealtimeInputFormatUtils.addProjectionField((Configuration)jobConf, fieldsToAdd.toArray(new String[0]));
                    jobConf.set("hoodie.read.columns.set", "true");
                    this.setConf((Configuration)jobConf);
                }
            }
        }
        HoodieRealtimeInputFormatUtils.cleanProjectionColumnIds((Configuration)jobConf);
    }
}

