/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public enum MetadataPartitionType {
    FILES("files", "files-"),
    COLUMN_STATS("column_stats", "col-stats-"),
    BLOOM_FILTERS("bloom_filters", "bloom-filters-"),
    RECORD_INDEX("record_index", "record-index-");

    private final String partitionPath;
    private final String fileIdPrefix;

    private MetadataPartitionType(String partitionPath, String fileIdPrefix) {
        this.partitionPath = partitionPath;
        this.fileIdPrefix = fileIdPrefix;
    }

    public String getPartitionPath() {
        return this.partitionPath;
    }

    public String getFileIdPrefix() {
        return this.fileIdPrefix;
    }

    public static List<MetadataPartitionType> getMetadataPartitionsNeedingWriteStatusTracking() {
        return Collections.singletonList(RECORD_INDEX);
    }

    public static Set<String> getAllPartitionPaths() {
        return Arrays.stream(MetadataPartitionType.values()).map(MetadataPartitionType::getPartitionPath).collect(Collectors.toSet());
    }

    public String toString() {
        return "Metadata partition {name: " + this.getPartitionPath() + ", prefix: " + this.getFileIdPrefix() + "}";
    }
}

