/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.filter;

import java.nio.ByteBuffer;
import org.apache.hudi.org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hudi.org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public abstract class ByteArrayComparable
implements Comparable<byte[]> {
    byte[] value;

    public ByteArrayComparable(byte[] value) {
        this.value = value;
    }

    public byte[] getValue() {
        return this.value;
    }

    public abstract byte[] toByteArray();

    public static ByteArrayComparable parseFrom(byte[] pbBytes) throws DeserializationException {
        throw new DeserializationException("parseFrom called on base ByteArrayComparable, but should be called on derived type");
    }

    boolean areSerializedFieldsEqual(ByteArrayComparable other) {
        if (other == this) {
            return true;
        }
        return Bytes.equals(this.getValue(), other.getValue());
    }

    @Override
    public int compareTo(byte[] value) {
        return this.compareTo(value, 0, value.length);
    }

    public abstract int compareTo(byte[] var1, int var2, int var3);

    public int compareTo(ByteBuffer value, int offset, int length) {
        byte[] temp = new byte[length];
        ByteBufferUtils.copyFromBufferToArray(temp, value, offset, 0, length);
        return this.compareTo(temp);
    }
}

