/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.tool.coprocessor;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class CoprocessorMethod {
    private final String name;
    private final List<String> parameters;

    public CoprocessorMethod(String name) {
        this.name = name;
        this.parameters = new ArrayList<String>();
    }

    public CoprocessorMethod withParameters(String ... parameters) {
        for (String parameter : parameters) {
            this.parameters.add(parameter);
        }
        return this;
    }

    public CoprocessorMethod withParameters(Class<?> ... parameters) {
        for (Class<?> parameter : parameters) {
            this.parameters.add(parameter.getCanonicalName());
        }
        return this;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CoprocessorMethod)) {
            return false;
        }
        CoprocessorMethod other = (CoprocessorMethod)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.parameters, other.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.parameters);
    }
}

