/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.hive.HiveSyncConfigHolder;
import org.apache.hudi.sql.InsertMode;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.plans.QueryPlan;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.trees.HoodieLeafLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.hudi.command.CreateHoodieTableAsSelectCommand$;
import org.apache.spark.sql.hudi.command.CreateHoodieTableCommand$;
import org.apache.spark.sql.hudi.command.HoodieLeafRunnableCommand;
import org.apache.spark.sql.hudi.command.InsertIntoHoodieTableCommand$;
import org.apache.spark.sql.internal.SessionState;
import org.apache.spark.sql.types.StructType;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u00055h\u0001\u0002\u000f\u001e\u0001*B\u0001B\u0011\u0001\u0003\u0016\u0004%\ta\u0011\u0005\t\u0015\u0002\u0011\t\u0012)A\u0005\t\"A1\n\u0001BK\u0002\u0013\u0005A\n\u0003\u0005R\u0001\tE\t\u0015!\u0003N\u0011!\u0011\u0006A!f\u0001\n\u0003\u0019\u0006\u0002\u0003+\u0001\u0005#\u0005\u000b\u0011B\u0016\t\u000bU\u0003A\u0011\u0001,\t\u000bm\u0003A\u0011\t/\t\u000be\u0004A\u0011\t>\t\u000f\u0005%\u0001\u0001\"\u0003\u0002\f!I\u0011\u0011\b\u0001\u0002\u0002\u0013\u0005\u00111\b\u0005\n\u0003\u0007\u0002\u0011\u0013!C\u0001\u0003\u000bB\u0011\"a\u0017\u0001#\u0003%\t!!\u0018\t\u0013\u0005\u0005\u0004!%A\u0005\u0002\u0005\r\u0004\"CA4\u0001\u0005\u0005I\u0011IA5\u0011%\tI\bAA\u0001\n\u0003\tY\bC\u0005\u0002\u0004\u0002\t\t\u0011\"\u0001\u0002\u0006\"I\u00111\u0012\u0001\u0002\u0002\u0013\u0005\u0013Q\u0012\u0005\n\u00037\u0003\u0011\u0011!C\u0001\u0003;C\u0011\"a*\u0001\u0003\u0003%\t%!+\b\u0013\u00055V$!A\t\u0002\u0005=f\u0001\u0003\u000f\u001e\u0003\u0003E\t!!-\t\rU3B\u0011AA`\u0011%\t\tMFA\u0001\n\u000b\n\u0019\rC\u0005\u0002FZ\t\t\u0011\"!\u0002H\"I\u0011q\u001a\f\u0002\u0002\u0013\u0005\u0015\u0011\u001b\u0005\n\u0003G4\u0012\u0011!C\u0005\u0003K\u0014\u0001e\u0011:fCR,\u0007j\\8eS\u0016$\u0016M\u00197f\u0003N\u001cV\r\\3di\u000e{W.\\1oI*\u0011adH\u0001\bG>lW.\u00198e\u0015\t\u0001\u0013%\u0001\u0003ik\u0012L'B\u0001\u0012$\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003I\u0015\nQa\u001d9be.T!AJ\u0014\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005A\u0013aA8sO\u000e\u00011#\u0002\u0001,kez\u0004C\u0001\u00174\u001b\u0005i#B\u0001\u00180\u0003\u001dawnZ5dC2T!\u0001M\u0019\u0002\u000bAd\u0017M\\:\u000b\u0005I\n\u0013\u0001C2bi\u0006d\u0017p\u001d;\n\u0005Qj#a\u0003'pO&\u001c\u0017\r\u001c)mC:\u0004\"AN\u001c\u000e\u0003uI!\u0001O\u000f\u00033!{w\u000eZ5f\u0019\u0016\fgMU;o]\u0006\u0014G.Z\"p[6\fg\u000e\u001a\t\u0003uuj\u0011a\u000f\u0006\u0002y\u0005)1oY1mC&\u0011ah\u000f\u0002\b!J|G-^2u!\tQ\u0004)\u0003\u0002Bw\ta1+\u001a:jC2L'0\u00192mK\u0006)A/\u00192mKV\tA\t\u0005\u0002F\u00116\taI\u0003\u0002Hc\u000591-\u0019;bY><\u0017BA%G\u00051\u0019\u0015\r^1m_\u001e$\u0016M\u00197f\u0003\u0019!\u0018M\u00197fA\u0005!Qn\u001c3f+\u0005i\u0005C\u0001(P\u001b\u0005\t\u0013B\u0001)\"\u0005!\u0019\u0016M^3N_\u0012,\u0017!B7pI\u0016\u0004\u0013!B9vKJLX#A\u0016\u0002\rE,XM]=!\u0003\u0019a\u0014N\\5u}Q!q\u000bW-[!\t1\u0004\u0001C\u0003C\u000f\u0001\u0007A\tC\u0003L\u000f\u0001\u0007Q\nC\u0003S\u000f\u0001\u00071&A\u0007j]:,'o\u00115jY\u0012\u0014XM\\\u000b\u0002;B\u0019aLZ5\u000f\u0005}#gB\u00011d\u001b\u0005\t'B\u00012*\u0003\u0019a$o\\8u}%\tA(\u0003\u0002fw\u00059\u0001/Y2lC\u001e,\u0017BA4i\u0005\r\u0019V-\u001d\u0006\u0003Kn\u0002$A\u001b9\u0011\u0007-dg.D\u00010\u0013\tiwFA\u0005Rk\u0016\u0014\u0018\u0010\u00157b]B\u0011q\u000e\u001d\u0007\u0001\t%\t\b\"!A\u0001\u0002\u000b\u0005!OA\u0002`IE\n\"a\u001d<\u0011\u0005i\"\u0018BA;<\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"AO<\n\u0005a\\$aA!os\u0006\u0019!/\u001e8\u0015\u0005m|\bc\u00010gyB\u0011a*`\u0005\u0003}\u0006\u00121AU8x\u0011\u001d\t\t!\u0003a\u0001\u0003\u0007\tAb\u001d9be.\u001cVm]:j_:\u00042ATA\u0003\u0013\r\t9!\t\u0002\r'B\f'o[*fgNLwN\\\u0001\u000fG2,\u0017M\u001d+bE2,\u0007+\u0019;i)\u0019\ti!a\u0005\u0002(A\u0019!(a\u0004\n\u0007\u0005E1H\u0001\u0003V]&$\bbBA\u000b\u0015\u0001\u0007\u0011qC\u0001\ni\u0006\u0014G.\u001a)bi\"\u0004B!!\u0007\u0002\"9!\u00111DA\u000f!\t\u00017(C\u0002\u0002 m\na\u0001\u0015:fI\u00164\u0017\u0002BA\u0012\u0003K\u0011aa\u0015;sS:<'bAA\u0010w!9\u0011\u0011\u0006\u0006A\u0002\u0005-\u0012\u0001B2p]\u001a\u0004B!!\f\u000265\u0011\u0011q\u0006\u0006\u0005\u0003S\t\tDC\u0002\u00024\u0015\na\u0001[1e_>\u0004\u0018\u0002BA\u001c\u0003_\u0011QbQ8oM&<WO]1uS>t\u0017\u0001B2paf$raVA\u001f\u0003\u007f\t\t\u0005C\u0004C\u0017A\u0005\t\u0019\u0001#\t\u000f-[\u0001\u0013!a\u0001\u001b\"9!k\u0003I\u0001\u0002\u0004Y\u0013AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003\u000fR3\u0001RA%W\t\tY\u0005\u0005\u0003\u0002N\u0005]SBAA(\u0015\u0011\t\t&a\u0015\u0002\u0013Ut7\r[3dW\u0016$'bAA+w\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005e\u0013q\n\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003?R3!TA%\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"!!\u001a+\u0007-\nI%A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003W\u0002B!!\u001c\u0002x5\u0011\u0011q\u000e\u0006\u0005\u0003c\n\u0019(\u0001\u0003mC:<'BAA;\u0003\u0011Q\u0017M^1\n\t\u0005\r\u0012qN\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003{\u00022AOA@\u0013\r\t\ti\u000f\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004m\u0006\u001d\u0005\"CAE#\u0005\u0005\t\u0019AA?\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011q\u0012\t\u0006\u0003#\u000b9J^\u0007\u0003\u0003'S1!!&<\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u00033\u000b\u0019J\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BAP\u0003K\u00032AOAQ\u0013\r\t\u0019k\u000f\u0002\b\u0005>|G.Z1o\u0011!\tIiEA\u0001\u0002\u00041\u0018AB3rk\u0006d7\u000f\u0006\u0003\u0002 \u0006-\u0006\u0002CAE)\u0005\u0005\t\u0019\u0001<\u0002A\r\u0013X-\u0019;f\u0011>|G-[3UC\ndW-Q:TK2,7\r^\"p[6\fg\u000e\u001a\t\u0003mY\u0019BAFAZ\u007fAA\u0011QWA^\t6[s+\u0004\u0002\u00028*\u0019\u0011\u0011X\u001e\u0002\u000fI,h\u000e^5nK&!\u0011QXA\\\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\u000b\u0003\u0003_\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003W\nQ!\u00199qYf$raVAe\u0003\u0017\fi\rC\u0003C3\u0001\u0007A\tC\u0003L3\u0001\u0007Q\nC\u0003S3\u0001\u00071&A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005M\u0017q\u001c\t\u0006u\u0005U\u0017\u0011\\\u0005\u0004\u0003/\\$AB(qi&|g\u000e\u0005\u0004;\u00037$UjK\u0005\u0004\u0003;\\$A\u0002+va2,7\u0007\u0003\u0005\u0002bj\t\t\u00111\u0001X\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002hB!\u0011QNAu\u0013\u0011\tY/a\u001c\u0003\r=\u0013'.Z2u\u0001")
public class CreateHoodieTableAsSelectCommand
extends LogicalPlan
implements HoodieLeafRunnableCommand,
scala.Serializable {
    private final CatalogTable table;
    private final SaveMode mode;
    private final LogicalPlan query;
    private scala.collection.immutable.Map<String, SQLMetric> metrics;
    private final Seq<Enumeration.Value> nodePatterns;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<CatalogTable, SaveMode, LogicalPlan>> unapply(CreateHoodieTableAsSelectCommand createHoodieTableAsSelectCommand) {
        return CreateHoodieTableAsSelectCommand$.MODULE$.unapply(createHoodieTableAsSelectCommand);
    }

    public static Function1<Tuple3<CatalogTable, SaveMode, LogicalPlan>, CreateHoodieTableAsSelectCommand> tupled() {
        return CreateHoodieTableAsSelectCommand$.MODULE$.tupled();
    }

    public static Function1<CatalogTable, Function1<SaveMode, Function1<LogicalPlan, CreateHoodieTableAsSelectCommand>>> curried() {
        return CreateHoodieTableAsSelectCommand$.MODULE$.curried();
    }

    @Override
    public final Seq<LogicalPlan> children() {
        return HoodieLeafLike.children$(this);
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return HoodieLeafLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return HoodieLeafLike.withNewChildrenInternal$(this, newChildren);
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public AttributeSet producedAttributes() {
        return Command.producedAttributes$((Command)this);
    }

    public Statistics stats() {
        return Command.stats$((Command)this);
    }

    private scala.collection.immutable.Map<String, SQLMetric> metrics$lzycompute() {
        CreateHoodieTableAsSelectCommand createHoodieTableAsSelectCommand = this;
        synchronized (createHoodieTableAsSelectCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$((RunnableCommand)this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    public scala.collection.immutable.Map<String, SQLMetric> metrics() {
        return !this.bitmap$0 ? this.metrics$lzycompute() : this.metrics;
    }

    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    public final void org$apache$spark$sql$catalyst$plans$logical$Command$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public CatalogTable table() {
        return this.table;
    }

    public SaveMode mode() {
        return this.mode;
    }

    public LogicalPlan query() {
        return this.query;
    }

    public Seq<QueryPlan<?>> innerChildren() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LogicalPlan[]{this.query()}));
    }

    public Seq<Row> run(SparkSession sparkSession) {
        CatalogTableType catalogTableType = this.table().tableType();
        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
        ValidationUtils.checkState(catalogTableType == null ? catalogTableType2 != null : !catalogTableType.equals(catalogTableType2));
        ValidationUtils.checkState(this.table().provider().isDefined());
        boolean hasQueryAsProp = this.table().storage().properties().$plus$plus((GenTraversableOnce)this.table().properties()).contains((Object)"hoodie.query.as.ro.table");
        if (hasQueryAsProp) {
            throw new AnalysisException("Not support CTAS for the ro/rt table", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
        }
        SessionState sessionState = sparkSession.sessionState();
        String db = (String)this.table().identifier().database().getOrElse((Function0 & Serializable & scala.Serializable)() -> sessionState.catalog().getCurrentDatabase());
        Some x$12 = new Some((Object)db);
        String x$2 = this.table().identifier().copy$default$1();
        TableIdentifier qualifiedTableIdentifier = this.table().identifier().copy(x$2, (Option)x$12);
        String tableName = qualifiedTableIdentifier.unquotedString();
        if (sessionState.catalog().tableExists(qualifiedTableIdentifier)) {
            SaveMode saveMode = this.mode();
            SaveMode saveMode2 = SaveMode.Overwrite;
            ValidationUtils.checkState(saveMode == null ? saveMode2 != null : !saveMode.equals(saveMode2), new StringBuilder(66).append("Expect the table ").append(tableName).append(" has been dropped when the save mode is Overwrite").toString());
            SaveMode saveMode3 = this.mode();
            SaveMode saveMode4 = SaveMode.ErrorIfExists;
            if (!(saveMode3 != null ? !saveMode3.equals(saveMode4) : saveMode4 != null)) {
                throw new AnalysisException(new StringBuilder(49).append("Table ").append(tableName).append(" already exists. You need to drop it first.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
            }
            SaveMode saveMode5 = this.mode();
            SaveMode saveMode6 = SaveMode.Ignore;
            if (!(saveMode5 != null ? !saveMode5.equals(saveMode6) : saveMode6 != null)) {
                return (Seq)Seq$.MODULE$.empty();
            }
        }
        scala.collection.immutable.Map x$3 = (scala.collection.immutable.Map)this.table().storage().properties().$minus$minus(HoodieCatalogTable$.MODULE$.needFilterProps());
        Option x$4 = this.table().storage().copy$default$1();
        Option x$5 = this.table().storage().copy$default$2();
        Option x$6 = this.table().storage().copy$default$3();
        Option x$7 = this.table().storage().copy$default$4();
        boolean x$8 = this.table().storage().copy$default$5();
        CatalogStorageFormat updatedStorageFormat = this.table().storage().copy(x$4, x$5, x$6, x$7, x$8, x$3);
        TableIdentifier x$9 = qualifiedTableIdentifier;
        CatalogStorageFormat x$10 = updatedStorageFormat;
        StructType x$11 = this.query().schema();
        scala.collection.immutable.Map x$122 = (scala.collection.immutable.Map)this.table().properties().$minus$minus(HoodieCatalogTable$.MODULE$.needFilterProps());
        CatalogTableType x$13 = this.table().copy$default$2();
        Option x$14 = this.table().copy$default$5();
        Seq x$15 = this.table().copy$default$6();
        Option x$16 = this.table().copy$default$7();
        String x$17 = this.table().copy$default$8();
        long x$18 = this.table().copy$default$9();
        long x$19 = this.table().copy$default$10();
        String x$20 = this.table().copy$default$11();
        Option x$21 = this.table().copy$default$13();
        Option x$22 = this.table().copy$default$14();
        Option x$23 = this.table().copy$default$15();
        Seq x$24 = this.table().copy$default$16();
        boolean x$25 = this.table().copy$default$17();
        boolean x$26 = this.table().copy$default$18();
        scala.collection.immutable.Map x$27 = this.table().copy$default$19();
        Option x$28 = this.table().copy$default$20();
        CatalogTable updatedTable = this.table().copy(x$9, x$13, x$10, x$11, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$122, x$21, x$22, x$23, x$24, x$25, x$26, x$27, x$28);
        HoodieCatalogTable hoodieCatalogTable = HoodieCatalogTable$.MODULE$.apply(sparkSession, updatedTable);
        String tablePath = hoodieCatalogTable.tableLocation();
        Configuration hadoopConf = sparkSession.sessionState().newHadoopConf();
        try {
            hoodieCatalogTable.initHoodieTable();
            scala.collection.immutable.Map<String, String> tableProperties = hoodieCatalogTable.catalogProperties();
            Tuple2[] tuple2Array = new Tuple2[6];
            CatalogTableType catalogTableType3 = this.table().tableType();
            CatalogTableType catalogTableType4 = CatalogTableType$.MODULE$.MANAGED();
            tuple2Array[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveSyncConfigHolder.HIVE_CREATE_MANAGED_TABLE.key()), (Object)((Object)BoxesRunTime.boxToBoolean((!(catalogTableType3 != null ? !catalogTableType3.equals(catalogTableType4) : catalogTableType4 != null) ? 1 : 0) != 0)).toString());
            tuple2Array[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveSyncConfigHolder.HIVE_TABLE_SERDE_PROPERTIES.key()), (Object)ConfigUtils.configToString((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(tableProperties).asJava()));
            tuple2Array[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveSyncConfigHolder.HIVE_TABLE_PROPERTIES.key()), (Object)ConfigUtils.configToString((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)updatedTable.properties()).asJava()));
            tuple2Array[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.COMBINE_BEFORE_INSERT.key()), (Object)"false");
            tuple2Array[4] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.SQL_INSERT_MODE().key()), (Object)InsertMode.NON_STRICT.value());
            tuple2Array[5] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.SQL_ENABLE_BULK_INSERT().key()), (Object)"true");
            scala.collection.immutable.Map options = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
            scala.collection.immutable.Map partitionSpec = ((TraversableOnce)updatedTable.partitionColumnNames().map((Function1 & Serializable & scala.Serializable)x$1 -> new Tuple2(x$1, (Object)None$.MODULE$), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            SaveMode saveMode = this.mode();
            SaveMode saveMode7 = SaveMode.Overwrite;
            boolean success = InsertIntoHoodieTableCommand$.MODULE$.run(sparkSession, updatedTable, this.query(), (scala.collection.immutable.Map<String, Option<String>>)partitionSpec, !(saveMode != null ? !saveMode.equals(saveMode7) : saveMode7 != null), false, (scala.collection.immutable.Map<String, String>)options);
            if (success) {
                if (!sparkSession.sessionState().catalog().tableExists(qualifiedTableIdentifier)) {
                    SaveMode saveMode8 = this.mode();
                    SaveMode saveMode9 = SaveMode.Ignore;
                    CreateHoodieTableCommand$.MODULE$.createTableInCatalog(sparkSession, hoodieCatalogTable, !(saveMode8 != null ? !saveMode8.equals(saveMode9) : saveMode9 != null), CreateHoodieTableCommand$.MODULE$.createTableInCatalog$default$4());
                }
            } else {
                this.clearTablePath(tablePath, hadoopConf);
            }
        }
        catch (Throwable e) {
            if (!hoodieCatalogTable.hoodieTableExists()) {
                this.clearTablePath(tablePath, hadoopConf);
            }
            throw e;
        }
        return (Seq)Seq$.MODULE$.empty();
    }

    private void clearTablePath(String tablePath, Configuration conf) {
        Path path = new Path(tablePath);
        FileSystem fs = path.getFileSystem(conf);
        fs.delete(path, true);
    }

    public CreateHoodieTableAsSelectCommand copy(CatalogTable table, SaveMode mode, LogicalPlan query) {
        return new CreateHoodieTableAsSelectCommand(table, mode, query);
    }

    public CatalogTable copy$default$1() {
        return this.table();
    }

    public SaveMode copy$default$2() {
        return this.mode();
    }

    public LogicalPlan copy$default$3() {
        return this.query();
    }

    public String productPrefix() {
        return "CreateHoodieTableAsSelectCommand";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        CatalogTable catalogTable;
        int n = x$1;
        switch (n) {
            case 0: {
                catalogTable = this.table();
                break;
            }
            case 1: {
                catalogTable = this.mode();
                break;
            }
            case 2: {
                catalogTable = this.query();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return catalogTable;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CreateHoodieTableAsSelectCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CreateHoodieTableAsSelectCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        CreateHoodieTableAsSelectCommand createHoodieTableAsSelectCommand = (CreateHoodieTableAsSelectCommand)x$1;
        CatalogTable catalogTable = this.table();
        CatalogTable catalogTable2 = createHoodieTableAsSelectCommand.table();
        if (catalogTable == null) {
            if (catalogTable2 != null) {
                return false;
            }
        } else if (!catalogTable.equals(catalogTable2)) return false;
        SaveMode saveMode = this.mode();
        SaveMode saveMode2 = createHoodieTableAsSelectCommand.mode();
        if (saveMode == null) {
            if (saveMode2 != null) {
                return false;
            }
        } else if (!saveMode.equals(saveMode2)) return false;
        LogicalPlan logicalPlan = this.query();
        LogicalPlan logicalPlan2 = createHoodieTableAsSelectCommand.query();
        if (logicalPlan == null) {
            if (logicalPlan2 != null) {
                return false;
            }
        } else if (!logicalPlan.equals(logicalPlan2)) return false;
        if (!createHoodieTableAsSelectCommand.canEqual(this)) return false;
        return true;
    }

    public CreateHoodieTableAsSelectCommand(CatalogTable table, SaveMode mode, LogicalPlan query) {
        this.table = table;
        this.mode = mode;
        this.query = query;
        Command.$init$((Command)this);
        RunnableCommand.$init$((RunnableCommand)this);
        HoodieLeafLike.$init$(this);
    }
}

