/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command;

import org.apache.hudi.SparkAdapterSupport;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.exception.HoodieException;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTable$;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.trees.HoodieLeafLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.hudi.HoodieOptionConfig$;
import org.apache.spark.sql.hudi.SparkAdapter;
import org.apache.spark.sql.hudi.command.CreateHoodieTableCommand$;
import org.apache.spark.sql.hudi.command.CreateHoodieTableLikeCommand$;
import org.apache.spark.sql.hudi.command.HoodieLeafRunnableCommand;
import org.apache.spark.sql.types.StructType;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple5;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u00055h\u0001\u0002\u0012$\u0001BB\u0001\"\u0014\u0001\u0003\u0016\u0004%\tA\u0014\u0005\t'\u0002\u0011\t\u0012)A\u0005\u001f\"AA\u000b\u0001BK\u0002\u0013\u0005a\n\u0003\u0005V\u0001\tE\t\u0015!\u0003P\u0011!1\u0006A!f\u0001\n\u00039\u0006\u0002\u00030\u0001\u0005#\u0005\u000b\u0011\u0002-\t\u0011}\u0003!Q3A\u0005\u0002\u0001D\u0001b\u001c\u0001\u0003\u0012\u0003\u0006I!\u0019\u0005\ta\u0002\u0011)\u001a!C\u0001c\"AQ\u000f\u0001B\tB\u0003%!\u000fC\u0003w\u0001\u0011\u0005q\u000fC\u0003\u007f\u0001\u0011\u0005s\u0010C\u0005\u0002&\u0001\t\t\u0011\"\u0001\u0002(!I\u00111\u0007\u0001\u0012\u0002\u0013\u0005\u0011Q\u0007\u0005\n\u0003\u0017\u0002\u0011\u0013!C\u0001\u0003kA\u0011\"!\u0014\u0001#\u0003%\t!a\u0014\t\u0013\u0005M\u0003!%A\u0005\u0002\u0005U\u0003\"CA-\u0001E\u0005I\u0011AA.\u0011%\ty\u0006AA\u0001\n\u0003\n\t\u0007C\u0005\u0002r\u0001\t\t\u0011\"\u0001\u0002t!I\u00111\u0010\u0001\u0002\u0002\u0013\u0005\u0011Q\u0010\u0005\n\u0003\u0013\u0003\u0011\u0011!C!\u0003\u0017C\u0011\"!'\u0001\u0003\u0003%\t!a'\t\u0013\u0005}\u0005!!A\u0005B\u0005\u0005v!CASG\u0005\u0005\t\u0012AAT\r!\u00113%!A\t\u0002\u0005%\u0006B\u0002<\u001b\t\u0003\t9\fC\u0005\u0002:j\t\t\u0011\"\u0012\u0002<\"I\u0011Q\u0018\u000e\u0002\u0002\u0013\u0005\u0015q\u0018\u0005\n\u0003\u0017T\u0012\u0013!C\u0001\u0003+B\u0011\"!4\u001b\u0003\u0003%\t)a4\t\u0013\u0005\u0005($%A\u0005\u0002\u0005U\u0003\"CAr5\u0005\u0005I\u0011BAs\u0005q\u0019%/Z1uK\"{w\u000eZ5f)\u0006\u0014G.\u001a'jW\u0016\u001cu.\\7b]\u0012T!\u0001J\u0013\u0002\u000f\r|W.\\1oI*\u0011aeJ\u0001\u0005QV$\u0017N\u0003\u0002)S\u0005\u00191/\u001d7\u000b\u0005)Z\u0013!B:qCJ\\'B\u0001\u0017.\u0003\u0019\t\u0007/Y2iK*\ta&A\u0002pe\u001e\u001c\u0001a\u0005\u0004\u0001cmzDI\u0013\t\u0003eej\u0011a\r\u0006\u0003iU\nq\u0001\\8hS\u000e\fGN\u0003\u00027o\u0005)\u0001\u000f\\1og*\u0011\u0001hJ\u0001\tG\u0006$\u0018\r\\=ti&\u0011!h\r\u0002\f\u0019><\u0017nY1m!2\fg\u000e\u0005\u0002={5\t1%\u0003\u0002?G\tI\u0002j\\8eS\u0016dU-\u00194Sk:t\u0017M\u00197f\u0007>lW.\u00198e!\t\u0001%)D\u0001B\u0015\t13&\u0003\u0002D\u0003\n\u00192\u000b]1sW\u0006#\u0017\r\u001d;feN+\b\u000f]8siB\u0011Q\tS\u0007\u0002\r*\tq)A\u0003tG\u0006d\u0017-\u0003\u0002J\r\n9\u0001K]8ek\u000e$\bCA#L\u0013\taeI\u0001\u0007TKJL\u0017\r\\5{C\ndW-A\u0006uCJ<W\r\u001e+bE2,W#A(\u0011\u0005A\u000bV\"A\u001c\n\u0005I;$a\u0004+bE2,\u0017\nZ3oi&4\u0017.\u001a:\u0002\u0019Q\f'oZ3u)\u0006\u0014G.\u001a\u0011\u0002\u0017M|WO]2f)\u0006\u0014G.Z\u0001\rg>,(oY3UC\ndW\rI\u0001\u000bM&dWMR8s[\u0006$X#\u0001-\u0011\u0005ecV\"\u0001.\u000b\u0005m;\u0014aB2bi\u0006dwnZ\u0005\u0003;j\u0013AcQ1uC2|wm\u0015;pe\u0006<WMR8s[\u0006$\u0018a\u00034jY\u00164uN]7bi\u0002\n!\u0002\u001d:pa\u0016\u0014H/[3t+\u0005\t\u0007\u0003\u00022jY2t!aY4\u0011\u0005\u00114U\"A3\u000b\u0005\u0019|\u0013A\u0002\u001fs_>$h(\u0003\u0002i\r\u00061\u0001K]3eK\u001aL!A[6\u0003\u00075\u000b\u0007O\u0003\u0002i\rB\u0011!-\\\u0005\u0003].\u0014aa\u0015;sS:<\u0017a\u00039s_B,'\u000f^5fg\u0002\na\"[4o_J,\u0017JZ#ySN$8/F\u0001s!\t)5/\u0003\u0002u\r\n9!i\\8mK\u0006t\u0017aD5h]>\u0014X-\u00134Fq&\u001cHo\u001d\u0011\u0002\rqJg.\u001b;?)\u0019A\u0018P_>}{B\u0011A\b\u0001\u0005\u0006\u001b.\u0001\ra\u0014\u0005\u0006).\u0001\ra\u0014\u0005\u0006-.\u0001\r\u0001\u0017\u0005\b?.\u0001\n\u00111\u0001b\u0011\u0015\u00018\u00021\u0001s\u0003\r\u0011XO\u001c\u000b\u0005\u0003\u0003\tY\u0002\u0005\u0004\u0002\u0004\u00055\u00111\u0003\b\u0005\u0003\u000b\tIAD\u0002e\u0003\u000fI\u0011aR\u0005\u0004\u0003\u00171\u0015a\u00029bG.\fw-Z\u0005\u0005\u0003\u001f\t\tBA\u0002TKFT1!a\u0003G!\u0011\t)\"a\u0006\u000e\u0003\u001dJ1!!\u0007(\u0005\r\u0011vn\u001e\u0005\b\u0003;a\u0001\u0019AA\u0010\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o!\u0011\t)\"!\t\n\u0007\u0005\rrE\u0001\u0007Ta\u0006\u00148nU3tg&|g.\u0001\u0003d_BLHc\u0003=\u0002*\u0005-\u0012QFA\u0018\u0003cAq!T\u0007\u0011\u0002\u0003\u0007q\nC\u0004U\u001bA\u0005\t\u0019A(\t\u000fYk\u0001\u0013!a\u00011\"9q,\u0004I\u0001\u0002\u0004\t\u0007b\u00029\u000e!\u0003\u0005\rA]\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t9DK\u0002P\u0003sY#!a\u000f\u0011\t\u0005u\u0012qI\u0007\u0003\u0003\u007fQA!!\u0011\u0002D\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u000b2\u0015AC1o]>$\u0018\r^5p]&!\u0011\u0011JA \u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"!!\u0015+\u0007a\u000bI$\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u0005]#fA1\u0002:\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012*TCAA/U\r\u0011\u0018\u0011H\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005\r\u0004\u0003BA3\u0003_j!!a\u001a\u000b\t\u0005%\u00141N\u0001\u0005Y\u0006twM\u0003\u0002\u0002n\u0005!!.\u0019<b\u0013\rq\u0017qM\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003k\u00022!RA<\u0013\r\tIH\u0012\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003\u007f\n)\tE\u0002F\u0003\u0003K1!a!G\u0005\r\te.\u001f\u0005\n\u0003\u000f+\u0012\u0011!a\u0001\u0003k\n1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAG!\u0019\ty)!&\u0002\u00005\u0011\u0011\u0011\u0013\u0006\u0004\u0003'3\u0015AC2pY2,7\r^5p]&!\u0011qSAI\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007I\fi\nC\u0005\u0002\b^\t\t\u00111\u0001\u0002\u0000\u00051Q-];bYN$2A]AR\u0011%\t9\tGA\u0001\u0002\u0004\ty(\u0001\u000fDe\u0016\fG/\u001a%p_\u0012LW\rV1cY\u0016d\u0015n[3D_6l\u0017M\u001c3\u0011\u0005qR2\u0003\u0002\u000e\u0002,*\u0003\"\"!,\u00024>{\u0005,\u0019:y\u001b\t\tyKC\u0002\u00022\u001a\u000bqA];oi&lW-\u0003\u0003\u00026\u0006=&!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8okQ\u0011\u0011qU\u0001\ti>\u001cFO]5oOR\u0011\u00111M\u0001\u0006CB\u0004H.\u001f\u000b\fq\u0006\u0005\u00171YAc\u0003\u000f\fI\rC\u0003N;\u0001\u0007q\nC\u0003U;\u0001\u0007q\nC\u0003W;\u0001\u0007\u0001\fC\u0004`;A\u0005\t\u0019A1\t\u000bAl\u0002\u0019\u0001:\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIQ\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002R\u0006u\u0007#B#\u0002T\u0006]\u0017bAAk\r\n1q\n\u001d;j_:\u0004\u0002\"RAm\u001f>C\u0016M]\u0005\u0004\u000374%A\u0002+va2,W\u0007\u0003\u0005\u0002`~\t\t\u00111\u0001y\u0003\rAH\u0005M\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003O\u0004B!!\u001a\u0002j&!\u00111^A4\u0005\u0019y%M[3di\u0002")
public class CreateHoodieTableLikeCommand
extends LogicalPlan
implements HoodieLeafRunnableCommand,
SparkAdapterSupport,
Serializable {
    private final TableIdentifier targetTable;
    private final TableIdentifier sourceTable;
    private final CatalogStorageFormat fileFormat;
    private final Map<String, String> properties;
    private final boolean ignoreIfExists;
    private SparkAdapter sparkAdapter;
    private Map<String, SQLMetric> metrics;
    private final Seq<Enumeration.Value> nodePatterns;
    private volatile byte bitmap$0;

    public static Map<String, String> $lessinit$greater$default$4() {
        return CreateHoodieTableLikeCommand$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple5<TableIdentifier, TableIdentifier, CatalogStorageFormat, Map<String, String>, Object>> unapply(CreateHoodieTableLikeCommand createHoodieTableLikeCommand) {
        return CreateHoodieTableLikeCommand$.MODULE$.unapply(createHoodieTableLikeCommand);
    }

    public static Map<String, String> apply$default$4() {
        return CreateHoodieTableLikeCommand$.MODULE$.apply$default$4();
    }

    public static Function1<Tuple5<TableIdentifier, TableIdentifier, CatalogStorageFormat, Map<String, String>, Object>, CreateHoodieTableLikeCommand> tupled() {
        return CreateHoodieTableLikeCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<TableIdentifier, Function1<CatalogStorageFormat, Function1<Map<String, String>, Function1<Object, CreateHoodieTableLikeCommand>>>>> curried() {
        return CreateHoodieTableLikeCommand$.MODULE$.curried();
    }

    @Override
    public final Seq<LogicalPlan> children() {
        return HoodieLeafLike.children$(this);
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return HoodieLeafLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return HoodieLeafLike.withNewChildrenInternal$(this, newChildren);
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public AttributeSet producedAttributes() {
        return Command.producedAttributes$((Command)this);
    }

    public Statistics stats() {
        return Command.stats$((Command)this);
    }

    private SparkAdapter sparkAdapter$lzycompute() {
        CreateHoodieTableLikeCommand createHoodieTableLikeCommand = this;
        synchronized (createHoodieTableLikeCommand) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.sparkAdapter = SparkAdapterSupport.sparkAdapter$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.sparkAdapter;
    }

    @Override
    public SparkAdapter sparkAdapter() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.sparkAdapter$lzycompute() : this.sparkAdapter;
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        CreateHoodieTableLikeCommand createHoodieTableLikeCommand = this;
        synchronized (createHoodieTableLikeCommand) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.metrics = RunnableCommand.metrics$((RunnableCommand)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.metrics;
    }

    public Map<String, SQLMetric> metrics() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.metrics$lzycompute() : this.metrics;
    }

    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    public final void org$apache$spark$sql$catalyst$plans$logical$Command$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public TableIdentifier targetTable() {
        return this.targetTable;
    }

    public TableIdentifier sourceTable() {
        return this.sourceTable;
    }

    public CatalogStorageFormat fileFormat() {
        return this.fileFormat;
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    public boolean ignoreIfExists() {
        return this.ignoreIfExists;
    }

    public Seq<Row> run(SparkSession sparkSession) {
        SessionCatalog catalog = sparkSession.sessionState().catalog();
        boolean tableIsExists = catalog.tableExists(this.targetTable());
        if (tableIsExists) {
            if (this.ignoreIfExists()) {
                return (Seq)Seq$.MODULE$.empty();
            }
            throw new IllegalArgumentException(new StringBuilder(22).append("Table ").append(this.targetTable()).append(" already exists.").toString());
        }
        CatalogTable sourceTableDesc = catalog.getTempViewOrPermanentTableMetadata(this.sourceTable());
        CatalogStorageFormat newStorage = this.fileFormat().inputFormat().isDefined() ? this.fileFormat() : sourceTableDesc.storage().copy(this.fileFormat().locationUri(), sourceTableDesc.storage().copy$default$2(), sourceTableDesc.storage().copy$default$3(), sourceTableDesc.storage().copy$default$4(), sourceTableDesc.storage().copy$default$5(), sourceTableDesc.storage().copy$default$6());
        CatalogTableType tblType = newStorage.locationUri().isEmpty() ? CatalogTableType$.MODULE$.MANAGED() : CatalogTableType$.MODULE$.EXTERNAL();
        Map targetTableProperties = this.sparkAdapter().isHoodieTable(sourceTableDesc) ? HoodieOptionConfig$.MODULE$.extractHoodieOptions((Map<String, String>)sourceTableDesc.properties()).$plus$plus(this.properties()) : this.properties();
        TableIdentifier x$1 = this.targetTable();
        CatalogTableType x$2 = tblType;
        CatalogStorageFormat x$3 = newStorage;
        StructType x$4 = sourceTableDesc.schema();
        Some x$5 = new Some((Object)"hudi");
        Seq x$6 = sourceTableDesc.partitionColumnNames();
        Option x$7 = sourceTableDesc.bucketSpec();
        Map x$8 = targetTableProperties;
        boolean x$9 = sourceTableDesc.tracksPartitionsInCatalog();
        String x$10 = CatalogTable$.MODULE$.apply$default$8();
        long x$11 = CatalogTable$.MODULE$.apply$default$9();
        long x$12 = CatalogTable$.MODULE$.apply$default$10();
        String x$13 = CatalogTable$.MODULE$.apply$default$11();
        Option x$14 = CatalogTable$.MODULE$.apply$default$13();
        Option x$15 = CatalogTable$.MODULE$.apply$default$14();
        Option x$16 = CatalogTable$.MODULE$.apply$default$15();
        Seq x$17 = CatalogTable$.MODULE$.apply$default$16();
        boolean x$18 = CatalogTable$.MODULE$.apply$default$18();
        Map x$19 = CatalogTable$.MODULE$.apply$default$19();
        Option x$20 = CatalogTable$.MODULE$.apply$default$20();
        CatalogTable newTableDesc = new CatalogTable(x$1, x$2, x$3, x$4, (Option)x$5, x$6, x$7, x$10, x$11, x$12, x$13, x$8, x$14, x$15, x$16, x$17, x$9, x$18, x$19, x$20);
        HoodieCatalogTable hoodieCatalogTable = HoodieCatalogTable$.MODULE$.apply(sparkSession, newTableDesc);
        CreateHoodieTableCommand$.MODULE$.validateTblProperties(hoodieCatalogTable);
        Option queryAsProp = hoodieCatalogTable.catalogProperties().get((Object)"hoodie.query.as.ro.table");
        if (queryAsProp.isEmpty()) {
            hoodieCatalogTable.initHoodieTable();
        } else {
            if (!hoodieCatalogTable.hoodieTableExists()) {
                throw new AnalysisException("Creating ro/rt table need the existence of the base table.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
            }
            if (!((Object)((Object)HoodieTableType.MERGE_ON_READ)).equals((Object)hoodieCatalogTable.tableType())) {
                throw new AnalysisException("Creating ro/rt table should only apply to a mor table.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
            }
        }
        try {
            CreateHoodieTableCommand$.MODULE$.createTableInCatalog(sparkSession, hoodieCatalogTable, this.ignoreIfExists(), (Option<String>)queryAsProp);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                throw new HoodieException("Failed to create catalog table in metastore", e);
            }
            throw throwable;
        }
        return (Seq)Seq$.MODULE$.empty();
    }

    public CreateHoodieTableLikeCommand copy(TableIdentifier targetTable, TableIdentifier sourceTable, CatalogStorageFormat fileFormat, Map<String, String> properties, boolean ignoreIfExists) {
        return new CreateHoodieTableLikeCommand(targetTable, sourceTable, fileFormat, properties, ignoreIfExists);
    }

    public TableIdentifier copy$default$1() {
        return this.targetTable();
    }

    public TableIdentifier copy$default$2() {
        return this.sourceTable();
    }

    public CatalogStorageFormat copy$default$3() {
        return this.fileFormat();
    }

    public Map<String, String> copy$default$4() {
        return this.properties();
    }

    public boolean copy$default$5() {
        return this.ignoreIfExists();
    }

    public String productPrefix() {
        return "CreateHoodieTableLikeCommand";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.targetTable();
                break;
            }
            case 1: {
                object = this.sourceTable();
                break;
            }
            case 2: {
                object = this.fileFormat();
                break;
            }
            case 3: {
                object = this.properties();
                break;
            }
            case 4: {
                object = BoxesRunTime.boxToBoolean((boolean)this.ignoreIfExists());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CreateHoodieTableLikeCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CreateHoodieTableLikeCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        CreateHoodieTableLikeCommand createHoodieTableLikeCommand = (CreateHoodieTableLikeCommand)x$1;
        TableIdentifier tableIdentifier = this.targetTable();
        TableIdentifier tableIdentifier2 = createHoodieTableLikeCommand.targetTable();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        TableIdentifier tableIdentifier3 = this.sourceTable();
        TableIdentifier tableIdentifier4 = createHoodieTableLikeCommand.sourceTable();
        if (tableIdentifier3 == null) {
            if (tableIdentifier4 != null) {
                return false;
            }
        } else if (!tableIdentifier3.equals(tableIdentifier4)) return false;
        CatalogStorageFormat catalogStorageFormat = this.fileFormat();
        CatalogStorageFormat catalogStorageFormat2 = createHoodieTableLikeCommand.fileFormat();
        if (catalogStorageFormat == null) {
            if (catalogStorageFormat2 != null) {
                return false;
            }
        } else if (!catalogStorageFormat.equals(catalogStorageFormat2)) return false;
        Map<String, String> map = this.properties();
        Map<String, String> map2 = createHoodieTableLikeCommand.properties();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        if (this.ignoreIfExists() != createHoodieTableLikeCommand.ignoreIfExists()) return false;
        if (!createHoodieTableLikeCommand.canEqual(this)) return false;
        return true;
    }

    public CreateHoodieTableLikeCommand(TableIdentifier targetTable, TableIdentifier sourceTable, CatalogStorageFormat fileFormat, Map<String, String> properties, boolean ignoreIfExists) {
        this.targetTable = targetTable;
        this.sourceTable = sourceTable;
        this.fileFormat = fileFormat;
        this.properties = properties;
        this.ignoreIfExists = ignoreIfExists;
        Command.$init$((Command)this);
        RunnableCommand.$init$((RunnableCommand)this);
        HoodieLeafLike.$init$(this);
        SparkAdapterSupport.$init$(this);
    }
}

