/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.io.Serializable;
import org.apache.hudi.HoodieCLIUtils$;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.model.HoodieFailedWritesCleaningPolicy;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.timeline.versioning.TimelineLayoutVersion;
import org.apache.hudi.config.HoodieCleanConfig;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.table.upgrade.SparkUpgradeDowngradeHelper;
import org.apache.hudi.table.upgrade.UpgradeDowngrade;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u000154Aa\u0003\u0007\u00017!)\u0011\u0006\u0001C\u0001U!9A\u0006\u0001b\u0001\n\u0013i\u0003BB\u001c\u0001A\u0003%a\u0006C\u00049\u0001\t\u0007I\u0011B\u001d\t\r\u0001\u0003\u0001\u0015!\u0003;\u0011\u0015\t\u0005\u0001\"\u0001.\u0011\u0015\u0011\u0005\u0001\"\u0001:\u0011\u0015\u0019\u0005\u0001\"\u0011E\u0011\u0015Q\u0006\u0001\"\u0003\\\u0011\u0015Y\u0007\u0001\"\u0011m\u0005m)\u0006o\u001a:bI\u0016|%\u000fR8x]\u001e\u0014\u0018\rZ3Qe>\u001cW\rZ;sK*\u0011QBD\u0001\u000baJ|7-\u001a3ve\u0016\u001c(BA\b\u0011\u0003\u001d\u0019w.\\7b]\u0012T!!\u0005\n\u0002\t!,H-\u001b\u0006\u0003'Q\t1a]9m\u0015\t)b#A\u0003ta\u0006\u00148N\u0003\u0002\u00181\u00051\u0011\r]1dQ\u0016T\u0011!G\u0001\u0004_J<7\u0001A\n\u0005\u0001q\u00013\u0005\u0005\u0002\u001e=5\tA\"\u0003\u0002 \u0019\ti!)Y:f!J|7-\u001a3ve\u0016\u0004\"!H\u0011\n\u0005\tb!\u0001\u0005)s_\u000e,G-\u001e:f\u0005VLG\u000eZ3s!\t!s%D\u0001&\u0015\t1C#\u0001\u0005j]R,'O\\1m\u0013\tASEA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u0005Y\u0003CA\u000f\u0001\u0003)\u0001\u0016IU!N\u000bR+%kU\u000b\u0002]A\u0019qF\r\u001b\u000e\u0003AR\u0011!M\u0001\u0006g\u000e\fG.Y\u0005\u0003gA\u0012Q!\u0011:sCf\u0004\"!H\u001b\n\u0005Yb!A\u0005)s_\u000e,G-\u001e:f!\u0006\u0014\u0018-\\3uKJ\f1\u0002U!S\u00036+E+\u0012*TA\u0005Yq*\u0016+Q+R{F+\u0017)F+\u0005Q\u0004CA\u001e?\u001b\u0005a$BA\u001f\u0013\u0003\u0015!\u0018\u0010]3t\u0013\tyDH\u0001\u0006TiJ,8\r\u001e+za\u0016\fAbT+U!V#v\fV-Q\u000b\u0002\n!\u0002]1sC6,G/\u001a:t\u0003)yW\u000f\u001e9viRK\b/Z\u0001\u0005G\u0006dG\u000e\u0006\u0002F+B\u0019aIT)\u000f\u0005\u001dceB\u0001%L\u001b\u0005I%B\u0001&\u001b\u0003\u0019a$o\\8u}%\t\u0011'\u0003\u0002Na\u00059\u0001/Y2lC\u001e,\u0017BA(Q\u0005\r\u0019V-\u001d\u0006\u0003\u001bB\u0002\"AU*\u000e\u0003II!\u0001\u0016\n\u0003\u0007I{w\u000fC\u0003W\u0011\u0001\u0007q+\u0001\u0003be\u001e\u001c\bCA\u000fY\u0013\tIFBA\u0007Qe>\u001cW\rZ;sK\u0006\u0013xm]\u0001\u0017O\u0016$xK]5uK\u000e{gNZ5h/&$\b\u000e\u0016:vKR\u0011Al\u0019\t\u0003;\u0006l\u0011A\u0018\u0006\u0003?\u0002\faaY8oM&<'BA\t\u0017\u0013\t\u0011gLA\tI_>$\u0017.Z,sSR,7i\u001c8gS\u001eDQ\u0001Z\u0005A\u0002\u0015\f\u0001\u0002^1cY\u0016|\u0005\u000f\u001e\t\u0004_\u0019D\u0017BA41\u0005\u0019y\u0005\u000f^5p]B\u0011q&[\u0005\u0003UB\u00121!\u00118z\u0003\u0015\u0011W/\u001b7e+\u0005Y\u0003")
public class UpgradeOrDowngradeProcedure
extends BaseProcedure
implements ProcedureBuilder,
Logging {
    private final ProcedureParameter[] PARAMETERS;
    private final StructType OUTPUT_TYPE;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ProcedureParameter[] PARAMETERS() {
        return this.PARAMETERS;
    }

    private StructType OUTPUT_TYPE() {
        return this.OUTPUT_TYPE;
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.PARAMETERS();
    }

    @Override
    public StructType outputType() {
        return this.OUTPUT_TYPE();
    }

    @Override
    public Seq<Row> call(ProcedureArgs args2) {
        boolean bl;
        super.checkArgs(this.PARAMETERS(), args2);
        Option<Object> tableName = this.getArgValueOrDefault(args2, this.PARAMETERS()[0]);
        String toVersion = (String)this.getArgValueOrDefault(args2, this.PARAMETERS()[1]).get();
        HoodieWriteConfig config = this.getWriteConfigWithTrue(tableName);
        String basePath = config.getBasePath();
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(HadoopFSUtils.getStorageConfWithCopy(this.jsc().hadoopConfiguration())).setBasePath(config.getBasePath()).setLoadActiveTimelineOnLoad(false).setConsistencyGuardConfig(config.getConsistencyGuardConfig()).setLayoutVersion(org.apache.hudi.common.util.Option.of(new TimelineLayoutVersion(config.getTimelineLayoutVersion()))).setFileSystemRetryConfig(config.getFileSystemRetryConfig()).build();
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new UpgradeDowngrade(metaClient, config, new HoodieSparkEngineContext(this.jsc()), SparkUpgradeDowngradeHelper.getInstance()).run(HoodieTableVersion.valueOf(toVersion), null));
        if (try_ instanceof Success) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Table at ").append(basePath).append(" upgraded / downgraded to version ").append(toVersion).append(".").toString());
            bl = true;
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("Failed: Could not upgrade/downgrade table at ").append(basePath).append(" to version ").append(toVersion).append(".").toString(), e);
            bl = false;
        } else {
            throw new MatchError((Object)try_);
        }
        boolean result = bl;
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)result)}))}));
    }

    private HoodieWriteConfig getWriteConfigWithTrue(Option<Object> tableOpt) {
        String basePath = this.getBasePath(tableOpt, this.getBasePath$default$2());
        Tuple2<String, Option<String>> tuple2 = HoodieCLIUtils$.MODULE$.getTableIdentifier((String)tableOpt.get());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String tableName = (String)tuple2._1();
        Option database = (Option)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)tableName, (Object)database);
        Tuple2 tuple23 = tuple22;
        String tableName2 = (String)tuple23._1();
        Option database2 = (Option)tuple23._2();
        return HoodieWriteConfig.newBuilder().forTable(tableName2).withPath(basePath).withRollbackUsingMarkers(true).withCleanConfig(HoodieCleanConfig.newBuilder().withFailedWritesCleaningPolicy(HoodieFailedWritesCleaningPolicy.EAGER).build()).withIndexConfig(HoodieIndexConfig.newBuilder().withIndexType(HoodieIndex.IndexType.BLOOM).build()).withProps((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieTableConfig.DATABASE_NAME.key()), database2.getOrElse((Function0 & Serializable & scala.Serializable)() -> this.sparkSession().sessionState().catalog().getCurrentDatabase()))}))).asJava()).build();
    }

    @Override
    public UpgradeOrDowngradeProcedure build() {
        return new UpgradeOrDowngradeProcedure();
    }

    public UpgradeOrDowngradeProcedure() {
        Logging.$init$((Logging)this);
        this.PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "table", DataTypes.StringType), ProcedureParameter$.MODULE$.required(1, "to_version", DataTypes.StringType)});
        this.OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("result", DataTypes.BooleanType, true, Metadata$.MODULE$.empty())}));
    }
}

