/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.avro;

import java.util.TimeZone;
import org.apache.spark.sql.avro.AvroDeserializer;
import org.apache.spark.sql.catalyst.util.RebaseDateTime$;
import org.apache.spark.sql.execution.datasources.DataSourceUtils$;
import org.apache.spark.sql.internal.SQLConf;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class AvroDeserializer$ {
    public static AvroDeserializer$ MODULE$;

    static {
        new AvroDeserializer$();
    }

    public Function1<Object, Object> createDateRebaseFuncInRead(Enumeration.Value rebaseMode, String format) {
        JFunction1.mcII.sp & java.io.Serializable & Serializable intersect;
        Enumeration.Value value = rebaseMode;
        Enumeration.Value value2 = SQLConf.LegacyBehaviorPolicy$.MODULE$.EXCEPTION();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            intersect = (JFunction1.mcII.sp & java.io.Serializable & Serializable)days -> {
                if (days < RebaseDateTime$.MODULE$.lastSwitchJulianDay()) {
                    throw DataSourceUtils$.MODULE$.newRebaseExceptionInRead(format);
                }
                return days;
            };
        } else {
            Enumeration.Value value4 = SQLConf.LegacyBehaviorPolicy$.MODULE$.LEGACY();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                intersect = (JFunction1.mcII.sp & java.io.Serializable & Serializable)days -> RebaseDateTime$.MODULE$.rebaseJulianToGregorianDays(days);
            } else {
                Enumeration.Value value6 = SQLConf.LegacyBehaviorPolicy$.MODULE$.CORRECTED();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    intersect = (JFunction1.mcII.sp & java.io.Serializable & Serializable)x -> BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToInteger((int)x)));
                } else {
                    throw new MatchError((Object)value);
                }
            }
        }
        return intersect;
    }

    public Function1<Object, Object> createTimestampRebaseFuncInRead(AvroDeserializer.RebaseSpec rebaseSpec, String format) {
        JFunction1.mcJJ.sp & java.io.Serializable & Serializable intersect;
        Enumeration.Value value = rebaseSpec.mode();
        Enumeration.Value value2 = SQLConf.LegacyBehaviorPolicy$.MODULE$.EXCEPTION();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            intersect = (JFunction1.mcJJ.sp & java.io.Serializable & Serializable)micros -> {
                if (micros < RebaseDateTime$.MODULE$.lastSwitchJulianTs()) {
                    throw DataSourceUtils$.MODULE$.newRebaseExceptionInRead(format);
                }
                return micros;
            };
        } else {
            Enumeration.Value value4 = SQLConf.LegacyBehaviorPolicy$.MODULE$.LEGACY();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                intersect = (JFunction1.mcJJ.sp & java.io.Serializable & Serializable)micros -> RebaseDateTime$.MODULE$.rebaseJulianToGregorianMicros(TimeZone.getTimeZone(rebaseSpec.timeZone()), micros);
            } else {
                Enumeration.Value value6 = SQLConf.LegacyBehaviorPolicy$.MODULE$.CORRECTED();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    intersect = (JFunction1.mcJJ.sp & java.io.Serializable & Serializable)x -> BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToLong((long)x)));
                } else {
                    throw new MatchError((Object)value);
                }
            }
        }
        return intersect;
    }

    private AvroDeserializer$() {
        MODULE$ = this;
    }
}

