/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.imps;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.curator.RetryLoop;
import org.apache.curator.TimeTrace;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.ACLCreateModeBackgroundPathAndBytesable;
import org.apache.curator.framework.api.ACLCreateModePathAndBytesable;
import org.apache.curator.framework.api.ACLPathAndBytesable;
import org.apache.curator.framework.api.BackgroundCallback;
import org.apache.curator.framework.api.BackgroundPathAndBytesable;
import org.apache.curator.framework.api.CreateBackgroundModeACLable;
import org.apache.curator.framework.api.CreateBuilder;
import org.apache.curator.framework.api.CuratorEvent;
import org.apache.curator.framework.api.CuratorEventType;
import org.apache.curator.framework.api.PathAndBytesable;
import org.apache.curator.framework.api.Pathable;
import org.apache.curator.framework.api.ProtectACLCreateModePathAndBytesable;
import org.apache.curator.framework.api.transaction.CuratorTransactionBridge;
import org.apache.curator.framework.api.transaction.OperationType;
import org.apache.curator.framework.api.transaction.TransactionCreateBuilder;
import org.apache.curator.framework.imps.ACLing;
import org.apache.curator.framework.imps.BackgroundOperation;
import org.apache.curator.framework.imps.Backgrounding;
import org.apache.curator.framework.imps.CuratorEventImpl;
import org.apache.curator.framework.imps.CuratorFrameworkImpl;
import org.apache.curator.framework.imps.CuratorFrameworkState;
import org.apache.curator.framework.imps.CuratorMultiTransactionRecord;
import org.apache.curator.framework.imps.CuratorTransactionImpl;
import org.apache.curator.framework.imps.OperationAndData;
import org.apache.curator.framework.imps.PathAndBytes;
import org.apache.curator.utils.ZKPaths;
import org.apache.hudi.com.google.common.annotations.VisibleForTesting;
import org.apache.hudi.com.google.common.base.Predicate;
import org.apache.hudi.com.google.common.collect.Iterables;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.data.ACL;

class CreateBuilderImpl
implements CreateBuilder,
BackgroundOperation<PathAndBytes> {
    private final CuratorFrameworkImpl client;
    private CreateMode createMode;
    private Backgrounding backgrounding;
    private boolean createParentsIfNeeded;
    private boolean doProtected;
    private boolean compress;
    private String protectedId;
    private ACLing acling;
    @VisibleForTesting
    boolean failNextCreateForTesting = false;
    @VisibleForTesting
    static final String PROTECTED_PREFIX = "_c_";

    CreateBuilderImpl(CuratorFrameworkImpl client) {
        this.client = client;
        this.createMode = CreateMode.PERSISTENT;
        this.backgrounding = new Backgrounding();
        this.acling = new ACLing(client.getAclProvider());
        this.createParentsIfNeeded = false;
        this.compress = false;
        this.doProtected = false;
        this.protectedId = null;
    }

    TransactionCreateBuilder asTransactionCreateBuilder(final CuratorTransactionImpl curatorTransaction, final CuratorMultiTransactionRecord transaction) {
        return new TransactionCreateBuilder(){

            @Override
            public PathAndBytesable<CuratorTransactionBridge> withACL(List<ACL> aclList) {
                CreateBuilderImpl.this.withACL((List)aclList);
                return this;
            }

            @Override
            public ACLPathAndBytesable<CuratorTransactionBridge> withMode(CreateMode mode) {
                CreateBuilderImpl.this.withMode(mode);
                return this;
            }

            @Override
            public ACLPathAndBytesable<CuratorTransactionBridge> compressed() {
                CreateBuilderImpl.this.compressed();
                return this;
            }

            @Override
            public CuratorTransactionBridge forPath(String path) throws Exception {
                return this.forPath(path, CreateBuilderImpl.this.client.getDefaultData());
            }

            @Override
            public CuratorTransactionBridge forPath(String path, byte[] data) throws Exception {
                if (CreateBuilderImpl.this.compress) {
                    data = CreateBuilderImpl.this.client.getCompressionProvider().compress(path, data);
                }
                String fixedPath = CreateBuilderImpl.this.client.fixForNamespace(path);
                transaction.add(Op.create((String)fixedPath, (byte[])data, CreateBuilderImpl.this.acling.getAclList(path), (CreateMode)CreateBuilderImpl.this.createMode), OperationType.CREATE, path);
                return curatorTransaction;
            }
        };
    }

    @Override
    public CreateBackgroundModeACLable compressed() {
        this.compress = true;
        return new CreateBackgroundModeACLable(){

            @Override
            public ACLCreateModePathAndBytesable<String> creatingParentsIfNeeded() {
                CreateBuilderImpl.this.createParentsIfNeeded = true;
                return CreateBuilderImpl.this.asACLCreateModePathAndBytesable();
            }

            @Override
            public ACLPathAndBytesable<String> withProtectedEphemeralSequential() {
                return CreateBuilderImpl.this.withProtectedEphemeralSequential();
            }

            @Override
            public BackgroundPathAndBytesable<String> withACL(List<ACL> aclList) {
                return CreateBuilderImpl.this.withACL((List)aclList);
            }

            @Override
            public PathAndBytesable<String> inBackground(BackgroundCallback callback, Object context) {
                return CreateBuilderImpl.this.inBackground(callback, context);
            }

            @Override
            public PathAndBytesable<String> inBackground(BackgroundCallback callback, Object context, Executor executor) {
                return CreateBuilderImpl.this.inBackground(callback, context, executor);
            }

            @Override
            public PathAndBytesable<String> inBackground() {
                return CreateBuilderImpl.this.inBackground();
            }

            @Override
            public PathAndBytesable<String> inBackground(Object context) {
                return CreateBuilderImpl.this.inBackground(context);
            }

            @Override
            public PathAndBytesable<String> inBackground(BackgroundCallback callback) {
                return CreateBuilderImpl.this.inBackground(callback);
            }

            @Override
            public PathAndBytesable<String> inBackground(BackgroundCallback callback, Executor executor) {
                return CreateBuilderImpl.this.inBackground(callback, executor);
            }

            @Override
            public ACLBackgroundPathAndBytesable<String> withMode(CreateMode mode) {
                return CreateBuilderImpl.this.withMode(mode);
            }

            @Override
            public String forPath(String path, byte[] data) throws Exception {
                return CreateBuilderImpl.this.forPath(path, data);
            }

            @Override
            public String forPath(String path) throws Exception {
                return CreateBuilderImpl.this.forPath(path);
            }
        };
    }

    @Override
    public ACLBackgroundPathAndBytesable<String> withACL(List<ACL> aclList) {
        this.acling = new ACLing(this.client.getAclProvider(), aclList);
        return new ACLBackgroundPathAndBytesable<String>(){

            @Override
            public BackgroundPathAndBytesable<String> withACL(List<ACL> aclList) {
                return CreateBuilderImpl.this.withACL((List)aclList);
            }

            @Override
            public PathAndBytesable<String> inBackground() {
                return CreateBuilderImpl.this.inBackground();
            }

            @Override
            public PathAndBytesable<String> inBackground(BackgroundCallback callback, Object context) {
                return CreateBuilderImpl.this.inBackground(callback, context);
            }

            @Override
            public PathAndBytesable<String> inBackground(BackgroundCallback callback, Object context, Executor executor) {
                return CreateBuilderImpl.this.inBackground(callback, context, executor);
            }

            @Override
            public PathAndBytesable<String> inBackground(Object context) {
                return CreateBuilderImpl.this.inBackground(context);
            }

            @Override
            public PathAndBytesable<String> inBackground(BackgroundCallback callback) {
                return CreateBuilderImpl.this.inBackground(callback);
            }

            @Override
            public PathAndBytesable<String> inBackground(BackgroundCallback callback, Executor executor) {
                return CreateBuilderImpl.this.inBackground(callback, executor);
            }

            @Override
            public String forPath(String path, byte[] data) throws Exception {
                return CreateBuilderImpl.this.forPath(path, data);
            }

            @Override
            public String forPath(String path) throws Exception {
                return CreateBuilderImpl.this.forPath(path);
            }
        };
    }

    @Override
    public ProtectACLCreateModePathAndBytesable<String> creatingParentsIfNeeded() {
        this.createParentsIfNeeded = true;
        return new ProtectACLCreateModePathAndBytesable<String>(){

            @Override
            public ACLCreateModeBackgroundPathAndBytesable<String> withProtection() {
                return CreateBuilderImpl.this.withProtection();
            }

            @Override
            public BackgroundPathAndBytesable<String> withACL(List<ACL> aclList) {
                return CreateBuilderImpl.this.withACL((List)aclList);
            }

            @Override
            public PathAndBytesable<String> inBackground() {
                return CreateBuilderImpl.this.inBackground();
            }

            @Override
            public PathAndBytesable<String> inBackground(Object context) {
                return CreateBuilderImpl.this.inBackground(context);
            }

            @Override
            public PathAndBytesable<String> inBackground(BackgroundCallback callback) {
                return CreateBuilderImpl.this.inBackground(callback);
            }

            @Override
            public PathAndBytesable<String> inBackground(BackgroundCallback callback, Object context) {
                return CreateBuilderImpl.this.inBackground(callback, context);
            }

            @Override
            public PathAndBytesable<String> inBackground(BackgroundCallback callback, Executor executor) {
                return CreateBuilderImpl.this.inBackground(callback, executor);
            }

            @Override
            public PathAndBytesable<String> inBackground(BackgroundCallback callback, Object context, Executor executor) {
                return CreateBuilderImpl.this.inBackground(callback, context, executor);
            }

            @Override
            public ACLBackgroundPathAndBytesable<String> withMode(CreateMode mode) {
                return CreateBuilderImpl.this.withMode(mode);
            }

            @Override
            public String forPath(String path, byte[] data) throws Exception {
                return CreateBuilderImpl.this.forPath(path, data);
            }

            @Override
            public String forPath(String path) throws Exception {
                return CreateBuilderImpl.this.forPath(path);
            }
        };
    }

    @Override
    public ACLCreateModeBackgroundPathAndBytesable<String> withProtection() {
        this.setProtected();
        return this;
    }

    @Override
    public ACLPathAndBytesable<String> withProtectedEphemeralSequential() {
        this.setProtected();
        this.createMode = CreateMode.EPHEMERAL_SEQUENTIAL;
        return new ACLPathAndBytesable<String>(){

            @Override
            public PathAndBytesable<String> withACL(List<ACL> aclList) {
                return CreateBuilderImpl.this.withACL((List)aclList);
            }

            @Override
            public String forPath(String path, byte[] data) throws Exception {
                return CreateBuilderImpl.this.forPath(path, data);
            }

            @Override
            public String forPath(String path) throws Exception {
                return CreateBuilderImpl.this.forPath(path);
            }
        };
    }

    @Override
    public ACLBackgroundPathAndBytesable<String> withMode(CreateMode mode) {
        this.createMode = mode;
        return this;
    }

    @Override
    public PathAndBytesable<String> inBackground(BackgroundCallback callback, Object context) {
        this.backgrounding = new Backgrounding(callback, context);
        return this;
    }

    @Override
    public PathAndBytesable<String> inBackground(BackgroundCallback callback, Object context, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, callback, context, executor);
        return this;
    }

    @Override
    public PathAndBytesable<String> inBackground(BackgroundCallback callback) {
        this.backgrounding = new Backgrounding(callback);
        return this;
    }

    @Override
    public PathAndBytesable<String> inBackground(BackgroundCallback callback, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, callback, executor);
        return this;
    }

    @Override
    public PathAndBytesable<String> inBackground() {
        this.backgrounding = new Backgrounding(true);
        return this;
    }

    @Override
    public PathAndBytesable<String> inBackground(Object context) {
        this.backgrounding = new Backgrounding(context);
        return this;
    }

    @Override
    public String forPath(String path) throws Exception {
        return this.forPath(path, this.client.getDefaultData());
    }

    @Override
    public String forPath(String givenPath, byte[] data) throws Exception {
        if (this.compress) {
            data = this.client.getCompressionProvider().compress(givenPath, data);
        }
        String adjustedPath = this.adjustPath(this.client.fixForNamespace(givenPath, this.createMode.isSequential()));
        String returnPath = null;
        if (this.backgrounding.inBackground()) {
            this.pathInBackground(adjustedPath, data, givenPath);
        } else {
            String path = this.protectedPathInForeground(adjustedPath, data);
            returnPath = this.client.unfixForNamespace(path);
        }
        return returnPath;
    }

    private String protectedPathInForeground(String adjustedPath, byte[] data) throws Exception {
        try {
            return this.pathInForeground(adjustedPath, data);
        }
        catch (Exception e) {
            if ((e instanceof KeeperException.ConnectionLossException || !(e instanceof KeeperException)) && this.protectedId != null) {
                String localProtectedId = this.protectedId;
                this.findAndDeleteProtectedNodeInBackground(adjustedPath, localProtectedId, null);
                this.protectedId = UUID.randomUUID().toString();
            }
            throw e;
        }
    }

    @Override
    public void performBackgroundOperation(final OperationAndData<PathAndBytes> operationAndData) throws Exception {
        final TimeTrace trace = this.client.getZookeeperClient().startTracer("CreateBuilderImpl-Background");
        this.client.getZooKeeper().create(operationAndData.getData().getPath(), operationAndData.getData().getData(), this.acling.getAclList(operationAndData.getData().getPath()), this.createMode, new AsyncCallback.StringCallback(){

            public void processResult(int rc, String path, Object ctx, String name) {
                trace.commit();
                if (rc == KeeperException.Code.NONODE.intValue() && CreateBuilderImpl.this.createParentsIfNeeded) {
                    CreateBuilderImpl.this.backgroundCreateParentsThenNode(operationAndData);
                } else {
                    CreateBuilderImpl.this.sendBackgroundResponse(rc, path, ctx, name, operationAndData);
                }
            }
        }, this.backgrounding.getContext());
    }

    private static String getProtectedPrefix(String protectedId) {
        return PROTECTED_PREFIX + protectedId + "-";
    }

    private void backgroundCreateParentsThenNode(final OperationAndData<PathAndBytes> mainOperationAndData) {
        BackgroundOperation<PathAndBytes> operation = new BackgroundOperation<PathAndBytes>(){

            @Override
            public void performBackgroundOperation(OperationAndData<PathAndBytes> dummy) throws Exception {
                try {
                    ZKPaths.mkdirs(CreateBuilderImpl.this.client.getZooKeeper(), ((PathAndBytes)mainOperationAndData.getData()).getPath(), false, CreateBuilderImpl.this.client.getAclProvider());
                }
                catch (KeeperException keeperException) {
                    // empty catch block
                }
                CreateBuilderImpl.this.client.queueOperation(mainOperationAndData);
            }
        };
        OperationAndData<PathAndBytes> parentOperation = new OperationAndData<PathAndBytes>(operation, mainOperationAndData.getData(), null, null, this.backgrounding.getContext());
        this.client.queueOperation(parentOperation);
    }

    private void sendBackgroundResponse(int rc, String path, Object ctx, String name, OperationAndData<PathAndBytes> operationAndData) {
        path = this.client.unfixForNamespace(path);
        name = this.client.unfixForNamespace(name);
        CuratorEventImpl event = new CuratorEventImpl(this.client, CuratorEventType.CREATE, rc, path, name, ctx, null, null, null, null, null);
        this.client.processBackgroundOperation(operationAndData, event);
    }

    private void setProtected() {
        this.doProtected = true;
        this.protectedId = UUID.randomUUID().toString();
    }

    private ACLCreateModePathAndBytesable<String> asACLCreateModePathAndBytesable() {
        return new ACLCreateModePathAndBytesable<String>(){

            @Override
            public PathAndBytesable<String> withACL(List<ACL> aclList) {
                return CreateBuilderImpl.this.withACL((List)aclList);
            }

            @Override
            public ACLPathAndBytesable<String> withMode(CreateMode mode) {
                CreateBuilderImpl.this.createMode = mode;
                return new ACLPathAndBytesable<String>(){

                    @Override
                    public PathAndBytesable<String> withACL(List<ACL> aclList) {
                        return CreateBuilderImpl.this.withACL((List)aclList);
                    }

                    @Override
                    public String forPath(String path, byte[] data) throws Exception {
                        return CreateBuilderImpl.this.forPath(path, data);
                    }

                    @Override
                    public String forPath(String path) throws Exception {
                        return CreateBuilderImpl.this.forPath(path);
                    }
                };
            }

            @Override
            public String forPath(String path, byte[] data) throws Exception {
                return CreateBuilderImpl.this.forPath(path, data);
            }

            @Override
            public String forPath(String path) throws Exception {
                return CreateBuilderImpl.this.forPath(path);
            }
        };
    }

    private void pathInBackground(final String path, final byte[] data, final String givenPath) {
        final AtomicBoolean firstTime = new AtomicBoolean(true);
        OperationAndData<PathAndBytes> operationAndData = new OperationAndData<PathAndBytes>((BackgroundOperation)this, new PathAndBytes(path, data), this.backgrounding.getCallback(), (OperationAndData.ErrorCallback)new OperationAndData.ErrorCallback<PathAndBytes>(){

            @Override
            public void retriesExhausted(OperationAndData<PathAndBytes> operationAndData) {
                if (CreateBuilderImpl.this.doProtected) {
                    CreateBuilderImpl.this.findAndDeleteProtectedNodeInBackground(path, CreateBuilderImpl.this.protectedId, null);
                    CreateBuilderImpl.this.protectedId = UUID.randomUUID().toString();
                }
            }
        }, this.backgrounding.getContext()){

            @Override
            void callPerformBackgroundOperation() throws Exception {
                boolean callSuper = true;
                boolean localFirstTime = firstTime.getAndSet(false);
                if (!localFirstTime && CreateBuilderImpl.this.doProtected) {
                    String createdPath = null;
                    try {
                        createdPath = CreateBuilderImpl.this.findProtectedNodeInForeground(path);
                    }
                    catch (KeeperException.ConnectionLossException e) {
                        CreateBuilderImpl.this.sendBackgroundResponse(KeeperException.Code.CONNECTIONLOSS.intValue(), path, CreateBuilderImpl.this.backgrounding.getContext(), null, this);
                        callSuper = false;
                    }
                    if (createdPath != null) {
                        try {
                            CreateBuilderImpl.this.sendBackgroundResponse(KeeperException.Code.OK.intValue(), createdPath, CreateBuilderImpl.this.backgrounding.getContext(), ZKPaths.getNodeFromPath(createdPath), this);
                        }
                        catch (Exception e) {
                            CreateBuilderImpl.this.client.logError("Processing protected create for path: " + givenPath, e);
                        }
                        callSuper = false;
                    }
                }
                if (CreateBuilderImpl.this.failNextCreateForTesting) {
                    CreateBuilderImpl.this.pathInForeground(path, data);
                    CreateBuilderImpl.this.failNextCreateForTesting = false;
                    throw new KeeperException.ConnectionLossException();
                }
                if (callSuper) {
                    super.callPerformBackgroundOperation();
                }
            }
        };
        this.client.processBackgroundOperation(operationAndData, null);
    }

    private String pathInForeground(final String path, final byte[] data) throws Exception {
        TimeTrace trace = this.client.getZookeeperClient().startTracer("CreateBuilderImpl-Foreground");
        final AtomicBoolean firstTime = new AtomicBoolean(true);
        String returnPath = RetryLoop.callWithRetry(this.client.getZookeeperClient(), new Callable<String>(){

            @Override
            public String call() throws Exception {
                boolean localFirstTime = firstTime.getAndSet(false);
                String createdPath = null;
                if (!localFirstTime && CreateBuilderImpl.this.doProtected) {
                    createdPath = CreateBuilderImpl.this.findProtectedNodeInForeground(path);
                }
                if (createdPath == null) {
                    try {
                        createdPath = CreateBuilderImpl.this.client.getZooKeeper().create(path, data, CreateBuilderImpl.this.acling.getAclList(path), CreateBuilderImpl.this.createMode);
                    }
                    catch (KeeperException.NoNodeException e) {
                        if (CreateBuilderImpl.this.createParentsIfNeeded) {
                            ZKPaths.mkdirs(CreateBuilderImpl.this.client.getZooKeeper(), path, false, CreateBuilderImpl.this.client.getAclProvider());
                            createdPath = CreateBuilderImpl.this.client.getZooKeeper().create(path, data, CreateBuilderImpl.this.acling.getAclList(path), CreateBuilderImpl.this.createMode);
                        }
                        throw e;
                    }
                }
                if (CreateBuilderImpl.this.failNextCreateForTesting) {
                    CreateBuilderImpl.this.failNextCreateForTesting = false;
                    throw new KeeperException.ConnectionLossException();
                }
                return createdPath;
            }
        });
        trace.commit();
        return returnPath;
    }

    private String findProtectedNodeInForeground(final String path) throws Exception {
        TimeTrace trace = this.client.getZookeeperClient().startTracer("CreateBuilderImpl-findProtectedNodeInForeground");
        String returnPath = RetryLoop.callWithRetry(this.client.getZookeeperClient(), new Callable<String>(){

            @Override
            public String call() throws Exception {
                String foundNode = null;
                try {
                    ZKPaths.PathAndNode pathAndNode = ZKPaths.getPathAndNode(path);
                    List children = CreateBuilderImpl.this.client.getZooKeeper().getChildren(pathAndNode.getPath(), false);
                    foundNode = CreateBuilderImpl.findNode(children, pathAndNode.getPath(), CreateBuilderImpl.this.protectedId);
                }
                catch (KeeperException.NoNodeException noNodeException) {
                    // empty catch block
                }
                return foundNode;
            }
        });
        trace.commit();
        return returnPath;
    }

    private String adjustPath(String path) throws Exception {
        if (this.doProtected) {
            ZKPaths.PathAndNode pathAndNode = ZKPaths.getPathAndNode(path);
            String name = CreateBuilderImpl.getProtectedPrefix(this.protectedId) + pathAndNode.getNode();
            path = ZKPaths.makePath(pathAndNode.getPath(), name);
        }
        return path;
    }

    private void findAndDeleteProtectedNodeInBackground(String path, String protectedId, FindProtectedNodeCB callback) {
        if (this.client.getState() == CuratorFrameworkState.STARTED) {
            if (callback == null) {
                callback = new FindProtectedNodeCB(path, protectedId);
            }
            try {
                ((Pathable)this.client.getChildren().inBackground(callback)).forPath(ZKPaths.getPathAndNode(path).getPath());
            }
            catch (Exception e) {
                this.findAndDeleteProtectedNodeInBackground(path, protectedId, callback);
            }
        }
    }

    private static String findNode(List<String> children, String path, String protectedId) {
        final String protectedPrefix = CreateBuilderImpl.getProtectedPrefix(protectedId);
        String foundNode = (String)Iterables.find(children, (Predicate)new Predicate<String>(){

            public boolean apply(String node) {
                return node.startsWith(protectedPrefix);
            }
        }, null);
        if (foundNode != null) {
            foundNode = ZKPaths.makePath(path, foundNode);
        }
        return foundNode;
    }

    private class FindProtectedNodeCB
    implements BackgroundCallback {
        final String path;
        final String protectedId;

        private FindProtectedNodeCB(String path, String protectedId) {
            this.path = path;
            this.protectedId = protectedId;
        }

        @Override
        public void processResult(CuratorFramework client, CuratorEvent event) throws Exception {
            if (event.getResultCode() == KeeperException.Code.OK.intValue()) {
                String node = CreateBuilderImpl.findNode(event.getChildren(), ZKPaths.getPathAndNode(this.path).getPath(), this.protectedId);
                if (node != null) {
                    ((Pathable)client.delete().guaranteed().inBackground()).forPath(node);
                }
            } else if (event.getResultCode() == KeeperException.Code.CONNECTIONLOSS.intValue()) {
                CreateBuilderImpl.this.findAndDeleteProtectedNodeInBackground(this.path, this.protectedId, this);
            }
        }
    }
}

