/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.avro.model;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;
import org.apache.hudi.avro.model.HoodieCompactionOperation;

@AvroGenerated
public class HoodieCompactionPlan
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = -4303349821552047105L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"HoodieCompactionPlan\",\"namespace\":\"org.apache.hudi.avro.model\",\"fields\":[{\"name\":\"operations\",\"type\":[\"null\",{\"type\":\"array\",\"items\":{\"type\":\"record\",\"name\":\"HoodieCompactionOperation\",\"fields\":[{\"name\":\"baseInstantTime\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}]},{\"name\":\"deltaFilePaths\",\"type\":[\"null\",{\"type\":\"array\",\"items\":{\"type\":\"string\",\"avro.java.string\":\"String\"}}],\"default\":null},{\"name\":\"dataFilePath\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"fileId\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}]},{\"name\":\"partitionPath\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"metrics\",\"type\":[\"null\",{\"type\":\"map\",\"values\":\"double\",\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"bootstrapFilePath\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null}]}}],\"default\":null},{\"name\":\"extraMetadata\",\"type\":[\"null\",{\"type\":\"map\",\"values\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"version\",\"type\":[\"int\",\"null\"],\"default\":1}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<HoodieCompactionPlan> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<HoodieCompactionPlan> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    private List<HoodieCompactionOperation> operations;
    private Map<String, String> extraMetadata;
    private Integer version;
    private static final DatumWriter<HoodieCompactionPlan> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<HoodieCompactionPlan> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<HoodieCompactionPlan> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<HoodieCompactionPlan> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<HoodieCompactionPlan> createDecoder(SchemaStore resolver2) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver2);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static HoodieCompactionPlan fromByteBuffer(ByteBuffer b) throws IOException {
        return (HoodieCompactionPlan)((Object)DECODER.decode(b));
    }

    public HoodieCompactionPlan() {
    }

    public HoodieCompactionPlan(List<HoodieCompactionOperation> operations, Map<String, String> extraMetadata, Integer version) {
        this.operations = operations;
        this.extraMetadata = extraMetadata;
        this.version = version;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.operations;
            }
            case 1: {
                return this.extraMetadata;
            }
            case 2: {
                return this.version;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.operations = (List)value$;
                break;
            }
            case 1: {
                this.extraMetadata = (Map)value$;
                break;
            }
            case 2: {
                this.version = (Integer)value$;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public List<HoodieCompactionOperation> getOperations() {
        return this.operations;
    }

    public void setOperations(List<HoodieCompactionOperation> value) {
        this.operations = value;
    }

    public Map<String, String> getExtraMetadata() {
        return this.extraMetadata;
    }

    public void setExtraMetadata(Map<String, String> value) {
        this.extraMetadata = value;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer value) {
        this.version = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(HoodieCompactionPlan other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        if (this.operations == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            long size0 = this.operations.size();
            out.writeArrayStart();
            out.setItemCount(size0);
            long actualSize0 = 0L;
            for (HoodieCompactionOperation hoodieCompactionOperation : this.operations) {
                ++actualSize0;
                out.startItem();
                hoodieCompactionOperation.customEncode(out);
            }
            out.writeArrayEnd();
            if (actualSize0 != size0) {
                throw new ConcurrentModificationException("Array-size written was " + size0 + ", but element count was " + actualSize0 + ".");
            }
        }
        if (this.extraMetadata == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            long size1 = this.extraMetadata.size();
            out.writeMapStart();
            out.setItemCount(size1);
            long actualSize1 = 0L;
            for (Map.Entry entry : this.extraMetadata.entrySet()) {
                ++actualSize1;
                out.startItem();
                out.writeString((String)entry.getKey());
                String v1 = (String)entry.getValue();
                out.writeString(v1);
            }
            out.writeMapEnd();
            if (actualSize1 != size1) {
                throw new ConcurrentModificationException("Map-size written was " + size1 + ", but element count was " + actualSize1 + ".");
            }
        }
        if (this.version == null) {
            out.writeIndex(1);
            out.writeNull();
        } else {
            out.writeIndex(0);
            out.writeInt(this.version.intValue());
        }
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            if (in.readIndex() != 1) {
                in.readNull();
                this.operations = null;
            } else {
                GenericData.Array ga0;
                long size0 = in.readArrayStart();
                GenericData.Array a0 = this.operations;
                if (a0 == null) {
                    this.operations = a0 = new GenericData.Array((int)size0, (Schema)SCHEMA$.getField("operations").schema().getTypes().get(1));
                } else {
                    a0.clear();
                }
                GenericData.Array array = ga0 = a0 instanceof GenericData.Array ? (GenericData.Array)a0 : null;
                while (0L < size0) {
                    while (size0 != 0L) {
                        HoodieCompactionOperation e0;
                        HoodieCompactionOperation hoodieCompactionOperation = e0 = ga0 != null ? (HoodieCompactionOperation)((Object)ga0.peek()) : null;
                        if (e0 == null) {
                            e0 = new HoodieCompactionOperation();
                        }
                        e0.customDecode(in);
                        a0.add(e0);
                        --size0;
                    }
                    size0 = in.arrayNext();
                }
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.extraMetadata = null;
            } else {
                long size1 = in.readMapStart();
                Map<String, String> m1 = this.extraMetadata;
                if (m1 == null) {
                    this.extraMetadata = m1 = new HashMap<String, String>((int)size1);
                } else {
                    m1.clear();
                }
                while (0L < size1) {
                    while (size1 != 0L) {
                        String k1 = null;
                        k1 = in.readString();
                        String v1 = null;
                        v1 = in.readString();
                        m1.put(k1, v1);
                        --size1;
                    }
                    size1 = in.mapNext();
                }
            }
            if (in.readIndex() != 0) {
                in.readNull();
                this.version = null;
            } else {
                this.version = in.readInt();
            }
        } else {
            block9: for (int i = 0; i < 3; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        GenericData.Array ga0;
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.operations = null;
                            continue block9;
                        }
                        long size0 = in.readArrayStart();
                        GenericData.Array a0 = this.operations;
                        if (a0 == null) {
                            this.operations = a0 = new GenericData.Array((int)size0, (Schema)SCHEMA$.getField("operations").schema().getTypes().get(1));
                        } else {
                            a0.clear();
                        }
                        GenericData.Array array = ga0 = a0 instanceof GenericData.Array ? (GenericData.Array)a0 : null;
                        while (0L < size0) {
                            while (size0 != 0L) {
                                HoodieCompactionOperation e0;
                                HoodieCompactionOperation hoodieCompactionOperation = e0 = ga0 != null ? (HoodieCompactionOperation)((Object)ga0.peek()) : null;
                                if (e0 == null) {
                                    e0 = new HoodieCompactionOperation();
                                }
                                e0.customDecode(in);
                                a0.add(e0);
                                --size0;
                            }
                            size0 = in.arrayNext();
                        }
                        continue block9;
                    }
                    case 1: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.extraMetadata = null;
                            continue block9;
                        }
                        long size1 = in.readMapStart();
                        Map<String, String> m1 = this.extraMetadata;
                        if (m1 == null) {
                            this.extraMetadata = m1 = new HashMap<String, String>((int)size1);
                        } else {
                            m1.clear();
                        }
                        while (0L < size1) {
                            while (size1 != 0L) {
                                String k1 = null;
                                k1 = in.readString();
                                String v1 = null;
                                v1 = in.readString();
                                m1.put(k1, v1);
                                --size1;
                            }
                            size1 = in.mapNext();
                        }
                        continue block9;
                    }
                    case 2: {
                        if (in.readIndex() != 0) {
                            in.readNull();
                            this.version = null;
                            continue block9;
                        }
                        this.version = in.readInt();
                        continue block9;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<HoodieCompactionPlan>
    implements RecordBuilder<HoodieCompactionPlan> {
        private List<HoodieCompactionOperation> operations;
        private Map<String, String> extraMetadata;
        private Integer version;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], other.operations)) {
                this.operations = (List)this.data().deepCopy(this.fields()[0].schema(), other.operations);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], other.extraMetadata)) {
                this.extraMetadata = (Map)this.data().deepCopy(this.fields()[1].schema(), other.extraMetadata);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.version)) {
                this.version = (Integer)this.data().deepCopy(this.fields()[2].schema(), (Object)other.version);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
        }

        private Builder(HoodieCompactionPlan other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.operations)) {
                this.operations = (List)this.data().deepCopy(this.fields()[0].schema(), (Object)other.operations);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.extraMetadata)) {
                this.extraMetadata = (Map)this.data().deepCopy(this.fields()[1].schema(), (Object)other.extraMetadata);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.version)) {
                this.version = (Integer)this.data().deepCopy(this.fields()[2].schema(), (Object)other.version);
                this.fieldSetFlags()[2] = true;
            }
        }

        public List<HoodieCompactionOperation> getOperations() {
            return this.operations;
        }

        public Builder setOperations(List<HoodieCompactionOperation> value) {
            this.validate(this.fields()[0], value);
            this.operations = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasOperations() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearOperations() {
            this.operations = null;
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public Map<String, String> getExtraMetadata() {
            return this.extraMetadata;
        }

        public Builder setExtraMetadata(Map<String, String> value) {
            this.validate(this.fields()[1], value);
            this.extraMetadata = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasExtraMetadata() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearExtraMetadata() {
            this.extraMetadata = null;
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public Integer getVersion() {
            return this.version;
        }

        public Builder setVersion(Integer value) {
            this.validate(this.fields()[2], value);
            this.version = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasVersion() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearVersion() {
            this.version = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public HoodieCompactionPlan build() {
            try {
                HoodieCompactionPlan record = new HoodieCompactionPlan();
                record.operations = this.fieldSetFlags()[0] ? this.operations : (List)this.defaultValue(this.fields()[0]);
                record.extraMetadata = this.fieldSetFlags()[1] ? this.extraMetadata : (Map)this.defaultValue(this.fields()[1]);
                record.version = this.fieldSetFlags()[2] ? this.version : (Integer)this.defaultValue(this.fields()[2]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

