/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.regionserver.handler;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import org.apache.hudi.org.apache.hadoop.hbase.Cell;
import org.apache.hudi.org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hudi.org.apache.hadoop.hbase.executor.EventType;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ParallelSeekHandler
extends EventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ParallelSeekHandler.class);
    private KeyValueScanner scanner;
    private Cell keyValue;
    private long readPoint;
    private CountDownLatch latch;
    private Throwable err = null;

    public ParallelSeekHandler(KeyValueScanner scanner, Cell keyValue, long readPoint, CountDownLatch latch) {
        super(null, EventType.RS_PARALLEL_SEEK);
        this.scanner = scanner;
        this.keyValue = keyValue;
        this.readPoint = readPoint;
        this.latch = latch;
    }

    @Override
    public void process() {
        try {
            this.scanner.seek(this.keyValue);
        }
        catch (IOException e) {
            LOG.error("", (Throwable)e);
            this.setErr(e);
        }
        finally {
            this.latch.countDown();
        }
    }

    public Throwable getErr() {
        return this.err;
    }

    public void setErr(Throwable err) {
        this.err = err;
    }
}

