/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index.bloom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.index.bloom.BloomIndexFileInfo;
import org.apache.hudi.index.bloom.IndexFileFilter;
import org.apache.hudi.index.bloom.KeyRangeLookupTree;
import org.apache.hudi.index.bloom.KeyRangeNode;

class IntervalTreeBasedGlobalIndexFileFilter
implements IndexFileFilter {
    private final KeyRangeLookupTree indexLookUpTree = new KeyRangeLookupTree();
    private final Set<String> filesWithNoRanges = new HashSet<String>();
    private final Map<String, String> fileIdToPartitionPathMap = new HashMap<String, String>();

    IntervalTreeBasedGlobalIndexFileFilter(Map<String, List<BloomIndexFileInfo>> partitionToFileIndexInfo) {
        ArrayList allIndexFiles = new ArrayList();
        partitionToFileIndexInfo.forEach((partition, bloomIndexFileInfoList) -> bloomIndexFileInfoList.forEach(file -> {
            this.fileIdToPartitionPathMap.put(file.getFileId(), (String)partition);
            allIndexFiles.add(file);
        }));
        Collections.shuffle(allIndexFiles);
        allIndexFiles.forEach(indexFile -> {
            if (indexFile.hasKeyRanges()) {
                this.indexLookUpTree.insert(new KeyRangeNode(indexFile.getMinRecordKey(), indexFile.getMaxRecordKey(), indexFile.getFileId()));
            } else {
                this.filesWithNoRanges.add(indexFile.getFileId());
            }
        });
    }

    @Override
    public Set<Pair<String, String>> getMatchingFilesAndPartition(String partitionPath, String recordKey) {
        HashSet<String> matchingFiles = new HashSet<String>();
        matchingFiles.addAll(this.indexLookUpTree.getMatchingIndexFiles(recordKey));
        matchingFiles.addAll(this.filesWithNoRanges);
        HashSet<Pair<String, String>> toReturn = new HashSet<Pair<String, String>>();
        matchingFiles.forEach(file -> toReturn.add(Pair.of(this.fileIdToPartitionPathMap.get(file), file)));
        return toReturn;
    }
}

