/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.hadoop;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.model.HoodieAvroIndexedRecord;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.FileFormatUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ParquetReaderIterator;
import org.apache.hudi.common.util.TypeUtils;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.common.util.collection.CloseableMappingIterator;
import org.apache.hudi.io.storage.HoodieAvroFileReader;
import org.apache.hudi.io.storage.HoodieIOFactory;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.parquet.avro.AvroReadSupport;
import org.apache.parquet.avro.HoodieAvroParquetReaderBuilder;
import org.apache.parquet.hadoop.ParquetReader;

public class HoodieAvroParquetReader
extends HoodieAvroFileReader {
    private final StoragePath path;
    private final HoodieStorage storage;
    private final FileFormatUtils parquetUtils;
    private final List<ParquetReaderIterator> readerIterators = new ArrayList<ParquetReaderIterator>();

    public HoodieAvroParquetReader(HoodieStorage storage, StoragePath path) {
        this.storage = storage.newInstance(path, HoodieAvroParquetReader.tryOverrideDefaultConfigs(storage.getConf().newInstance()));
        this.path = path;
        this.parquetUtils = HoodieIOFactory.getIOFactory(storage).getFileFormatUtils(HoodieFileFormat.PARQUET);
    }

    @Override
    public ClosableIterator<HoodieRecord<IndexedRecord>> getRecordIterator(Schema readerSchema) throws IOException {
        ClosableIterator<IndexedRecord> iterator2 = this.getIndexedRecordIterator(readerSchema);
        return new CloseableMappingIterator<IndexedRecord, HoodieRecord>(iterator2, data -> (HoodieRecord)TypeUtils.unsafeCast(new HoodieAvroIndexedRecord((IndexedRecord)data)));
    }

    @Override
    public String[] readMinMaxRecordKeys() {
        return this.parquetUtils.readMinMaxRecordKeys(this.storage, this.path);
    }

    @Override
    public BloomFilter readBloomFilter() {
        return this.parquetUtils.readBloomFilterFromMetadata(this.storage, this.path);
    }

    @Override
    public Set<String> filterRowKeys(Set<String> candidateRowKeys) {
        return this.parquetUtils.filterRowKeys(this.storage, this.path, candidateRowKeys);
    }

    @Override
    protected ClosableIterator<IndexedRecord> getIndexedRecordIterator(Schema schema) throws IOException {
        return this.getIndexedRecordIteratorInternal(schema, Option.empty());
    }

    @Override
    public ClosableIterator<IndexedRecord> getIndexedRecordIterator(Schema readerSchema, Schema requestedSchema) throws IOException {
        return this.getIndexedRecordIteratorInternal(readerSchema, Option.of(requestedSchema));
    }

    @Override
    public Schema getSchema() {
        return this.parquetUtils.readAvroSchema(this.storage, this.path);
    }

    @Override
    public void close() {
        this.readerIterators.forEach(ParquetReaderIterator::close);
    }

    @Override
    public long getTotalRecords() {
        return this.parquetUtils.getRowCount(this.storage, this.path);
    }

    private static StorageConfiguration<?> tryOverrideDefaultConfigs(StorageConfiguration<?> conf) {
        if (conf.getString("parquet.avro.add-list-element-records").isEmpty()) {
            conf.set("parquet.avro.add-list-element-records", "false");
        }
        if (conf.getString("parquet.strict.typing").isEmpty()) {
            conf.set("parquet.strict.typing", "false");
        }
        return conf;
    }

    private ClosableIterator<IndexedRecord> getIndexedRecordIteratorInternal(Schema schema, Option<Schema> requestedSchema) throws IOException {
        Configuration hadoopConf = this.storage.getConf().unwrapAs(Configuration.class);
        if (!requestedSchema.isPresent()) {
            AvroReadSupport.setAvroReadSchema(hadoopConf, schema);
            AvroReadSupport.setRequestedProjection(hadoopConf, schema);
        } else {
            AvroReadSupport.setAvroReadSchema(hadoopConf, requestedSchema.get());
            AvroReadSupport.setRequestedProjection(hadoopConf, requestedSchema.get());
        }
        ParquetReader reader = new HoodieAvroParquetReaderBuilder(this.path).withConf(hadoopConf).build();
        ParquetReaderIterator<IndexedRecord> parquetReaderIterator = new ParquetReaderIterator<IndexedRecord>(reader);
        this.readerIterators.add(parquetReaderIterator);
        return parquetReaderIterator;
    }

    @Override
    public ClosableIterator<String> getRecordKeyIterator() throws IOException {
        final ClosableIterator<IndexedRecord> recordKeyIterator = this.getIndexedRecordIterator(HoodieAvroUtils.getRecordKeySchema());
        return new ClosableIterator<String>(){

            @Override
            public boolean hasNext() {
                return recordKeyIterator.hasNext();
            }

            @Override
            public String next() {
                Object obj = recordKeyIterator.next();
                return ((GenericRecord)obj).get(HoodieRecord.RECORD_KEY_METADATA_FIELD).toString();
            }

            @Override
            public void close() {
                recordKeyIterator.close();
            }
        };
    }
}

