/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage.row;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.bloom.BloomFilterFactory;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ParquetUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.io.storage.HoodieParquetConfig;
import org.apache.hudi.io.storage.row.HoodieInternalRowFileWriter;
import org.apache.hudi.io.storage.row.HoodieInternalRowParquetWriter;
import org.apache.hudi.io.storage.row.HoodieRowParquetWriteSupport;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.hadoop.HadoopStorageConfiguration;
import org.apache.hudi.table.HoodieTable;
import org.apache.spark.sql.types.StructType;

public class HoodieInternalRowFileWriterFactory {
    public static HoodieInternalRowFileWriter getInternalRowFileWriter(StoragePath path, HoodieTable hoodieTable, HoodieWriteConfig writeConfig, StructType schema) throws IOException {
        String extension = FSUtils.getFileExtension(path.getName());
        if (HoodieFileFormat.PARQUET.getFileExtension().equals(extension)) {
            return HoodieInternalRowFileWriterFactory.newParquetInternalRowFileWriter(path, hoodieTable, writeConfig, schema, HoodieInternalRowFileWriterFactory.tryInstantiateBloomFilter(writeConfig));
        }
        throw new UnsupportedOperationException(extension + " format not supported yet.");
    }

    private static HoodieInternalRowFileWriter newParquetInternalRowFileWriter(StoragePath path, HoodieTable table, HoodieWriteConfig writeConfig, StructType structType, Option<BloomFilter> bloomFilterOpt) throws IOException {
        HoodieRowParquetWriteSupport writeSupport = HoodieRowParquetWriteSupport.getHoodieRowParquetWriteSupport((Configuration)table.getStorageConf().unwrap(), structType, bloomFilterOpt, writeConfig);
        return new HoodieInternalRowParquetWriter(path, new HoodieParquetConfig<HoodieRowParquetWriteSupport>(writeSupport, ParquetUtils.getCompressionCodecName(writeConfig.getParquetCompressionCodec()), writeConfig.getParquetBlockSize(), writeConfig.getParquetPageSize(), writeConfig.getParquetMaxFileSize(), new HadoopStorageConfiguration(writeSupport.getHadoopConf()), writeConfig.getParquetCompressionRatio(), writeConfig.parquetDictionaryEnabled()));
    }

    private static Option<BloomFilter> tryInstantiateBloomFilter(HoodieWriteConfig writeConfig) {
        if (writeConfig.populateMetaFields()) {
            BloomFilter bloomFilter = BloomFilterFactory.createBloomFilter(writeConfig.getBloomFilterNumEntries(), writeConfig.getBloomFilterFPP(), writeConfig.getDynamicBloomFilterMaxNumEntries(), writeConfig.getBloomFilterType());
            return Option.of(bloomFilter);
        }
        return Option.empty();
    }
}

