/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hudi.avro.model.HoodieMetadataBloomFilter;
import org.apache.hudi.avro.model.HoodieMetadataColumnStats;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.bloom.BloomFilterFactory;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordGlobalLocation;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.common.util.hash.ColumnIndexID;
import org.apache.hudi.common.util.hash.FileIndexID;
import org.apache.hudi.common.util.hash.PartitionIndexID;
import org.apache.hudi.config.metrics.HoodieMetricsConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieMetadataException;
import org.apache.hudi.metadata.AbstractHoodieTableMetadata;
import org.apache.hudi.metadata.HoodieMetadataMetrics;
import org.apache.hudi.metadata.HoodieMetadataPayload;
import org.apache.hudi.metadata.HoodieTableMetadataUtil;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTableMetadata
extends AbstractHoodieTableMetadata {
    private static final Logger LOG = LoggerFactory.getLogger(BaseTableMetadata.class);
    protected static final long MAX_MEMORY_SIZE_IN_BYTES = 0x40000000L;
    protected static final int BUFFER_SIZE = 10240;
    protected final HoodieTableMetaClient dataMetaClient;
    protected final Option<HoodieMetadataMetrics> metrics;
    protected final HoodieMetadataConfig metadataConfig;
    protected boolean isMetadataTableInitialized;
    protected final boolean hiveStylePartitioningEnabled;
    protected final boolean urlEncodePartitioningEnabled;

    protected BaseTableMetadata(HoodieEngineContext engineContext, HoodieStorage storage, HoodieMetadataConfig metadataConfig, String dataBasePath) {
        super(engineContext, storage, dataBasePath);
        this.dataMetaClient = HoodieTableMetaClient.builder().setStorage(storage).setBasePath(dataBasePath).build();
        this.hiveStylePartitioningEnabled = Boolean.parseBoolean(this.dataMetaClient.getTableConfig().getHiveStylePartitioningEnable());
        this.urlEncodePartitioningEnabled = Boolean.parseBoolean(this.dataMetaClient.getTableConfig().getUrlEncodePartitioning());
        this.metadataConfig = metadataConfig;
        this.isMetadataTableInitialized = this.dataMetaClient.getTableConfig().isMetadataTableAvailable();
        this.metrics = metadataConfig.isMetricsEnabled() ? Option.of(new HoodieMetadataMetrics(HoodieMetricsConfig.newBuilder().fromProperties(metadataConfig.getProps()).build(), this.dataMetaClient.getStorage())) : Option.empty();
    }

    protected HoodieEngineContext getEngineContext() {
        if (this.engineContext == null) {
            this.engineContext = new HoodieLocalEngineContext(this.dataMetaClient.getStorageConf());
        }
        return this.engineContext;
    }

    @Override
    public List<String> getAllPartitionPaths() throws IOException {
        ValidationUtils.checkArgument(this.isMetadataTableInitialized);
        try {
            return this.fetchAllPartitionPaths();
        }
        catch (Exception e) {
            throw new HoodieMetadataException("Failed to retrieve list of partition from metadata", e);
        }
    }

    @Override
    public List<StoragePathInfo> getAllFilesInPartition(StoragePath partitionPath) throws IOException {
        ValidationUtils.checkArgument(this.isMetadataTableInitialized);
        try {
            return this.fetchAllFilesInPartition(partitionPath);
        }
        catch (Exception e) {
            throw new HoodieMetadataException("Failed to retrieve files in partition " + partitionPath + " from metadata", e);
        }
    }

    @Override
    public Map<String, List<StoragePathInfo>> getAllFilesInPartitions(Collection<String> partitions) throws IOException {
        ValidationUtils.checkArgument(this.isMetadataTableInitialized);
        if (partitions.isEmpty()) {
            return Collections.emptyMap();
        }
        try {
            List<StoragePath> partitionPaths = partitions.stream().map(StoragePath::new).collect(Collectors.toList());
            return this.fetchAllFilesInPartitionPaths(partitionPaths);
        }
        catch (Exception e) {
            throw new HoodieMetadataException("Failed to retrieve files in partition from metadata", e);
        }
    }

    @Override
    public Option<BloomFilter> getBloomFilter(String partitionName, String fileName) throws HoodieMetadataException {
        if (!this.dataMetaClient.getTableConfig().isMetadataPartitionAvailable(MetadataPartitionType.BLOOM_FILTERS)) {
            LOG.error("Metadata bloom filter index is disabled!");
            return Option.empty();
        }
        Pair<String, String> partitionFileName = Pair.of(partitionName, fileName);
        Map<Pair<String, String>, BloomFilter> bloomFilters = this.getBloomFilters(Collections.singletonList(partitionFileName));
        if (bloomFilters.isEmpty()) {
            LOG.error("Meta index: missing bloom filter for partition: " + partitionName + ", file: " + fileName);
            return Option.empty();
        }
        ValidationUtils.checkState(bloomFilters.containsKey(partitionFileName));
        return Option.of(bloomFilters.get(partitionFileName));
    }

    @Override
    public Map<Pair<String, String>, BloomFilter> getBloomFilters(List<Pair<String, String>> partitionNameFileNameList) throws HoodieMetadataException {
        if (!this.dataMetaClient.getTableConfig().isMetadataPartitionAvailable(MetadataPartitionType.BLOOM_FILTERS)) {
            LOG.error("Metadata bloom filter index is disabled!");
            return Collections.emptyMap();
        }
        if (partitionNameFileNameList.isEmpty()) {
            return Collections.emptyMap();
        }
        HoodieTimer timer = HoodieTimer.start();
        HashSet partitionIDFileIDStrings = new HashSet();
        HashMap fileToKeyMap = new HashMap();
        partitionNameFileNameList.forEach(partitionNameFileNamePair -> {
            String bloomFilterIndexKey = HoodieMetadataPayload.getBloomFilterIndexKey(new PartitionIndexID(HoodieTableMetadataUtil.getBloomFilterIndexPartitionIdentifier((String)partitionNameFileNamePair.getLeft())), new FileIndexID((String)partitionNameFileNamePair.getRight()));
            partitionIDFileIDStrings.add(bloomFilterIndexKey);
            fileToKeyMap.put(bloomFilterIndexKey, partitionNameFileNamePair);
        });
        ArrayList<String> partitionIDFileIDStringsList = new ArrayList<String>(partitionIDFileIDStrings);
        Map<String, HoodieRecord<HoodieMetadataPayload>> hoodieRecords = this.getRecordsByKeys(partitionIDFileIDStringsList, MetadataPartitionType.BLOOM_FILTERS.getPartitionPath());
        this.metrics.ifPresent(m -> m.updateMetrics("lookup_meta_index_bloom_filters", timer.endTimer() / (long)partitionIDFileIDStrings.size()));
        HashMap<Pair<String, String>, BloomFilter> partitionFileToBloomFilterMap = new HashMap<Pair<String, String>, BloomFilter>(hoodieRecords.size());
        for (Map.Entry<String, HoodieRecord<HoodieMetadataPayload>> entry : hoodieRecords.entrySet()) {
            Option<HoodieMetadataBloomFilter> bloomFilterMetadata = entry.getValue().getData().getBloomFilterMetadata();
            if (bloomFilterMetadata.isPresent()) {
                if (bloomFilterMetadata.get().getIsDeleted()) continue;
                ValidationUtils.checkState(fileToKeyMap.containsKey(entry.getKey()));
                ByteBuffer bloomFilterByteBuffer = bloomFilterMetadata.get().getBloomFilter().duplicate();
                String bloomFilterType = bloomFilterMetadata.get().getType();
                BloomFilter bloomFilter = BloomFilterFactory.fromString(StandardCharsets.UTF_8.decode(bloomFilterByteBuffer).toString(), bloomFilterType);
                partitionFileToBloomFilterMap.put((Pair<String, String>)fileToKeyMap.get(entry.getKey()), bloomFilter);
                continue;
            }
            LOG.error("Meta index bloom filter missing for: " + fileToKeyMap.get(entry.getKey()));
        }
        return partitionFileToBloomFilterMap;
    }

    @Override
    public Map<Pair<String, String>, HoodieMetadataColumnStats> getColumnStats(List<Pair<String, String>> partitionNameFileNameList, String columnName) throws HoodieMetadataException {
        if (!this.dataMetaClient.getTableConfig().isMetadataPartitionAvailable(MetadataPartitionType.COLUMN_STATS)) {
            LOG.error("Metadata column stats index is disabled!");
            return Collections.emptyMap();
        }
        HashMap<String, Pair<String, String>> columnStatKeyToFileNameMap = new HashMap<String, Pair<String, String>>();
        HashSet<String> columnStatKeyset = new HashSet<String>();
        ColumnIndexID columnIndexID = new ColumnIndexID(columnName);
        for (Pair<String, String> partitionNameFileNamePair : partitionNameFileNameList) {
            String columnStatsIndexKey = HoodieMetadataPayload.getColumnStatsIndexKey(new PartitionIndexID(HoodieTableMetadataUtil.getColumnStatsIndexPartitionIdentifier(partitionNameFileNamePair.getLeft())), new FileIndexID(partitionNameFileNamePair.getRight()), columnIndexID);
            columnStatKeyset.add(columnStatsIndexKey);
            columnStatKeyToFileNameMap.put(columnStatsIndexKey, partitionNameFileNamePair);
        }
        ArrayList<String> columnStatKeylist = new ArrayList<String>(columnStatKeyset);
        HoodieTimer timer = HoodieTimer.start();
        Map<String, HoodieRecord<HoodieMetadataPayload>> hoodieRecords = this.getRecordsByKeys(columnStatKeylist, MetadataPartitionType.COLUMN_STATS.getPartitionPath());
        this.metrics.ifPresent(m -> m.updateMetrics("lookup_meta_index_column_ranges", timer.endTimer()));
        HashMap<Pair<String, String>, HoodieMetadataColumnStats> fileToColumnStatMap = new HashMap<Pair<String, String>, HoodieMetadataColumnStats>();
        for (Map.Entry<String, HoodieRecord<HoodieMetadataPayload>> entry : hoodieRecords.entrySet()) {
            Option<HoodieMetadataColumnStats> columnStatMetadata = entry.getValue().getData().getColumnStatMetadata();
            if (columnStatMetadata.isPresent()) {
                if (columnStatMetadata.get().getIsDeleted()) continue;
                ValidationUtils.checkState(columnStatKeyToFileNameMap.containsKey(entry.getKey()));
                Pair partitionFileNamePair = (Pair)columnStatKeyToFileNameMap.get(entry.getKey());
                ValidationUtils.checkState(!fileToColumnStatMap.containsKey(partitionFileNamePair));
                fileToColumnStatMap.put(partitionFileNamePair, columnStatMetadata.get());
                continue;
            }
            LOG.error("Meta index column stats missing for: " + entry.getKey());
        }
        return fileToColumnStatMap;
    }

    @Override
    public Map<String, HoodieRecordGlobalLocation> readRecordIndex(List<String> recordKeys) {
        ValidationUtils.checkState(this.dataMetaClient.getTableConfig().isMetadataPartitionAvailable(MetadataPartitionType.RECORD_INDEX), "Record index is not initialized in MDT");
        HoodieTimer timer = HoodieTimer.start();
        Map<String, HoodieRecord<HoodieMetadataPayload>> result = this.getRecordsByKeys(recordKeys, MetadataPartitionType.RECORD_INDEX.getPartitionPath());
        HashMap<String, HoodieRecordGlobalLocation> recordKeyToLocation = new HashMap<String, HoodieRecordGlobalLocation>(result.size());
        result.forEach((key, record) -> {
            if (!((HoodieMetadataPayload)record.getData()).isDeleted()) {
                recordKeyToLocation.put((String)key, ((HoodieMetadataPayload)record.getData()).getRecordGlobalLocation());
            }
        });
        this.metrics.ifPresent(m -> m.updateMetrics("lookup_record_index_time", timer.endTimer()));
        this.metrics.ifPresent(m -> m.updateMetrics("lookup_record_index_key_count", recordKeys.size()));
        this.metrics.ifPresent(m -> m.updateMetrics("lookup_record_index_key_count", recordKeyToLocation.size()));
        return recordKeyToLocation;
    }

    protected List<String> fetchAllPartitionPaths() {
        HoodieTimer timer = HoodieTimer.start();
        Option<HoodieRecord<HoodieMetadataPayload>> recordOpt = this.getRecordByKey("__all_partitions__", MetadataPartitionType.FILES.getPartitionPath());
        this.metrics.ifPresent(m -> m.updateMetrics("lookup_partitions", timer.endTimer()));
        List<String> partitions = recordOpt.map(record -> {
            HoodieMetadataPayload metadataPayload = (HoodieMetadataPayload)record.getData();
            this.checkForSpuriousDeletes(metadataPayload, "\"all partitions\"");
            List<String> relativePaths = metadataPayload.getFilenames();
            if (relativePaths.size() == 1 && relativePaths.get(0).equals(".")) {
                return Collections.singletonList("");
            }
            return relativePaths;
        }).orElse(Collections.emptyList());
        LOG.info("Listed partitions from metadata: #partitions=" + partitions.size());
        return partitions;
    }

    List<StoragePathInfo> fetchAllFilesInPartition(StoragePath partitionPath) throws IOException {
        String relativePartitionPath = FSUtils.getRelativePartitionPath(this.dataBasePath, partitionPath);
        String recordKey = relativePartitionPath.isEmpty() ? "." : relativePartitionPath;
        HoodieTimer timer = HoodieTimer.start();
        Option<HoodieRecord<HoodieMetadataPayload>> recordOpt = this.getRecordByKey(recordKey, MetadataPartitionType.FILES.getPartitionPath());
        this.metrics.ifPresent(m -> m.updateMetrics("lookup_files", timer.endTimer()));
        List pathInfoList = recordOpt.map(record -> {
            HoodieMetadataPayload metadataPayload = (HoodieMetadataPayload)record.getData();
            this.checkForSpuriousDeletes(metadataPayload, recordKey);
            try {
                return metadataPayload.getFileList(this.dataMetaClient.getStorage(), partitionPath);
            }
            catch (Exception e) {
                throw new HoodieException("Failed to extract file-pathInfoList from the payload", e);
            }
        }).orElseGet(Collections::emptyList);
        LOG.info("Listed file in partition from metadata: partition=" + relativePartitionPath + ", #files=" + pathInfoList.size());
        return pathInfoList;
    }

    Map<String, List<StoragePathInfo>> fetchAllFilesInPartitionPaths(List<StoragePath> partitionPaths) throws IOException {
        Map partitionIdToPathMap = partitionPaths.parallelStream().collect(Collectors.toMap(partitionPath -> {
            String partitionId = FSUtils.getRelativePartitionPath(this.dataBasePath, partitionPath);
            return partitionId.isEmpty() ? "." : partitionId;
        }, Function.identity()));
        HoodieTimer timer = HoodieTimer.start();
        Map<String, HoodieRecord<HoodieMetadataPayload>> partitionIdRecordPairs = this.getRecordsByKeys(new ArrayList<String>(partitionIdToPathMap.keySet()), MetadataPartitionType.FILES.getPartitionPath());
        this.metrics.ifPresent(m -> m.updateMetrics("lookup_files", timer.endTimer()));
        Map<String, List<StoragePathInfo>> partitionPathToFilesMap = partitionIdRecordPairs.entrySet().stream().map(e -> {
            String partitionId = (String)e.getKey();
            StoragePath partitionPath = (StoragePath)partitionIdToPathMap.get(partitionId);
            HoodieMetadataPayload metadataPayload = (HoodieMetadataPayload)((HoodieRecord)e.getValue()).getData();
            this.checkForSpuriousDeletes(metadataPayload, partitionId);
            List<StoragePathInfo> files = metadataPayload.getFileList(this.dataMetaClient.getStorage(), partitionPath);
            return Pair.of(partitionPath.toString(), files);
        }).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
        LOG.info("Listed files in " + partitionPaths.size() + " partitions from metadata");
        return partitionPathToFilesMap;
    }

    private void checkForSpuriousDeletes(HoodieMetadataPayload metadataPayload, String partitionName) {
        if (!metadataPayload.getDeletions().isEmpty()) {
            if (this.metadataConfig.shouldIgnoreSpuriousDeletes()) {
                LOG.warn("Metadata record for " + partitionName + " encountered some files to be deleted which was not added before. Ignoring the spurious deletes as the `" + HoodieMetadataConfig.IGNORE_SPURIOUS_DELETES.key() + "` config is set to true");
            } else {
                throw new HoodieMetadataException("Metadata record for " + partitionName + " is inconsistent: " + metadataPayload);
            }
        }
    }

    protected abstract Option<HoodieRecord<HoodieMetadataPayload>> getRecordByKey(String var1, String var2);

    protected abstract Map<String, HoodieRecord<HoodieMetadataPayload>> getRecordsByKeys(List<String> var1, String var2);

    public HoodieMetadataConfig getMetadataConfig() {
        return this.metadataConfig;
    }

    protected StorageConfiguration<?> getStorageConf() {
        return this.dataMetaClient.getStorageConf();
    }

    protected String getLatestDataInstantTime() {
        return this.dataMetaClient.getActiveTimeline().filterCompletedInstants().lastInstant().map(HoodieInstant::getTimestamp).orElse("00000000000000");
    }

    public boolean isMetadataTableInitialized() {
        return this.isMetadataTableInitialized;
    }
}

