/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.types;

import org.apache.hudi.org.apache.hadoop.hbase.types.DataType;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.hudi.org.apache.hadoop.hbase.util.Order;
import org.apache.hudi.org.apache.hadoop.hbase.util.PositionedByteRange;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class RawBytes
implements DataType<byte[]> {
    public static final RawBytes ASCENDING = new RawBytes(Order.ASCENDING);
    public static final RawBytes DESCENDING = new RawBytes(Order.DESCENDING);
    protected final Order order;

    protected RawBytes() {
        this.order = Order.ASCENDING;
    }

    protected RawBytes(Order order) {
        this.order = order;
    }

    @Override
    public boolean isOrderPreserving() {
        return true;
    }

    @Override
    public Order getOrder() {
        return this.order;
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public boolean isSkippable() {
        return false;
    }

    @Override
    public int skip(PositionedByteRange src) {
        int skipped = src.getRemaining();
        src.setPosition(src.getLength());
        return skipped;
    }

    @Override
    public int encodedLength(byte[] val) {
        return val.length;
    }

    @Override
    public Class<byte[]> encodedClass() {
        return byte[].class;
    }

    @Override
    public byte[] decode(PositionedByteRange src) {
        return this.decode(src, src.getRemaining());
    }

    @Override
    public int encode(PositionedByteRange dst, byte[] val) {
        return this.encode(dst, val, 0, val.length);
    }

    public byte[] decode(PositionedByteRange src, int length) {
        byte[] val = new byte[length];
        src.get(val);
        return val;
    }

    public int encode(PositionedByteRange dst, byte[] val, int voff, int vlen) {
        Bytes.putBytes(dst.getBytes(), dst.getOffset() + dst.getPosition(), val, voff, vlen);
        dst.setPosition(dst.getPosition() + vlen);
        return vlen;
    }
}

