/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.rollback;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.hudi.avro.model.HoodieRollbackPlan;
import org.apache.hudi.avro.model.HoodieRollbackRequest;
import org.apache.hudi.common.HoodieRollbackStat;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.log.block.HoodieCommandBlock;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.storage.StoragePathInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RollbackUtils {
    private static final Logger LOG = LoggerFactory.getLogger(RollbackUtils.class);

    public static HoodieRollbackPlan getRollbackPlan(HoodieTableMetaClient metaClient, HoodieInstant rollbackInstant) throws IOException {
        HoodieInstant requested = HoodieTimeline.getRollbackRequestedInstant(rollbackInstant);
        return TimelineMetadataUtils.deserializeAvroMetadata(metaClient.getActiveTimeline().readRollbackInfoAsBytes(requested).get(), HoodieRollbackPlan.class);
    }

    static Map<HoodieLogBlock.HeaderMetadataType, String> generateHeader(String instantToRollback, String rollbackInstantTime) {
        HashMap<HoodieLogBlock.HeaderMetadataType, String> header = new HashMap<HoodieLogBlock.HeaderMetadataType, String>(3);
        header.put(HoodieLogBlock.HeaderMetadataType.INSTANT_TIME, rollbackInstantTime);
        header.put(HoodieLogBlock.HeaderMetadataType.TARGET_INSTANT_TIME, instantToRollback);
        header.put(HoodieLogBlock.HeaderMetadataType.COMMAND_BLOCK_TYPE, String.valueOf(HoodieCommandBlock.HoodieCommandBlockTypeEnum.ROLLBACK_BLOCK.ordinal()));
        return header;
    }

    static HoodieRollbackStat mergeRollbackStat(HoodieRollbackStat stat1, HoodieRollbackStat stat2) {
        ValidationUtils.checkArgument(stat1.getPartitionPath().equals(stat2.getPartitionPath()));
        ArrayList<String> successDeleteFiles = new ArrayList<String>();
        ArrayList<String> failedDeleteFiles = new ArrayList<String>();
        HashMap<StoragePathInfo, Long> commandBlocksCount = new HashMap<StoragePathInfo, Long>();
        HashMap<String, Long> logFilesFromFailedCommit = new HashMap<String, Long>();
        Option.ofNullable(stat1.getSuccessDeleteFiles()).ifPresent(successDeleteFiles::addAll);
        Option.ofNullable(stat2.getSuccessDeleteFiles()).ifPresent(successDeleteFiles::addAll);
        Option.ofNullable(stat1.getFailedDeleteFiles()).ifPresent(failedDeleteFiles::addAll);
        Option.ofNullable(stat2.getFailedDeleteFiles()).ifPresent(failedDeleteFiles::addAll);
        Option.ofNullable(stat1.getCommandBlocksCount()).ifPresent(commandBlocksCount::putAll);
        Option.ofNullable(stat2.getCommandBlocksCount()).ifPresent(commandBlocksCount::putAll);
        Option.ofNullable(stat1.getLogFilesFromFailedCommit()).ifPresent(logFilesFromFailedCommit::putAll);
        Option.ofNullable(stat2.getLogFilesFromFailedCommit()).ifPresent(logFilesFromFailedCommit::putAll);
        return new HoodieRollbackStat(stat1.getPartitionPath(), successDeleteFiles, failedDeleteFiles, commandBlocksCount, logFilesFromFailedCommit);
    }

    static HoodieRollbackRequest mergeRollbackRequest(HoodieRollbackRequest rollbackRequest1, HoodieRollbackRequest rollbackRequest2) {
        ValidationUtils.checkArgument(rollbackRequest1.getPartitionPath().equals(rollbackRequest2.getPartitionPath()));
        ValidationUtils.checkArgument(rollbackRequest1.getFileId().equals(rollbackRequest2.getFileId()));
        ValidationUtils.checkArgument(rollbackRequest1.getLatestBaseInstant().equals(rollbackRequest2.getLatestBaseInstant()));
        ArrayList<String> filesToBeDeleted = new ArrayList<String>();
        HashMap<String, Long> logBlocksToBeDeleted = new HashMap<String, Long>();
        Option.ofNullable(rollbackRequest1.getFilesToBeDeleted()).ifPresent(filesToBeDeleted::addAll);
        Option.ofNullable(rollbackRequest1.getLogBlocksToBeDeleted()).ifPresent(logBlocksToBeDeleted::putAll);
        Option.ofNullable(rollbackRequest2.getFilesToBeDeleted()).ifPresent(filesToBeDeleted::addAll);
        Option.ofNullable(rollbackRequest2.getLogBlocksToBeDeleted()).ifPresent(logBlocksToBeDeleted::putAll);
        return new HoodieRollbackRequest(rollbackRequest1.getPartitionPath(), rollbackRequest1.getFileId(), rollbackRequest1.getLatestBaseInstant(), filesToBeDeleted, logBlocksToBeDeleted);
    }
}

