/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command;

import java.io.Serializable;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.HoodieStorageUtils;
import org.apache.hudi.storage.StoragePath;
import org.apache.spark.api.java.JavaSparkContext$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.QualifiedTableName;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.trees.HoodieLeafLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.hudi.command.DropHoodieTableCommand$;
import org.apache.spark.sql.hudi.command.HoodieLeafRunnableCommand;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u00055h\u0001B\u0012%\u0001FB\u0001\"\u0013\u0001\u0003\u0016\u0004%\tA\u0013\u0005\t\u001f\u0002\u0011\t\u0012)A\u0005\u0017\"A\u0001\u000b\u0001BK\u0002\u0013\u0005\u0011\u000b\u0003\u0005V\u0001\tE\t\u0015!\u0003S\u0011!1\u0006A!f\u0001\n\u0003\t\u0006\u0002C,\u0001\u0005#\u0005\u000b\u0011\u0002*\t\u0011a\u0003!Q3A\u0005\u0002EC\u0001\"\u0017\u0001\u0003\u0012\u0003\u0006IA\u0015\u0005\u00065\u0002!\ta\u0017\u0005\bC\u0002\u0011\r\u0011\"\u0003c\u0011\u0019Y\u0007\u0001)A\u0005G\"9A\u000e\u0001b\u0001\n\u0013\u0011\u0007BB7\u0001A\u0003%1\rC\u0003o\u0001\u0011\u0005s\u000eC\u0004\u0002\f\u0001!I!!\u0004\t\u000f\u0005u\u0001\u0001\"\u0003\u0002 !I\u00111\n\u0001\u0002\u0002\u0013\u0005\u0011Q\n\u0005\n\u0003/\u0002\u0011\u0013!C\u0001\u00033B\u0011\"a\u001c\u0001#\u0003%\t!!\u001d\t\u0013\u0005U\u0004!%A\u0005\u0002\u0005E\u0004\"CA<\u0001E\u0005I\u0011AA9\u0011!\tI\bAA\u0001\n\u0003\u0012\u0007\"CA>\u0001\u0005\u0005I\u0011AA?\u0011%\t)\tAA\u0001\n\u0003\t9\tC\u0005\u0002\u0014\u0002\t\t\u0011\"\u0011\u0002\u0016\"I\u00111\u0015\u0001\u0002\u0002\u0013\u0005\u0011Q\u0015\u0005\n\u0003S\u0003\u0011\u0011!C!\u0003W;\u0011\"a,%\u0003\u0003E\t!!-\u0007\u0011\r\"\u0013\u0011!E\u0001\u0003gCaAW\u000f\u0005\u0002\u0005\u0005\u0007\"CAb;\u0005\u0005IQIAc\u0011%\t9-HA\u0001\n\u0003\u000bI\rC\u0005\u0002Tv\t\t\u0011\"!\u0002V\"I\u00111]\u000f\u0002\u0002\u0013%\u0011Q\u001d\u0002\u0017\tJ|\u0007\u000fS8pI&,G+\u00192mK\u000e{W.\\1oI*\u0011QEJ\u0001\bG>lW.\u00198e\u0015\t9\u0003&\u0001\u0003ik\u0012L'BA\u0015+\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003W1\nQa\u001d9be.T!!\f\u0018\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0013aA8sO\u000e\u00011#\u0002\u00013y\u00013\u0005CA\u001a;\u001b\u0005!$BA\u001b7\u0003\u001dawnZ5dC2T!a\u000e\u001d\u0002\u000bAd\u0017M\\:\u000b\u0005eB\u0013\u0001C2bi\u0006d\u0017p\u001d;\n\u0005m\"$a\u0003'pO&\u001c\u0017\r\u001c)mC:\u0004\"!\u0010 \u000e\u0003\u0011J!a\u0010\u0013\u00033!{w\u000eZ5f\u0019\u0016\fgMU;o]\u0006\u0014G.Z\"p[6\fg\u000e\u001a\t\u0003\u0003\u0012k\u0011A\u0011\u0006\u0002\u0007\u0006)1oY1mC&\u0011QI\u0011\u0002\b!J|G-^2u!\t\tu)\u0003\u0002I\u0005\na1+\u001a:jC2L'0\u00192mK\u0006yA/\u00192mK&#WM\u001c;jM&,'/F\u0001L!\taU*D\u00019\u0013\tq\u0005HA\bUC\ndW-\u00133f]RLg-[3s\u0003A!\u0018M\u00197f\u0013\u0012,g\u000e^5gS\u0016\u0014\b%\u0001\u0005jM\u0016C\u0018n\u001d;t+\u0005\u0011\u0006CA!T\u0013\t!&IA\u0004C_>dW-\u00198\u0002\u0013%4W\t_5tiN\u0004\u0013AB5t-&,w/A\u0004jgZKWm\u001e\u0011\u0002\u000bA,(oZ3\u0002\rA,(oZ3!\u0003\u0019a\u0014N\\5u}Q)A,\u00180`AB\u0011Q\b\u0001\u0005\u0006\u0013&\u0001\ra\u0013\u0005\u0006!&\u0001\rA\u0015\u0005\u0006-&\u0001\rA\u0015\u0005\u00061&\u0001\rAU\u0001\u001a\u001b>\u0013vl\u0015(B!NCu\nV0U\u0003\ncUiX*V\r\u001aK\u0005,F\u0001d!\t!\u0017.D\u0001f\u0015\t1w-\u0001\u0003mC:<'\"\u00015\u0002\t)\fg/Y\u0005\u0003U\u0016\u0014aa\u0015;sS:<\u0017AG'P%~\u001bf*\u0011)T\u0011>#v\fV!C\u0019\u0016{6+\u0016$G\u0013b\u0003\u0013aH'P%~\u0013V)\u0011#`\u001fB#\u0016*T%[\u000b\u0012{F+\u0011\"M\u000b~\u001bVK\u0012$J1\u0006\u0001Sj\u0014*`%\u0016\u000bEiX(Q)&k\u0015JW#E?R\u000b%\tT#`'V3e)\u0013-!\u0003\r\u0011XO\u001c\u000b\u0004a\u0006\u0005\u0001cA9zy:\u0011!o\u001e\b\u0003gZl\u0011\u0001\u001e\u0006\u0003kB\na\u0001\u0010:p_Rt\u0014\"A\"\n\u0005a\u0014\u0015a\u00029bG.\fw-Z\u0005\u0003un\u00141aU3r\u0015\tA(\t\u0005\u0002~}6\t\u0001&\u0003\u0002\u0000Q\t\u0019!k\\<\t\u000f\u0005\ra\u00021\u0001\u0002\u0006\u0005a1\u000f]1sWN+7o]5p]B\u0019Q0a\u0002\n\u0007\u0005%\u0001F\u0001\u0007Ta\u0006\u00148nU3tg&|g.\u0001\nee>\u0004H+\u00192mK&s7)\u0019;bY><GCCA\b\u0003+\t9\"!\u0007\u0002\u001cA\u0019\u0011)!\u0005\n\u0007\u0005M!I\u0001\u0003V]&$\bbBA\u0002\u001f\u0001\u0007\u0011Q\u0001\u0005\u0006\u0013>\u0001\ra\u0013\u0005\u0006!>\u0001\rA\u0015\u0005\u00061>\u0001\rAU\u0001\u0010O\u0016$H+\u00192mKJ#\u0016I\u001c3S\u001fR1\u0011\u0011EA\u001d\u0003\u0003\u0002r!QA\u0012\u0003O\t9#C\u0002\u0002&\t\u0013a\u0001V;qY\u0016\u0014\u0004#B!\u0002*\u00055\u0012bAA\u0016\u0005\n1q\n\u001d;j_:\u0004B!a\f\u000265\u0011\u0011\u0011\u0007\u0006\u0004\u0003gA\u0014aB2bi\u0006dwnZ\u0005\u0005\u0003o\t\tD\u0001\u0007DCR\fGn\\4UC\ndW\rC\u0004\u00024A\u0001\r!a\u000f\u0011\t\u0005=\u0012QH\u0005\u0005\u0003\u007f\t\tD\u0001\bTKN\u001c\u0018n\u001c8DCR\fGn\\4\t\u000f\u0005\r\u0003\u00031\u0001\u0002F\u0005Y\u0001n\\8eS\u0016$\u0016M\u00197f!\u0011\ty#a\u0012\n\t\u0005%\u0013\u0011\u0007\u0002\u0013\u0011>|G-[3DCR\fGn\\4UC\ndW-\u0001\u0003d_BLH#\u0003/\u0002P\u0005E\u00131KA+\u0011\u001dI\u0015\u0003%AA\u0002-Cq\u0001U\t\u0011\u0002\u0003\u0007!\u000bC\u0004W#A\u0005\t\u0019\u0001*\t\u000fa\u000b\u0002\u0013!a\u0001%\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA.U\rY\u0015QL\u0016\u0003\u0003?\u0002B!!\u0019\u0002l5\u0011\u00111\r\u0006\u0005\u0003K\n9'A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011\u000e\"\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002n\u0005\r$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAA:U\r\u0011\u0016QL\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&D\u0018\u0001\u00049s_\u0012,8\r^!sSRLXCAA@!\r\t\u0015\u0011Q\u0005\u0004\u0003\u0007\u0013%aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BAE\u0003\u001f\u00032!QAF\u0013\r\tiI\u0011\u0002\u0004\u0003:L\b\"CAI1\u0005\u0005\t\u0019AA@\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011q\u0013\t\u0007\u00033\u000by*!#\u000e\u0005\u0005m%bAAO\u0005\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\u0005\u00161\u0014\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002S\u0003OC\u0011\"!%\u001b\u0003\u0003\u0005\r!!#\u0002\r\u0015\fX/\u00197t)\r\u0011\u0016Q\u0016\u0005\n\u0003#[\u0012\u0011!a\u0001\u0003\u0013\u000ba\u0003\u0012:pa\"{w\u000eZ5f)\u0006\u0014G.Z\"p[6\fg\u000e\u001a\t\u0003{u\u0019B!HA[\rBI\u0011qWA_\u0017J\u0013&\u000bX\u0007\u0003\u0003sS1!a/C\u0003\u001d\u0011XO\u001c;j[\u0016LA!a0\u0002:\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001b\u0015\u0005\u0005E\u0016\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003\r\fQ!\u00199qYf$\u0012\u0002XAf\u0003\u001b\fy-!5\t\u000b%\u0003\u0003\u0019A&\t\u000bA\u0003\u0003\u0019\u0001*\t\u000bY\u0003\u0003\u0019\u0001*\t\u000ba\u0003\u0003\u0019\u0001*\u0002\u000fUt\u0017\r\u001d9msR!\u0011q[Ap!\u0015\t\u0015\u0011FAm!\u001d\t\u00151\\&S%JK1!!8C\u0005\u0019!V\u000f\u001d7fi!A\u0011\u0011]\u0011\u0002\u0002\u0003\u0007A,A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011\u0011q\u001d\t\u0004I\u0006%\u0018bAAvK\n1qJ\u00196fGR\u0004")
public class DropHoodieTableCommand
extends LogicalPlan
implements HoodieLeafRunnableCommand,
scala.Serializable {
    private final TableIdentifier tableIdentifier;
    private final boolean ifExists;
    private final boolean isView;
    private final boolean purge;
    private final String MOR_SNAPSHOT_TABLE_SUFFIX;
    private final String MOR_READ_OPTIMIZED_TABLE_SUFFIX;
    private Map<String, SQLMetric> metrics;
    private final Seq<Enumeration.Value> nodePatterns;
    private volatile boolean bitmap$0;

    public static Option<Tuple4<TableIdentifier, Object, Object, Object>> unapply(DropHoodieTableCommand dropHoodieTableCommand) {
        return DropHoodieTableCommand$.MODULE$.unapply(dropHoodieTableCommand);
    }

    public static Function1<Tuple4<TableIdentifier, Object, Object, Object>, DropHoodieTableCommand> tupled() {
        return DropHoodieTableCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<Object, Function1<Object, Function1<Object, DropHoodieTableCommand>>>> curried() {
        return DropHoodieTableCommand$.MODULE$.curried();
    }

    @Override
    public final Seq<LogicalPlan> children() {
        return HoodieLeafLike.children$(this);
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return HoodieLeafLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return HoodieLeafLike.withNewChildrenInternal$(this, newChildren);
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public AttributeSet producedAttributes() {
        return Command.producedAttributes$((Command)this);
    }

    public Statistics stats() {
        return Command.stats$((Command)this);
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        DropHoodieTableCommand dropHoodieTableCommand = this;
        synchronized (dropHoodieTableCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$((RunnableCommand)this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    public Map<String, SQLMetric> metrics() {
        return !this.bitmap$0 ? this.metrics$lzycompute() : this.metrics;
    }

    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    public final void org$apache$spark$sql$catalyst$plans$logical$Command$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public TableIdentifier tableIdentifier() {
        return this.tableIdentifier;
    }

    public boolean ifExists() {
        return this.ifExists;
    }

    public boolean isView() {
        return this.isView;
    }

    public boolean purge() {
        return this.purge;
    }

    private String MOR_SNAPSHOT_TABLE_SUFFIX() {
        return this.MOR_SNAPSHOT_TABLE_SUFFIX;
    }

    private String MOR_READ_OPTIMIZED_TABLE_SUFFIX() {
        return this.MOR_READ_OPTIMIZED_TABLE_SUFFIX;
    }

    public Seq<Row> run(SparkSession sparkSession) {
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Start executing 'DROP TABLE' on ").append(this.tableIdentifier().unquotedString()).append(" (ifExists=").append(this.ifExists()).append(", purge=").append(this.purge()).append(").").toString());
        if (!sparkSession.catalog().tableExists(this.tableIdentifier().unquotedString())) {
            sparkSession.catalog().refreshTable(this.tableIdentifier().unquotedString());
        }
        QualifiedTableName qualifiedTableName = new QualifiedTableName((String)this.tableIdentifier().database().getOrElse((Function0 & Serializable & scala.Serializable)() -> sparkSession.sessionState().catalog().getCurrentDatabase()), this.tableIdentifier().table());
        sparkSession.sessionState().catalog().invalidateCachedTable(qualifiedTableName);
        this.dropTableInCatalog(sparkSession, this.tableIdentifier(), this.ifExists(), this.purge());
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Finished executing 'DROP TABLE' on ").append(this.tableIdentifier().unquotedString()).append(".").toString());
        return (Seq)Nil$.MODULE$;
    }

    private void dropTableInCatalog(SparkSession sparkSession, TableIdentifier tableIdentifier, boolean ifExists, boolean purge) {
        block3: {
            HoodieCatalogTable hoodieCatalogTable = HoodieCatalogTable$.MODULE$.apply(sparkSession, tableIdentifier);
            CatalogTable table2 = hoodieCatalogTable.table();
            CatalogTableType catalogTableType = table2.tableType();
            CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
            Predef$.MODULE$.assert(catalogTableType == null ? catalogTableType2 != null : !catalogTableType.equals(catalogTableType2));
            String basePath = hoodieCatalogTable.tableLocation();
            SessionCatalog catalog = sparkSession.sessionState().catalog();
            if (hoodieCatalogTable.hoodieTableExists() && ((Object)((Object)HoodieTableType.MERGE_ON_READ)).equals((Object)hoodieCatalogTable.tableType()) && purge) {
                Tuple2<Option<CatalogTable>, Option<CatalogTable>> tuple2 = this.getTableRTAndRO(catalog, hoodieCatalogTable);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                Option rtTableOpt = (Option)tuple2._1();
                Option roTableOpt = (Option)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)rtTableOpt, (Object)roTableOpt);
                Tuple2 tuple23 = tuple22;
                Option rtTableOpt2 = (Option)tuple23._1();
                Option roTableOpt2 = (Option)tuple23._2();
                rtTableOpt2.foreach((Function1 & Serializable & scala.Serializable)table -> {
                    catalog.dropTable(table.identifier(), true, false);
                    return BoxedUnit.UNIT;
                });
                roTableOpt2.foreach((Function1 & Serializable & scala.Serializable)table -> {
                    catalog.dropTable(table.identifier(), true, false);
                    return BoxedUnit.UNIT;
                });
                catalog.dropTable(table2.identifier().copy(hoodieCatalogTable.tableName(), table2.identifier().copy$default$2()), ifExists, purge);
            } else {
                catalog.dropTable(table2.identifier(), ifExists, purge);
            }
            if (!purge) break block3;
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(9).append("Clean up ").append(basePath).toString());
            StoragePath targetPath = new StoragePath(basePath);
            HoodieSparkEngineContext engineContext = new HoodieSparkEngineContext(JavaSparkContext$.MODULE$.fromSparkContext(sparkSession.sparkContext()));
            HoodieStorage storage = HoodieStorageUtils.getStorage(basePath, HadoopFSUtils.getStorageConf(sparkSession.sparkContext().hadoopConfiguration()));
            FSUtils.deleteDir(engineContext, storage, targetPath, sparkSession.sparkContext().defaultParallelism());
        }
    }

    private Tuple2<Option<CatalogTable>, Option<CatalogTable>> getTableRTAndRO(SessionCatalog catalog, HoodieCatalogTable hoodieTable) {
        CatalogTable roTable;
        CatalogTable rtTable;
        TableIdentifier qual$1 = hoodieTable.table().identifier();
        String x$1 = new StringBuilder(0).append(hoodieTable.tableName()).append(this.MOR_SNAPSHOT_TABLE_SUFFIX()).toString();
        Option x$2 = qual$1.copy$default$2();
        TableIdentifier rtIdt = qual$1.copy(x$1, x$2);
        TableIdentifier qual$2 = hoodieTable.table().identifier();
        String x$3 = new StringBuilder(0).append(hoodieTable.tableName()).append(this.MOR_READ_OPTIMIZED_TABLE_SUFFIX()).toString();
        Option x$4 = qual$2.copy$default$2();
        TableIdentifier roIdt = qual$2.copy(x$3, x$4);
        None$ rtTableOpt = None$.MODULE$;
        None$ roTableOpt = None$.MODULE$;
        if (catalog.tableExists(rtIdt) && (rtTable = catalog.getTableMetadata(rtIdt)).storage().locationUri().equals((Object)hoodieTable.table().storage().locationUri())) {
            Some some;
            String v;
            Option option = rtTable.storage().properties().get((Object)"hoodie.query.as.ro.table");
            if (option instanceof Some && (v = (String)(some = (Some)option).value()).equalsIgnoreCase("false")) {
                rtTableOpt = new Some((Object)rtTable);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
        if (catalog.tableExists(roIdt) && (roTable = catalog.getTableMetadata(roIdt)).storage().locationUri().equals((Object)hoodieTable.table().storage().locationUri())) {
            Some some;
            String v;
            Option option = roTable.storage().properties().get((Object)"hoodie.query.as.ro.table");
            if (option instanceof Some && (v = (String)(some = (Some)option).value()).equalsIgnoreCase("true")) {
                roTableOpt = new Some((Object)roTable);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
        return new Tuple2((Object)rtTableOpt, (Object)roTableOpt);
    }

    public DropHoodieTableCommand copy(TableIdentifier tableIdentifier, boolean ifExists, boolean isView, boolean purge) {
        return new DropHoodieTableCommand(tableIdentifier, ifExists, isView, purge);
    }

    public TableIdentifier copy$default$1() {
        return this.tableIdentifier();
    }

    public boolean copy$default$2() {
        return this.ifExists();
    }

    public boolean copy$default$3() {
        return this.isView();
    }

    public boolean copy$default$4() {
        return this.purge();
    }

    public String productPrefix() {
        return "DropHoodieTableCommand";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.tableIdentifier();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToBoolean((boolean)this.ifExists());
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToBoolean((boolean)this.isView());
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToBoolean((boolean)this.purge());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof DropHoodieTableCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof DropHoodieTableCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        DropHoodieTableCommand dropHoodieTableCommand = (DropHoodieTableCommand)x$1;
        TableIdentifier tableIdentifier = this.tableIdentifier();
        TableIdentifier tableIdentifier2 = dropHoodieTableCommand.tableIdentifier();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        if (this.ifExists() != dropHoodieTableCommand.ifExists()) return false;
        if (this.isView() != dropHoodieTableCommand.isView()) return false;
        if (this.purge() != dropHoodieTableCommand.purge()) return false;
        if (!dropHoodieTableCommand.canEqual(this)) return false;
        return true;
    }

    public DropHoodieTableCommand(TableIdentifier tableIdentifier, boolean ifExists, boolean isView, boolean purge) {
        this.tableIdentifier = tableIdentifier;
        this.ifExists = ifExists;
        this.isView = isView;
        this.purge = purge;
        Command.$init$((Command)this);
        RunnableCommand.$init$((RunnableCommand)this);
        HoodieLeafLike.$init$(this);
        this.MOR_SNAPSHOT_TABLE_SUFFIX = "_rt";
        this.MOR_READ_OPTIMIZED_TABLE_SUFFIX = "_ro";
    }
}

