/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command;

import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.secondary.index.SecondaryIndexManager;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.hudi.command.IndexBaseCommand;
import org.apache.spark.sql.hudi.command.RefreshIndexCommand$;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005f\u0001\u0002\u000e\u001c\u0001\"B\u0001B\u000e\u0001\u0003\u0016\u0004%\ta\u000e\u0005\t\u0001\u0002\u0011\t\u0012)A\u0005q!A\u0011\t\u0001BK\u0002\u0013\u0005!\t\u0003\u0005O\u0001\tE\t\u0015!\u0003D\u0011!y\u0005A!f\u0001\n\u0003\u0002\u0006\u0002\u00031\u0001\u0005#\u0005\u000b\u0011B)\t\u000b\u0005\u0004A\u0011\u00012\t\u000b\u001d\u0004A\u0011\t5\t\u000fM\u0004\u0011\u0011!C\u0001i\"9\u0001\u0010AI\u0001\n\u0003I\b\"CA\u0005\u0001E\u0005I\u0011AA\u0006\u0011%\ty\u0001AI\u0001\n\u0003\t\t\u0002C\u0005\u0002\u0016\u0001\t\t\u0011\"\u0011\u0002\u0018!I\u0011q\u0005\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u0006\u0005\n\u0003c\u0001\u0011\u0011!C\u0001\u0003gA\u0011\"a\u0010\u0001\u0003\u0003%\t%!\u0011\t\u0013\u0005=\u0003!!A\u0005\u0002\u0005E\u0003\"CA.\u0001\u0005\u0005I\u0011IA/\u000f%\t\tgGA\u0001\u0012\u0003\t\u0019G\u0002\u0005\u001b7\u0005\u0005\t\u0012AA3\u0011\u0019\tG\u0003\"\u0001\u0002t!I\u0011Q\u000f\u000b\u0002\u0002\u0013\u0015\u0013q\u000f\u0005\n\u0003s\"\u0012\u0011!CA\u0003wB\u0011\"a!\u0015\u0003\u0003%\t)!\"\t\u0013\u0005]E#!A\u0005\n\u0005e%a\u0005*fMJ,7\u000f[%oI\u0016D8i\\7nC:$'B\u0001\u000f\u001e\u0003\u001d\u0019w.\\7b]\u0012T!AH\u0010\u0002\t!,H-\u001b\u0006\u0003A\u0005\n1a]9m\u0015\t\u00113%A\u0003ta\u0006\u00148N\u0003\u0002%K\u00051\u0011\r]1dQ\u0016T\u0011AJ\u0001\u0004_J<7\u0001A\n\u0005\u0001%j3\u0007\u0005\u0002+W5\t1$\u0003\u0002-7\t\u0001\u0012J\u001c3fq\n\u000b7/Z\"p[6\fg\u000e\u001a\t\u0003]Ej\u0011a\f\u0006\u0002a\u0005)1oY1mC&\u0011!g\f\u0002\b!J|G-^2u!\tqC'\u0003\u00026_\ta1+\u001a:jC2L'0\u00192mK\u0006)A/\u00192mKV\t\u0001\b\u0005\u0002:}5\t!H\u0003\u0002<y\u000591-\u0019;bY><'BA\u001f \u0003!\u0019\u0017\r^1msN$\u0018BA ;\u00051\u0019\u0015\r^1m_\u001e$\u0016M\u00197f\u0003\u0019!\u0018M\u00197fA\u0005I\u0011N\u001c3fq:\u000bW.Z\u000b\u0002\u0007B\u0011Ai\u0013\b\u0003\u000b&\u0003\"AR\u0018\u000e\u0003\u001dS!\u0001S\u0014\u0002\rq\u0012xn\u001c;?\u0013\tQu&\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u00196\u0013aa\u0015;sS:<'B\u0001&0\u0003)Ig\u000eZ3y\u001d\u0006lW\rI\u0001\u0007_V$\b/\u001e;\u0016\u0003E\u00032AU,[\u001d\t\u0019VK\u0004\u0002G)&\t\u0001'\u0003\u0002W_\u00059\u0001/Y2lC\u001e,\u0017B\u0001-Z\u0005\r\u0019V-\u001d\u0006\u0003->\u0002\"a\u00170\u000e\u0003qS!!\u0018\u001f\u0002\u0017\u0015D\bO]3tg&|gn]\u0005\u0003?r\u0013\u0011\"\u0011;ue&\u0014W\u000f^3\u0002\u000f=,H\u000f];uA\u00051A(\u001b8jiz\"Ba\u00193fMB\u0011!\u0006\u0001\u0005\u0006m\u001d\u0001\r\u0001\u000f\u0005\u0006\u0003\u001e\u0001\ra\u0011\u0005\u0006\u001f\u001e\u0001\r!U\u0001\u0004eVtGCA5o!\r\u0011vK\u001b\t\u0003W2l\u0011aH\u0005\u0003[~\u00111AU8x\u0011\u0015y\u0007\u00021\u0001q\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o!\tY\u0017/\u0003\u0002s?\ta1\u000b]1sWN+7o]5p]\u0006!1m\u001c9z)\u0011\u0019WO^<\t\u000fYJ\u0001\u0013!a\u0001q!9\u0011)\u0003I\u0001\u0002\u0004\u0019\u0005bB(\n!\u0003\u0005\r!U\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\u0005Q(F\u0001\u001d|W\u0005a\bcA?\u0002\u00065\taPC\u0002\u0000\u0003\u0003\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\rq&\u0001\u0006b]:|G/\u0019;j_:L1!a\u0002\u007f\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\tiA\u000b\u0002Dw\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTCAA\nU\t\t60A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u00033\u0001B!a\u0007\u0002&5\u0011\u0011Q\u0004\u0006\u0005\u0003?\t\t#\u0001\u0003mC:<'BAA\u0012\u0003\u0011Q\u0017M^1\n\u00071\u000bi\"\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002,A\u0019a&!\f\n\u0007\u0005=rFA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u00026\u0005m\u0002c\u0001\u0018\u00028%\u0019\u0011\u0011H\u0018\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002>=\t\t\u00111\u0001\u0002,\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a\u0011\u0011\r\u0005\u0015\u00131JA\u001b\u001b\t\t9EC\u0002\u0002J=\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\ti%a\u0012\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003'\nI\u0006E\u0002/\u0003+J1!a\u00160\u0005\u001d\u0011un\u001c7fC:D\u0011\"!\u0010\u0012\u0003\u0003\u0005\r!!\u000e\u0002\r\u0015\fX/\u00197t)\u0011\t\u0019&a\u0018\t\u0013\u0005u\"#!AA\u0002\u0005U\u0012a\u0005*fMJ,7\u000f[%oI\u0016D8i\\7nC:$\u0007C\u0001\u0016\u0015'\u0011!\u0012qM\u001a\u0011\u0011\u0005%\u0014q\u000e\u001dD#\u000el!!a\u001b\u000b\u0007\u00055t&A\u0004sk:$\u0018.\\3\n\t\u0005E\u00141\u000e\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u001cDCAA2\u0003!!xn\u0015;sS:<GCAA\r\u0003\u0015\t\u0007\u000f\u001d7z)\u001d\u0019\u0017QPA@\u0003\u0003CQAN\fA\u0002aBQ!Q\fA\u0002\rCQaT\fA\u0002E\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002\b\u0006M\u0005#\u0002\u0018\u0002\n\u00065\u0015bAAF_\t1q\n\u001d;j_:\u0004bALAHq\r\u000b\u0016bAAI_\t1A+\u001e9mKNB\u0001\"!&\u0019\u0003\u0003\u0005\raY\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a'\u0011\t\u0005m\u0011QT\u0005\u0005\u0003?\u000biB\u0001\u0004PE*,7\r\u001e")
public class RefreshIndexCommand
extends IndexBaseCommand
implements Serializable {
    private final CatalogTable table;
    private final String indexName;
    private final Seq<Attribute> output;

    public static Option<Tuple3<CatalogTable, String, Seq<Attribute>>> unapply(RefreshIndexCommand refreshIndexCommand) {
        return RefreshIndexCommand$.MODULE$.unapply(refreshIndexCommand);
    }

    public static Function1<Tuple3<CatalogTable, String, Seq<Attribute>>, RefreshIndexCommand> tupled() {
        return RefreshIndexCommand$.MODULE$.tupled();
    }

    public static Function1<CatalogTable, Function1<String, Function1<Seq<Attribute>, RefreshIndexCommand>>> curried() {
        return RefreshIndexCommand$.MODULE$.curried();
    }

    public CatalogTable table() {
        return this.table;
    }

    public String indexName() {
        return this.indexName;
    }

    @Override
    public Seq<Attribute> output() {
        return this.output;
    }

    public Seq<Row> run(SparkSession sparkSession) {
        HoodieTableMetaClient metaClient = this.createHoodieTableMetaClient(this.table().identifier(), sparkSession);
        SecondaryIndexManager.getInstance().refresh(metaClient, this.indexName());
        return (Seq)Nil$.MODULE$;
    }

    public RefreshIndexCommand copy(CatalogTable table, String indexName, Seq<Attribute> output) {
        return new RefreshIndexCommand(table, indexName, output);
    }

    public CatalogTable copy$default$1() {
        return this.table();
    }

    public String copy$default$2() {
        return this.indexName();
    }

    public Seq<Attribute> copy$default$3() {
        return this.output();
    }

    public String productPrefix() {
        return "RefreshIndexCommand";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.table();
                break;
            }
            case 1: {
                object = this.indexName();
                break;
            }
            case 2: {
                object = this.output();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof RefreshIndexCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof RefreshIndexCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        RefreshIndexCommand refreshIndexCommand = (RefreshIndexCommand)x$1;
        CatalogTable catalogTable = this.table();
        CatalogTable catalogTable2 = refreshIndexCommand.table();
        if (catalogTable == null) {
            if (catalogTable2 != null) {
                return false;
            }
        } else if (!catalogTable.equals(catalogTable2)) return false;
        String string = this.indexName();
        String string2 = refreshIndexCommand.indexName();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Seq<Attribute> seq = this.output();
        Seq<Attribute> seq2 = refreshIndexCommand.output();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!refreshIndexCommand.canEqual(this)) return false;
        return true;
    }

    public RefreshIndexCommand(CatalogTable table, String indexName, Seq<Attribute> output) {
        this.table = table;
        this.indexName = indexName;
        this.output = output;
    }
}

