/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.apache.hudi.common.bootstrap.index.BootstrapIndex;
import org.apache.hudi.common.model.BootstrapFileMapping;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.exception.HoodieException;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.Procedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.hudi.command.procedures.ShowBootstrapMappingProcedure$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015b\u0001B\t\u0013\u0001\u0005BQ!\u000b\u0001\u0005\u0002)Bq\u0001\f\u0001C\u0002\u0013%Q\u0006\u0003\u00048\u0001\u0001\u0006IA\f\u0005\bq\u0001\u0011\r\u0011\"\u0003:\u0011\u0019\u0001\u0005\u0001)A\u0005u!)\u0011\t\u0001C\u0001[!)!\t\u0001C\u0001s!)1\t\u0001C!\t\")!\f\u0001C\u00057\")\u0011\u000f\u0001C!e\u001e)aO\u0005E\u0001o\u001a)\u0011C\u0005E\u0001q\")\u0011\u0006\u0004C\u0001y\"9Q\u0010\u0004b\u0001\n\u0003q\bbBA\b\u0019\u0001\u0006Ia \u0005\b\u0003#aA\u0011AA\n\u0005u\u0019\u0006n\\<C_>$8\u000f\u001e:ba6\u000b\u0007\u000f]5oOB\u0013xnY3ekJ,'BA\n\u0015\u0003)\u0001(o\\2fIV\u0014Xm\u001d\u0006\u0003+Y\tqaY8n[\u0006tGM\u0003\u0002\u00181\u0005!\u0001.\u001e3j\u0015\tI\"$A\u0002tc2T!a\u0007\u000f\u0002\u000bM\u0004\u0018M]6\u000b\u0005uq\u0012AB1qC\u000eDWMC\u0001 \u0003\ry'oZ\u0002\u0001'\r\u0001!E\n\t\u0003G\u0011j\u0011AE\u0005\u0003KI\u0011QBQ1tKB\u0013xnY3ekJ,\u0007CA\u0012(\u0013\tA#C\u0001\tQe>\u001cW\rZ;sK\n+\u0018\u000e\u001c3fe\u00061A(\u001b8jiz\"\u0012a\u000b\t\u0003G\u0001\t!\u0002U!S\u00036+E+\u0012*T+\u0005q\u0003cA\u00183i5\t\u0001GC\u00012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0004GA\u0003BeJ\f\u0017\u0010\u0005\u0002$k%\u0011aG\u0005\u0002\u0013!J|7-\u001a3ve\u0016\u0004\u0016M]1nKR,'/A\u0006Q\u0003J\u000bU*\u0012+F%N\u0003\u0013aC(V)B+Fk\u0018+Z!\u0016+\u0012A\u000f\t\u0003wyj\u0011\u0001\u0010\u0006\u0003{a\tQ\u0001^=qKNL!a\u0010\u001f\u0003\u0015M#(/^2u)f\u0004X-\u0001\u0007P+R\u0003V\u000bV0U3B+\u0005%\u0001\u0006qCJ\fW.\u001a;feN\f!b\\;uaV$H+\u001f9f\u0003\u0011\u0019\u0017\r\u001c7\u0015\u0005\u0015+\u0006c\u0001$O#:\u0011q\t\u0014\b\u0003\u0011.k\u0011!\u0013\u0006\u0003\u0015\u0002\na\u0001\u0010:p_Rt\u0014\"A\u0019\n\u00055\u0003\u0014a\u00029bG.\fw-Z\u0005\u0003\u001fB\u00131aU3r\u0015\ti\u0005\u0007\u0005\u0002S'6\t\u0001$\u0003\u0002U1\t\u0019!k\\<\t\u000bYC\u0001\u0019A,\u0002\t\u0005\u0014xm\u001d\t\u0003GaK!!\u0017\n\u0003\u001bA\u0013xnY3ekJ,\u0017I]4t\u0003i\u0019'/Z1uK\n{w\u000e^:ue\u0006\u0004\u0018J\u001c3fqJ+\u0017\rZ3s)\ta\u0016\u000e\u0005\u0002^O6\taL\u0003\u0002`A\u0006q!i\\8ugR\u0014\u0018\r]%oI\u0016D(BA1c\u0003\u0015Ig\u000eZ3y\u0015\t\u0019G-A\u0005c_>$8\u000f\u001e:ba*\u0011QMZ\u0001\u0007G>lWn\u001c8\u000b\u0005]a\u0012B\u00015_\u0005-Ie\u000eZ3y%\u0016\fG-\u001a:\t\u000b)L\u0001\u0019A6\u0002\u00155,G/Y\"mS\u0016tG\u000f\u0005\u0002m_6\tQN\u0003\u0002oI\u0006)A/\u00192mK&\u0011\u0001/\u001c\u0002\u0016\u0011>|G-[3UC\ndW-T3uC\u000ec\u0017.\u001a8u\u0003\u0015\u0011W/\u001b7e+\u0005\u0019\bCA\u0012u\u0013\t)(CA\u0005Qe>\u001cW\rZ;sK\u0006i2\u000b[8x\u0005>|Go\u001d;sCBl\u0015\r\u001d9j]\u001e\u0004&o\\2fIV\u0014X\r\u0005\u0002$\u0019M\u0011A\"\u001f\t\u0003_iL!a\u001f\u0019\u0003\r\u0005s\u0017PU3g)\u00059\u0018\u0001\u0002(B\u001b\u0016+\u0012a \t\u0005\u0003\u0003\tY!\u0004\u0002\u0002\u0004)!\u0011QAA\u0004\u0003\u0011a\u0017M\\4\u000b\u0005\u0005%\u0011\u0001\u00026bm\u0006LA!!\u0004\u0002\u0004\t11\u000b\u001e:j]\u001e\fQAT!N\u000b\u0002\nqAY;jY\u0012,'/\u0006\u0002\u0002\u0016A)\u0011qCA\u0011M5\u0011\u0011\u0011\u0004\u0006\u0005\u00037\ti\"\u0001\u0005gk:\u001cG/[8o\u0015\u0011\ty\"a\u0002\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003G\tIB\u0001\u0005TkB\u0004H.[3s\u0001")
public class ShowBootstrapMappingProcedure
extends BaseProcedure
implements ProcedureBuilder {
    private final ProcedureParameter[] PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "table", DataTypes.StringType), ProcedureParameter$.MODULE$.optional(1, "partition_path", DataTypes.StringType, ""), ProcedureParameter$.MODULE$.optional(2, "file_ids", DataTypes.StringType, ""), ProcedureParameter$.MODULE$.optional(3, "limit", DataTypes.IntegerType, BoxesRunTime.boxToInteger((int)10)), ProcedureParameter$.MODULE$.optional(4, "sort_by", DataTypes.StringType, "partition"), ProcedureParameter$.MODULE$.optional(5, "desc", DataTypes.BooleanType, BoxesRunTime.boxToBoolean((boolean)false))});
    private final StructType OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("partition", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("file_id", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("source_base_path", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("source_partition", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("source_file", DataTypes.StringType, true, Metadata$.MODULE$.empty())}));

    public static Supplier<ProcedureBuilder> builder() {
        return ShowBootstrapMappingProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return ShowBootstrapMappingProcedure$.MODULE$.NAME();
    }

    private ProcedureParameter[] PARAMETERS() {
        return this.PARAMETERS;
    }

    private StructType OUTPUT_TYPE() {
        return this.OUTPUT_TYPE;
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.PARAMETERS();
    }

    @Override
    public StructType outputType() {
        return this.OUTPUT_TYPE();
    }

    @Override
    public Seq<Row> call(ProcedureArgs args2) {
        Boolean bl;
        super.checkArgs(this.PARAMETERS(), args2);
        Option<Object> tableName = this.getArgValueOrDefault(args2, this.PARAMETERS()[0]);
        String partitionPath = (String)this.getArgValueOrDefault(args2, this.PARAMETERS()[1]).get();
        String fileIds = (String)this.getArgValueOrDefault(args2, this.PARAMETERS()[2]).get();
        int limit = BoxesRunTime.unboxToInt((Object)this.getArgValueOrDefault(args2, this.PARAMETERS()[3]).get());
        String sortBy = (String)this.getArgValueOrDefault(args2, this.PARAMETERS()[4]).get();
        boolean desc = BoxesRunTime.unboxToBoolean((Object)this.getArgValueOrDefault(args2, this.PARAMETERS()[5]).get());
        String basePath = this.getBasePath(tableName, this.getBasePath$default$2());
        HoodieTableMetaClient metaClient = this.createMetaClient(this.jsc(), basePath);
        if (partitionPath.isEmpty() && new StringOps(Predef$.MODULE$.augmentString(fileIds)).nonEmpty()) {
            throw new IllegalStateException("PartitionPath is mandatory when passing fileIds.");
        }
        BootstrapIndex.IndexReader indexReader = this.createBootstrapIndexReader(metaClient);
        List<String> indexedPartitions = indexReader.getIndexedPartitionPaths();
        Object object = new StringOps(Predef$.MODULE$.augmentString(partitionPath)).nonEmpty() && !indexedPartitions.contains(partitionPath) ? new HoodieException(new StringBuilder(34).append(partitionPath).append(" is not an valid indexed partition").toString()) : BoxedUnit.UNIT;
        ArrayList<BootstrapFileMapping> mappingList = new ArrayList<BootstrapFileMapping>();
        if (new StringOps(Predef$.MODULE$.augmentString(fileIds)).nonEmpty()) {
            List fileGroupIds = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fileIds.split(","))).toList().map((Function1 & Serializable & scala.Serializable)fileId -> new HoodieFileGroupId(partitionPath, (String)fileId), List$.MODULE$.canBuildFrom())).asJava();
            bl = BoxesRunTime.boxToBoolean((boolean)mappingList.addAll(indexReader.getSourceFileMappingForFileIds(fileGroupIds).values()));
        } else if (new StringOps(Predef$.MODULE$.augmentString(partitionPath)).nonEmpty()) {
            bl = BoxesRunTime.boxToBoolean((boolean)mappingList.addAll(indexReader.getSourceFileMappingForPartition(partitionPath)));
        } else {
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(indexedPartitions).asScala()).foreach((Function1 & Serializable & scala.Serializable)part -> BoxesRunTime.boxToBoolean((boolean)mappingList.addAll(indexReader.getSourceFileMappingForPartition(part))));
            bl = BoxedUnit.UNIT;
        }
        List rows = (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(mappingList).asScala()).map((Function1 & Serializable & scala.Serializable)mapping -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{mapping.getPartitionPath(), mapping.getFileId(), mapping.getBootstrapBasePath(), mapping.getBootstrapPartitionPath(), mapping.getBootstrapFileStatus().getPath().getUri()})), Buffer$.MODULE$.canBuildFrom())).asJava();
        Dataset df = this.spark().createDataFrame(rows, this.OUTPUT_TYPE());
        return desc ? Predef$.MODULE$.wrapRefArray((Object[])df.orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{df.apply(sortBy).desc()})).limit(limit).collect()) : Predef$.MODULE$.wrapRefArray((Object[])df.orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{df.apply(sortBy).asc()})).limit(limit).collect());
    }

    private BootstrapIndex.IndexReader createBootstrapIndexReader(HoodieTableMetaClient metaClient) {
        BootstrapIndex index = BootstrapIndex.getBootstrapIndex(metaClient);
        if (!index.useIndex()) {
            throw new HoodieException("This is not a bootstrapped Hudi table. Don't have any index info");
        }
        return index.createReader();
    }

    @Override
    public Procedure build() {
        return new ShowBootstrapMappingProcedure();
    }
}

