/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.streaming;

import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.streaming.HDFSMetadataLog;
import org.apache.spark.sql.hudi.streaming.HoodieSourceOffset;
import org.apache.spark.sql.hudi.streaming.HoodieSourceOffset$;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001y3A!\u0003\u0006\u0001/!A1\u0005\u0001B\u0001B\u0003%A\u0005\u0003\u0005)\u0001\t\u0005\t\u0015!\u0003*\u0011\u00151\u0004\u0001\"\u00018\u0011\u001dY\u0004A1A\u0005\nqBa!\u0011\u0001!\u0002\u0013i\u0004\"\u0002\"\u0001\t\u0003\u001a\u0005\"B*\u0001\t\u0003\"\u0006\"\u0002.\u0001\t\u0013Y&!\u0005%p_\u0012LW-T3uC\u0012\fG/\u0019'pO*\u00111\u0002D\u0001\ngR\u0014X-Y7j]\u001eT!!\u0004\b\u0002\t!,H-\u001b\u0006\u0003\u001fA\t1a]9m\u0015\t\t\"#A\u0003ta\u0006\u00148N\u0003\u0002\u0014)\u00051\u0011\r]1dQ\u0016T\u0011!F\u0001\u0004_J<7\u0001A\n\u0003\u0001a\u00012!G\u000f \u001b\u0005Q\"BA\u0006\u001c\u0015\tab\"A\u0005fq\u0016\u001cW\u000f^5p]&\u0011aD\u0007\u0002\u0010\u0011\u001235+T3uC\u0012\fG/\u0019'pOB\u0011\u0001%I\u0007\u0002\u0015%\u0011!E\u0003\u0002\u0013\u0011>|G-[3T_V\u00148-Z(gMN,G/\u0001\u0007ta\u0006\u00148nU3tg&|g\u000e\u0005\u0002&M5\ta\"\u0003\u0002(\u001d\ta1\u000b]1sWN+7o]5p]\u0006aQ.\u001a;bI\u0006$\u0018\rU1uQB\u0011!f\r\b\u0003WE\u0002\"\u0001L\u0018\u000e\u00035R!A\f\f\u0002\rq\u0012xn\u001c;?\u0015\u0005\u0001\u0014!B:dC2\f\u0017B\u0001\u001a0\u0003\u0019\u0001&/\u001a3fM&\u0011A'\u000e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Iz\u0013A\u0002\u001fj]&$h\bF\u00029si\u0002\"\u0001\t\u0001\t\u000b\r\u001a\u0001\u0019\u0001\u0013\t\u000b!\u001a\u0001\u0019A\u0015\u0002\u000fY+%kU%P\u001dV\tQ\b\u0005\u0002?\u007f5\tq&\u0003\u0002A_\t\u0019\u0011J\u001c;\u0002\u0011Y+%kU%P\u001d\u0002\n\u0011b]3sS\u0006d\u0017N_3\u0015\u0007\u0011;\u0015\n\u0005\u0002?\u000b&\u0011ai\f\u0002\u0005+:LG\u000fC\u0003I\r\u0001\u0007q$\u0001\u0005nKR\fG-\u0019;b\u0011\u0015Qe\u00011\u0001L\u0003\ryW\u000f\u001e\t\u0003\u0019Fk\u0011!\u0014\u0006\u0003\u001d>\u000b!![8\u000b\u0003A\u000bAA[1wC&\u0011!+\u0014\u0002\r\u001fV$\b/\u001e;TiJ,\u0017-\\\u0001\fI\u0016\u001cXM]5bY&TX\r\u0006\u0002 +\")ak\u0002a\u0001/\u0006\u0011\u0011N\u001c\t\u0003\u0019bK!!W'\u0003\u0017%s\u0007/\u001e;TiJ,\u0017-\\\u0001\u000bO\u0016$h+\u001a:tS>tGCA\u001f]\u0011\u0015i\u0006\u00021\u0001*\u0003-1XM]:j_:d\u0015N\\3")
public class HoodieMetadataLog
extends HDFSMetadataLog<HoodieSourceOffset> {
    private final int VERSION;

    private int VERSION() {
        return this.VERSION;
    }

    public void serialize(HoodieSourceOffset metadata, OutputStream out) {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8));
        writer.write(new StringBuilder(2).append("v").append(this.VERSION()).append("\n").toString());
        writer.write(metadata.json());
        writer.flush();
    }

    public HoodieSourceOffset deserialize(InputStream in) {
        String content = FileIOUtils.readAsUTFString(in);
        int firstLineEnd = content.indexOf("\n");
        if (firstLineEnd > 0) {
            int version = this.getVersion(content.substring(0, firstLineEnd));
            if (version > this.VERSION()) {
                throw new IllegalStateException(new StringBuilder(63).append("UnSupportVersion: max support version is: ").append(this.VERSION()).append(" current version is: ").append(version).toString());
            }
        } else {
            throw new IllegalStateException("Bad metadata format, failed to find the version line.");
        }
        return HoodieSourceOffset$.MODULE$.fromJson(content.substring(firstLineEnd + 1));
    }

    private int getVersion(String versionLine) {
        if (!versionLine.startsWith("v")) {
            throw new IllegalStateException(new StringBuilder(53).append("Illegal version line: ").append(versionLine).append(" ").append("in the streaming metadata path").toString());
        }
        return new StringOps(Predef$.MODULE$.augmentString(versionLine.substring(1))).toInt();
    }

    public HoodieMetadataLog(SparkSession sparkSession, String metadataPath) {
        super(sparkSession, metadataPath, ClassTag$.MODULE$.apply(HoodieSourceOffset.class));
        this.VERSION = 1;
    }
}

