/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.hudi.HoodieSparkRecordMerger;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieSparkRecord;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.merge.SparkRecordMergingUtils;

public class DefaultSparkRecordMerger
extends HoodieSparkRecordMerger {
    @Override
    public String getMergingStrategy() {
        return "eeb8d96f-b1e4-49fd-bbf8-28ac514178e5";
    }

    @Override
    public Option<Pair<HoodieRecord, Schema>> merge(HoodieRecord older, Schema oldSchema, HoodieRecord newer, Schema newSchema, TypedProperties props) throws IOException {
        HoodieSparkRecord oldSparkRecord;
        HoodieSparkRecord newSparkRecord;
        ValidationUtils.checkArgument(older.getRecordType() == HoodieRecord.HoodieRecordType.SPARK);
        ValidationUtils.checkArgument(newer.getRecordType() == HoodieRecord.HoodieRecordType.SPARK);
        if (newer instanceof HoodieSparkRecord ? (newSparkRecord = (HoodieSparkRecord)newer).isDelete(newSchema, props) : newer.getData() == null) {
            return Option.empty();
        }
        if (older instanceof HoodieSparkRecord ? (oldSparkRecord = (HoodieSparkRecord)older).isDelete(oldSchema, props) : older.getData() == null) {
            return Option.of(Pair.of(newer, newSchema));
        }
        if (older.getOrderingValue(oldSchema, props).compareTo(newer.getOrderingValue(newSchema, props)) > 0) {
            return Option.of(Pair.of(older, oldSchema));
        }
        return Option.of(Pair.of(newer, newSchema));
    }

    @Override
    public Option<Pair<HoodieRecord, Schema>> partialMerge(HoodieRecord older, Schema oldSchema, HoodieRecord newer, Schema newSchema, Schema readerSchema, TypedProperties props) throws IOException {
        HoodieSparkRecord oldSparkRecord;
        HoodieSparkRecord newSparkRecord;
        ValidationUtils.checkArgument(older.getRecordType() == HoodieRecord.HoodieRecordType.SPARK);
        ValidationUtils.checkArgument(newer.getRecordType() == HoodieRecord.HoodieRecordType.SPARK);
        if (newer instanceof HoodieSparkRecord ? (newSparkRecord = (HoodieSparkRecord)newer).isDelete(newSchema, props) : newer.getData() == null) {
            return Option.empty();
        }
        if (older instanceof HoodieSparkRecord ? (oldSparkRecord = (HoodieSparkRecord)older).isDelete(oldSchema, props) : older.getData() == null) {
            return Option.of(Pair.of(newer, newSchema));
        }
        if (older.getOrderingValue(oldSchema, props).compareTo(newer.getOrderingValue(newSchema, props)) > 0) {
            return Option.of(SparkRecordMergingUtils.mergePartialRecords((HoodieSparkRecord)newer, newSchema, (HoodieSparkRecord)older, oldSchema, readerSchema, props));
        }
        return Option.of(SparkRecordMergingUtils.mergePartialRecords((HoodieSparkRecord)older, oldSchema, (HoodieSparkRecord)newer, newSchema, readerSchema, props));
    }
}

