/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.clustering.update.strategy;

import java.util.List;
import java.util.Set;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.cluster.strategy.UpdateStrategy;

public abstract class BaseSparkUpdateStrategy<T>
extends UpdateStrategy<T, HoodieData<HoodieRecord<T>>> {
    public BaseSparkUpdateStrategy(HoodieEngineContext engineContext, HoodieTable table, Set<HoodieFileGroupId> fileGroupsInPendingClustering) {
        super(engineContext, table, fileGroupsInPendingClustering);
    }

    protected List<HoodieFileGroupId> getGroupIdsWithUpdate(HoodieData<HoodieRecord<T>> inputRecords) {
        return inputRecords.filter(record -> record.getCurrentLocation() != null).map(record -> new HoodieFileGroupId(record.getPartitionPath(), record.getCurrentLocation().getFileId())).distinct().collectAsList();
    }
}

