/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.read;

import java.io.Serializable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class HoodieReadStats
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected long numInserts;
    private long numUpdates = 0L;
    protected long numDeletes;
    protected long totalLogReadTimeMs;
    protected long totalLogRecords;
    protected long totalLogFilesCompacted;
    protected long totalLogSizeCompacted;
    protected long totalUpdatedRecordsCompacted;
    protected long totalLogBlocks;
    protected long totalCorruptLogBlock;
    protected long totalRollbackBlocks;

    public HoodieReadStats() {
    }

    public HoodieReadStats(long numInserts, long numUpdates, long numDeletes) {
        this.numInserts = numInserts;
        this.numUpdates = numUpdates;
        this.numDeletes = numDeletes;
    }

    public long getNumInserts() {
        return this.numInserts;
    }

    public long getNumUpdates() {
        return this.numUpdates;
    }

    public long getNumDeletes() {
        return this.numDeletes;
    }

    public long getTotalLogReadTimeMs() {
        return this.totalLogReadTimeMs;
    }

    public long getTotalLogRecords() {
        return this.totalLogRecords;
    }

    public long getTotalLogFilesCompacted() {
        return this.totalLogFilesCompacted;
    }

    public long getTotalUpdatedRecordsCompacted() {
        return this.totalUpdatedRecordsCompacted;
    }

    public long getTotalLogSizeCompacted() {
        return this.totalLogSizeCompacted;
    }

    public long getTotalLogBlocks() {
        return this.totalLogBlocks;
    }

    public long getTotalCorruptLogBlock() {
        return this.totalCorruptLogBlock;
    }

    public long getTotalRollbackBlocks() {
        return this.totalRollbackBlocks;
    }

    public void incrementNumInserts() {
        ++this.numInserts;
    }

    public void incrementNumUpdates() {
        ++this.numUpdates;
    }

    public void incrementNumDeletes() {
        ++this.numDeletes;
    }

    public void setTotalLogReadTimeMs(long totalLogReadTimeMs) {
        this.totalLogReadTimeMs = totalLogReadTimeMs;
    }

    public void setTotalLogRecords(long totalLogRecords) {
        this.totalLogRecords = totalLogRecords;
    }

    public void setTotalLogFilesCompacted(long totalLogFilesCompacted) {
        this.totalLogFilesCompacted = totalLogFilesCompacted;
    }

    public void setTotalUpdatedRecordsCompacted(long totalUpdatedRecordsCompacted) {
        this.totalUpdatedRecordsCompacted = totalUpdatedRecordsCompacted;
    }

    public void setTotalLogSizeCompacted(long totalLogSizeCompacted) {
        this.totalLogSizeCompacted = totalLogSizeCompacted;
    }

    public void setTotalLogBlocks(long totalLogBlocks) {
        this.totalLogBlocks = totalLogBlocks;
    }

    public void setTotalCorruptLogBlock(long totalCorruptLogBlock) {
        this.totalCorruptLogBlock = totalCorruptLogBlock;
    }

    public void setTotalRollbackBlocks(long totalRollbackBlocks) {
        this.totalRollbackBlocks = totalRollbackBlocks;
    }
}

