/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.config;

import java.util.Map;
import java.util.Properties;
import javax.annotation.concurrent.Immutable;
import org.apache.hudi.common.config.ConfigClassProperty;
import org.apache.hudi.common.config.ConfigGroups;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.table.action.ttl.strategy.PartitionTTLStrategyType;

@ConfigClassProperty(name="TTL management Configs", groupName=ConfigGroups.Names.WRITE_CLIENT, description="Data ttl management")
@Immutable
public class HoodieTTLConfig
extends HoodieConfig {
    public static final String PARTITION_TTL_STRATEGY_PARAM_PREFIX = "hoodie.partition.ttl.strategy.";
    public static final String KEEP_BY_TIME_PARTITION_TTL_STRATEGY = "org.apache.hudi.table.action.ttl.strategy.KeepByTimeStrategy";
    public static final ConfigProperty<Boolean> INLINE_PARTITION_TTL = ConfigProperty.key("hoodie.partition.ttl.inline").defaultValue(false).sinceVersion("1.0.0").markAdvanced().withDocumentation("When enabled, the partition ttl management service is invoked immediately after each commit, to delete exipired partitions");
    public static final ConfigProperty<String> PARTITION_TTL_STRATEGY_CLASS_NAME = ConfigProperty.key("hoodie.partition.ttl.strategy.class").noDefaultValue().sinceVersion("1.0.0").markAdvanced().withDocumentation("Config to provide a strategy class (subclass of PartitionTTLStrategy) to get the expired partitions");
    public static final ConfigProperty<String> PARTITION_TTL_STRATEGY_TYPE = ConfigProperty.key("hoodie.partition.ttl.management.strategy.type").defaultValue(PartitionTTLStrategyType.KEEP_BY_TIME.name()).sinceVersion("1.0.0").markAdvanced().withDocumentation("Partition ttl management strategy type to determine the strategy class");
    public static final ConfigProperty<Integer> DAYS_RETAIN = ConfigProperty.key("hoodie.partition.ttl.strategy.days.retain").defaultValue(-1).sinceVersion("1.0.0").markAdvanced().withDocumentation("Partition ttl management KEEP_BY_TIME strategy days retain");
    public static final ConfigProperty<String> PARTITION_SELECTED = ConfigProperty.key("hoodie.partition.ttl.strategy.partition.selected").noDefaultValue().markAdvanced().sinceVersion("1.0.0").withDocumentation("Partitions to manage ttl");
    public static final ConfigProperty<Integer> MAX_PARTITION_TO_DELETE = ConfigProperty.key("hoodie.partition.ttl.strategy.max.delete.partitions").defaultValue(1000).markAdvanced().sinceVersion("1.0.0").withDocumentation("max partitions to delete in partition ttl management");

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private final HoodieTTLConfig ttlConfig = new HoodieTTLConfig();

        public Builder withTTLPartitionSelected(String partitionSelected) {
            this.ttlConfig.setValue(PARTITION_SELECTED, partitionSelected);
            return this;
        }

        public Builder withTTLDaysRetain(Integer daysRetain) {
            this.ttlConfig.setValue(DAYS_RETAIN, daysRetain.toString());
            return this;
        }

        public Builder enableInlinePartitionTTL(Boolean enable) {
            this.ttlConfig.setValue(INLINE_PARTITION_TTL, enable.toString());
            return this;
        }

        public Builder withTTLStrategyClass(String clazz) {
            this.ttlConfig.setValue(PARTITION_TTL_STRATEGY_CLASS_NAME, clazz);
            return this;
        }

        public Builder withTTLStrategyType(PartitionTTLStrategyType ttlStrategyType) {
            this.ttlConfig.setValue(PARTITION_TTL_STRATEGY_TYPE, ttlStrategyType.name());
            return this;
        }

        public Builder fromProperties(Properties props) {
            this.ttlConfig.getProps().putAll((Map<?, ?>)props);
            return this;
        }

        public HoodieTTLConfig build() {
            this.ttlConfig.setDefaults(HoodieTTLConfig.class.getName());
            return this.ttlConfig;
        }
    }
}

