/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.exception.InvalidTableException;
import org.apache.hudi.exception.TableNotFoundException;
import org.apache.hudi.hadoop.utils.HoodieHiveUtils;
import org.apache.hudi.hadoop.utils.HoodieInputFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputPathHandler {
    public static final Logger LOG = LoggerFactory.getLogger(InputPathHandler.class);
    private final Configuration conf;
    private final Map<String, HoodieTableMetaClient> tableMetaClientMap;
    private final Map<HoodieTableMetaClient, List<Path>> groupedIncrementalPaths;
    private final List<Path> snapshotPaths;
    private final List<Path> nonHoodieInputPaths;
    private final boolean isIncrementalUseDatabase;

    public InputPathHandler(Configuration conf, Path[] inputPaths, List<String> incrementalTables) throws IOException {
        this.conf = conf;
        this.tableMetaClientMap = new HashMap<String, HoodieTableMetaClient>();
        this.snapshotPaths = new ArrayList<Path>();
        this.nonHoodieInputPaths = new ArrayList<Path>();
        this.groupedIncrementalPaths = new HashMap<HoodieTableMetaClient, List<Path>>();
        this.isIncrementalUseDatabase = HoodieHiveUtils.isIncrementalUseDatabase(conf);
        this.parseInputPaths(inputPaths, incrementalTables);
    }

    private void parseInputPaths(Path[] inputPaths, List<String> incrementalTables) throws IOException {
        for (Path inputPath : inputPaths) {
            boolean basePathKnown = false;
            String inputPathStr = inputPath.toString();
            for (HoodieTableMetaClient metaClient : this.tableMetaClientMap.values()) {
                String basePathStr = metaClient.getBasePath().toString();
                if (!inputPathStr.equals(basePathStr) && !inputPathStr.startsWith(basePathStr + "/")) continue;
                basePathKnown = true;
                this.tagAsIncrementalOrSnapshot(inputPath, metaClient, incrementalTables);
                break;
            }
            if (basePathKnown) continue;
            try {
                HoodieTableMetaClient metaClient = HoodieInputFormatUtils.getTableMetaClientForBasePathUnchecked(this.conf, inputPath);
                this.tableMetaClientMap.put(this.getIncrementalTable(metaClient), metaClient);
                this.tagAsIncrementalOrSnapshot(inputPath, metaClient, incrementalTables);
            }
            catch (InvalidTableException | TableNotFoundException e) {
                LOG.info("Handling a non-hoodie path " + inputPath);
                this.nonHoodieInputPaths.add(inputPath);
            }
        }
    }

    private void tagAsIncrementalOrSnapshot(Path inputPath, HoodieTableMetaClient metaClient, List<String> incrementalTables) {
        if (!incrementalTables.contains(this.getIncrementalTable(metaClient))) {
            this.snapshotPaths.add(inputPath);
        } else {
            if (!this.groupedIncrementalPaths.containsKey(metaClient)) {
                this.groupedIncrementalPaths.put(metaClient, new ArrayList());
            }
            this.groupedIncrementalPaths.get(metaClient).add(inputPath);
        }
    }

    public Map<HoodieTableMetaClient, List<Path>> getGroupedIncrementalPaths() {
        return this.groupedIncrementalPaths;
    }

    public Map<String, HoodieTableMetaClient> getTableMetaClientMap() {
        return this.tableMetaClientMap;
    }

    public List<Path> getSnapshotPaths() {
        return this.snapshotPaths;
    }

    public List<Path> getNonHoodieInputPaths() {
        return this.nonHoodieInputPaths;
    }

    private String getIncrementalTable(HoodieTableMetaClient metaClient) {
        String databaseName = metaClient.getTableConfig().getDatabaseName();
        String tableName = metaClient.getTableConfig().getTableName();
        return this.isIncrementalUseDatabase && !StringUtils.isNullOrEmpty(databaseName) ? databaseName + "." + tableName : tableName;
    }
}

