/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop.fs;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class BoundedFsDataInputStream
extends FSDataInputStream {
    private final FileSystem fs;
    private final Path file;
    private long fileLen = -1L;

    public BoundedFsDataInputStream(FileSystem fs, Path file, InputStream in) {
        super(in);
        this.fs = fs;
        this.file = file;
    }

    public boolean markSupported() {
        return false;
    }

    private long getFileLength() throws IOException {
        if (this.fileLen == -1L) {
            this.fileLen = this.fs.getContentSummary(this.file).getLength();
        }
        return this.fileLen;
    }

    public synchronized void seek(long pos) throws IOException {
        if (pos < 0L || pos > this.getFileLength()) {
            throw new EOFException("Try to seek pos[" + pos + "] , but fileSize is " + this.getFileLength());
        }
        super.seek(pos);
    }

    public synchronized long skip(long n) throws IOException {
        long fileLength;
        long curPos = this.getPos();
        if (n + curPos > (fileLength = this.getFileLength())) {
            n = fileLength - curPos;
        }
        return super.skip(n);
    }
}

