/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hudi.avro.model.HoodieRollbackMetadata;
import org.apache.hudi.client.BaseHoodieWriteClient;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieFailedWritesCleaningPolicy;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.InstantComparison;
import org.apache.hudi.common.table.timeline.versioning.v1.InstantComparatorV1;
import org.apache.hudi.common.util.CompactionUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieMetadataException;
import org.apache.hudi.metadata.HoodieBackedTableMetadataWriter;
import org.apache.hudi.metadata.HoodieTableMetadataUtil;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.storage.StorageConfiguration;

public abstract class HoodieBackedTableMetadataWriterTableVersionSix<I>
extends HoodieBackedTableMetadataWriter<I> {
    private static final int PARTITION_INITIALIZATION_TIME_SUFFIX = 10;

    protected HoodieBackedTableMetadataWriterTableVersionSix(StorageConfiguration<?> storageConf, HoodieWriteConfig writeConfig, HoodieFailedWritesCleaningPolicy failedWritesCleaningPolicy, HoodieEngineContext engineContext, Option<String> inflightInstantTimestamp) {
        super(storageConf, writeConfig, failedWritesCleaningPolicy, engineContext, inflightInstantTimestamp);
    }

    @Override
    List<MetadataPartitionType> getEnabledPartitions(HoodieMetadataConfig metadataConfig, HoodieTableMetaClient metaClient) {
        return MetadataPartitionType.getEnabledPartitions(metadataConfig, metaClient).stream().filter(partition -> !partition.equals((Object)MetadataPartitionType.SECONDARY_INDEX)).filter(partition -> !partition.equals((Object)MetadataPartitionType.EXPRESSION_INDEX)).filter(partition -> !partition.equals((Object)MetadataPartitionType.PARTITION_STATS)).collect(Collectors.toList());
    }

    @Override
    boolean shouldInitializeFromFilesystem(Set<String> pendingDataInstants, Option<String> inflightInstantTimestamp) {
        if (pendingDataInstants.stream().anyMatch(i -> !inflightInstantTimestamp.isPresent() || !i.equals(inflightInstantTimestamp.get()))) {
            this.metrics.ifPresent(m -> m.updateMetrics("bootstrap_error", 1L));
            LOG.warn("Cannot initialize metadata table as operation(s) are in progress on the dataset: {}", (Object)Arrays.toString(pendingDataInstants.toArray()));
            return false;
        }
        return true;
    }

    @Override
    String generateUniqueInstantTime(String initializationTime) {
        HoodieTimeline dataIndexTimeline = this.dataMetaClient.getActiveTimeline().filter(instant -> instant.getAction().equals("indexing"));
        if (HoodieTableMetadataUtil.isIndexingCommit(dataIndexTimeline, initializationTime)) {
            return initializationTime;
        }
        int offset = 0;
        while (true) {
            String commitInstantTime = this.createIndexInitTimestamp(initializationTime, offset);
            if (!this.metadataMetaClient.getCommitsTimeline().containsInstant(commitInstantTime)) {
                return commitInstantTime;
            }
            ++offset;
        }
    }

    private String createIndexInitTimestamp(String timestamp, int offset) {
        return String.format("%s%03d", timestamp, 10 + offset);
    }

    @Override
    String getTimelineHistoryPath() {
        return HoodieTableConfig.ARCHIVELOG_FOLDER.defaultValue();
    }

    @Override
    boolean validateCompactionScheduling(Option<String> inFlightInstantTimestamp, String latestDeltaCommitTimeInMetadataTable) {
        List<HoodieInstant> pendingInstants = this.dataMetaClient.reloadActiveTimeline().filterInflightsAndRequested().findInstantsBeforeOrEquals(latestDeltaCommitTimeInMetadataTable).getInstants();
        if (!pendingInstants.isEmpty()) {
            this.checkNumDeltaCommits(this.metadataMetaClient, this.dataWriteConfig.getMetadataConfig().getMaxNumDeltacommitsWhenPending());
            LOG.info(String.format("Cannot compact metadata table as there are %d inflight instants in data table before latest deltacommit in metadata table: %s. Inflight instants in data table: %s", pendingInstants.size(), latestDeltaCommitTimeInMetadataTable, Arrays.toString(pendingInstants.toArray())));
            return false;
        }
        Option<HoodieInstant> pendingLogCompactionInstant = this.metadataMetaClient.getActiveTimeline().filterPendingLogCompactionTimeline().firstInstant();
        Option<HoodieInstant> pendingCompactionInstant = this.metadataMetaClient.getActiveTimeline().filterPendingCompactionTimeline().firstInstant();
        if (pendingLogCompactionInstant.isPresent() || pendingCompactionInstant.isPresent()) {
            LOG.warn(String.format("Not scheduling compaction or logCompaction, since a pending compaction instant %s or logCompaction %s instant is present", pendingCompactionInstant, pendingLogCompactionInstant));
            return false;
        }
        return true;
    }

    private void checkNumDeltaCommits(HoodieTableMetaClient metaClient, int maxNumDeltaCommitsWhenPending) {
        int numDeltaCommits;
        HoodieActiveTimeline activeTimeline = metaClient.reloadActiveTimeline();
        Option<HoodieInstant> lastCompaction = activeTimeline.filterCompletedInstants().filter(s -> s.getAction().equals("commit")).lastInstant();
        int n = numDeltaCommits = lastCompaction.isPresent() ? activeTimeline.getDeltaCommitTimeline().findInstantsAfter(lastCompaction.get().requestedTime()).countInstants() : activeTimeline.getDeltaCommitTimeline().countInstants();
        if (numDeltaCommits > maxNumDeltaCommitsWhenPending) {
            throw new HoodieMetadataException(String.format("Metadata table's deltacommits exceeded %d: this is likely caused by a pending instant in the data table. Resolve the pending instant or adjust `%s`, then restart the pipeline.", maxNumDeltaCommitsWhenPending, HoodieMetadataConfig.METADATA_MAX_NUM_DELTACOMMITS_WHEN_PENDING.key()));
        }
    }

    @Override
    public void update(HoodieRollbackMetadata rollbackMetadata, String instantTime) {
        if (this.initialized && this.metadata != null) {
            String commitToRollbackInstantTime = rollbackMetadata.getCommitsRollback().get(0);
            Option<Pair<HoodieTimeline, HoodieInstant>> deltaCommitsInfo = CompactionUtils.getDeltaCommitsSinceLatestCompaction(this.metadataMetaClient.getActiveTimeline());
            HoodieInstant compactionInstant = deltaCommitsInfo.get().getValue();
            HoodieTimeline deltacommitsSinceCompaction = deltaCommitsInfo.get().getKey();
            HoodieInstant deltaCommitInstant = new HoodieInstant(HoodieInstant.State.COMPLETED, "deltacommit", commitToRollbackInstantTime, InstantComparatorV1.REQUESTED_TIME_BASED_COMPARATOR);
            this.validateRollbackVersionSix(commitToRollbackInstantTime, compactionInstant, deltacommitsSinceCompaction);
            this.processAndCommit(instantTime, () -> HoodieTableMetadataUtil.convertMetadataToRecords(this.engineContext, this.dataMetaClient, rollbackMetadata, instantTime));
            String rollbackInstantTime = this.createRollbackTimestamp(instantTime);
            if (deltacommitsSinceCompaction.containsInstant(deltaCommitInstant)) {
                LOG.info("Rolling back MDT deltacommit " + commitToRollbackInstantTime);
                if (!this.getWriteClient().rollback(commitToRollbackInstantTime, rollbackInstantTime)) {
                    throw new HoodieMetadataException("Failed to rollback deltacommit at " + commitToRollbackInstantTime);
                }
            } else {
                LOG.info("Ignoring rollback of instant {} at {}. The commit to rollback is not found in MDT", (Object)commitToRollbackInstantTime, (Object)instantTime);
            }
            this.closeInternal();
        }
    }

    private void validateRollbackVersionSix(String commitToRollbackInstantTime, HoodieInstant compactionInstant, HoodieTimeline deltacommitsSinceCompaction) {
        String compactionInstantTime;
        if (compactionInstant.getAction().equals("commit") && InstantComparison.compareTimestamps(commitToRollbackInstantTime, InstantComparison.LESSER_THAN_OR_EQUALS, compactionInstantTime = compactionInstant.requestedTime())) {
            throw new HoodieMetadataException(String.format("Commit being rolled back %s is earlier than the latest compaction %s. There are %d deltacommits after this compaction: %s", commitToRollbackInstantTime, compactionInstantTime, deltacommitsSinceCompaction.countInstants(), deltacommitsSinceCompaction.getInstants()));
        }
    }

    @Override
    void compactIfNecessary(BaseHoodieWriteClient<?, I, ?, ?> writeClient, Option<String> latestDeltaCommitTimeOpt) {
        String compactionInstantTime = this.createCompactionTimestamp(latestDeltaCommitTimeOpt.get());
        if (this.metadataMetaClient.getActiveTimeline().filterCompletedInstants().containsInstant(compactionInstantTime)) {
            LOG.info("Compaction with same {} time is already present in the timeline.", (Object)compactionInstantTime);
        } else if (writeClient.scheduleCompactionAtInstant(compactionInstantTime, Option.empty())) {
            LOG.info("Compaction is scheduled for timestamp {}", (Object)compactionInstantTime);
            writeClient.compact(compactionInstantTime);
        } else if (this.metadataWriteConfig.isLogCompactionEnabled()) {
            String logCompactionInstantTime = this.createLogCompactionTimestamp(latestDeltaCommitTimeOpt.get());
            if (this.metadataMetaClient.getActiveTimeline().filterCompletedInstants().containsInstant(logCompactionInstantTime)) {
                LOG.info("Log compaction with same {} time is already present in the timeline.", (Object)logCompactionInstantTime);
            } else if (writeClient.scheduleLogCompactionAtInstant(logCompactionInstantTime, Option.empty())) {
                LOG.info("Log compaction is scheduled for timestamp {}", (Object)logCompactionInstantTime);
                writeClient.logCompact(logCompactionInstantTime);
            }
        }
    }

    @Override
    String createCleanInstantTime(String instantTime) {
        return this.createCleanTimestamp(instantTime);
    }

    @Override
    String createRestoreInstantTime() {
        return this.createRestoreTimestamp(this.writeClient.createNewInstantTime(false));
    }

    private String createCompactionTimestamp(String timestamp) {
        return timestamp + this.getCompactionOperationSuffix();
    }

    private String createLogCompactionTimestamp(String timestamp) {
        return timestamp + this.getLogCompactionOperationSuffix();
    }

    private String createRollbackTimestamp(String timestamp) {
        return timestamp + this.getRollbackOperationSuffix();
    }

    private String createCleanTimestamp(String timestamp) {
        return timestamp + this.getCleanOperationSuffix();
    }

    private String createRestoreTimestamp(String timestamp) {
        return timestamp + this.getRestoreOperationSuffix();
    }

    private String getCompactionOperationSuffix() {
        return "001";
    }

    private String getLogCompactionOperationSuffix() {
        return "005";
    }

    private String getRollbackOperationSuffix() {
        return "006";
    }

    private String getCleanOperationSuffix() {
        return "002";
    }

    private String getRestoreOperationSuffix() {
        return "003";
    }
}

