/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.hudi.client.BaseHoodieWriteClient;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.EngineType;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.metrics.Registry;
import org.apache.hudi.common.model.HoodieFailedWritesCleaningPolicy;
import org.apache.hudi.common.model.HoodieIndexDefinition;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.CommitUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.data.HoodieJavaRDD;
import org.apache.hudi.exception.HoodieNotSupportedException;
import org.apache.hudi.index.HoodieSparkIndexClient;
import org.apache.hudi.metadata.HoodieBackedTableMetadataWriterTableVersionSix;
import org.apache.hudi.metadata.HoodieMetadataMetrics;
import org.apache.hudi.metadata.HoodieTableMetadataWriter;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.metadata.SparkHoodieBackedTableMetadataWriter;
import org.apache.hudi.metadata.SparkHoodieMetadataBulkInsertPartitioner;
import org.apache.hudi.metrics.DistributedRegistry;
import org.apache.hudi.metrics.MetricsReporterType;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.table.HoodieSparkTable;
import org.apache.hudi.table.HoodieTable;
import org.apache.spark.api.java.JavaRDD;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkHoodieBackedTableMetadataWriterTableVersionSix
extends HoodieBackedTableMetadataWriterTableVersionSix<JavaRDD<HoodieRecord>> {
    private static final Logger LOG = LoggerFactory.getLogger(SparkHoodieBackedTableMetadataWriter.class);

    public static HoodieTableMetadataWriter create(StorageConfiguration<?> conf, HoodieWriteConfig writeConfig, HoodieEngineContext context, Option<String> inflightInstantTimestamp) {
        return new SparkHoodieBackedTableMetadataWriterTableVersionSix(conf, writeConfig, HoodieFailedWritesCleaningPolicy.EAGER, context, inflightInstantTimestamp);
    }

    public static HoodieTableMetadataWriter create(StorageConfiguration<?> conf, HoodieWriteConfig writeConfig, HoodieFailedWritesCleaningPolicy failedWritesCleaningPolicy, HoodieEngineContext context, Option<String> inflightInstantTimestamp) {
        return new SparkHoodieBackedTableMetadataWriterTableVersionSix(conf, writeConfig, failedWritesCleaningPolicy, context, inflightInstantTimestamp);
    }

    public static HoodieTableMetadataWriter create(StorageConfiguration<?> conf, HoodieWriteConfig writeConfig, HoodieEngineContext context) {
        return SparkHoodieBackedTableMetadataWriterTableVersionSix.create(conf, writeConfig, context, Option.empty());
    }

    SparkHoodieBackedTableMetadataWriterTableVersionSix(StorageConfiguration<?> hadoopConf, HoodieWriteConfig writeConfig, HoodieFailedWritesCleaningPolicy failedWritesCleaningPolicy, HoodieEngineContext engineContext, Option<String> inflightInstantTimestamp) {
        super(hadoopConf, writeConfig, failedWritesCleaningPolicy, engineContext, inflightInstantTimestamp);
    }

    @Override
    protected void initRegistry() {
        if (this.metadataWriteConfig.isMetricsOn()) {
            if (this.metadataWriteConfig.isExecutorMetricsEnabled() && this.metadataWriteConfig.getMetricsReporterType() != MetricsReporterType.INMEMORY) {
                Registry registry = Registry.getRegistry("HoodieMetadata", DistributedRegistry.class.getName());
                HoodieSparkEngineContext sparkEngineContext = (HoodieSparkEngineContext)this.engineContext;
                ((DistributedRegistry)registry).register(sparkEngineContext.getJavaSparkContext());
            } else {
                Registry registry = Registry.getRegistry("HoodieMetadata");
            }
            this.metrics = Option.of(new HoodieMetadataMetrics(this.metadataWriteConfig.getMetricsConfig(), this.dataMetaClient.getStorage()));
        } else {
            this.metrics = Option.empty();
        }
    }

    @Override
    protected void commit(String instantTime, Map<String, HoodieData<HoodieRecord>> partitionRecordsMap) {
        this.commitInternal(instantTime, partitionRecordsMap, false, Option.empty());
    }

    @Override
    protected JavaRDD<HoodieRecord> convertHoodieDataToEngineSpecificData(HoodieData<HoodieRecord> records) {
        return HoodieJavaRDD.getJavaRDD(records);
    }

    @Override
    protected void bulkCommit(String instantTime, String partitionName, HoodieData<HoodieRecord> records, int fileGroupCount) {
        SparkHoodieMetadataBulkInsertPartitioner partitioner = new SparkHoodieMetadataBulkInsertPartitioner(fileGroupCount);
        this.commitInternal(instantTime, Collections.singletonMap(partitionName, records), true, Option.of(partitioner));
    }

    @Override
    public void deletePartitions(String instantTime, List<MetadataPartitionType> partitions) {
        List<String> partitionsToDrop = partitions.stream().map(MetadataPartitionType::getPartitionPath).collect(Collectors.toList());
        LOG.info("Deleting Metadata Table partitions: {}", partitionsToDrop);
        SparkRDDWriteClient writeClient = (SparkRDDWriteClient)this.getWriteClient();
        String actionType = CommitUtils.getCommitActionType(WriteOperationType.DELETE_PARTITION, HoodieTableType.MERGE_ON_READ);
        writeClient.startCommitWithTime(instantTime, actionType);
        writeClient.deletePartitions(partitionsToDrop, instantTime);
    }

    @Override
    protected HoodieTable getTable(HoodieWriteConfig writeConfig, HoodieTableMetaClient metaClient) {
        return HoodieSparkTable.create(writeConfig, this.engineContext, metaClient);
    }

    @Override
    public BaseHoodieWriteClient<?, JavaRDD<HoodieRecord>, ?, ?> initializeWriteClient() {
        return new SparkRDDWriteClient(this.engineContext, this.metadataWriteConfig, Option.empty());
    }

    @Override
    protected EngineType getEngineType() {
        return EngineType.SPARK;
    }

    @Override
    protected void updateColumnsToIndexWithColStats(List<String> columnsToIndex) {
        new HoodieSparkIndexClient(this.dataWriteConfig, this.engineContext).createOrUpdateColumnStatsIndexDefinition(this.dataMetaClient, columnsToIndex);
    }

    @Override
    protected HoodieData<HoodieRecord> getExpressionIndexRecords(List<Pair<String, Pair<String, Long>>> partitionFilePathAndSizeTriplet, HoodieIndexDefinition indexDefinition, HoodieTableMetaClient metaClient, int parallelism, Schema readerSchema, StorageConfiguration<?> storageConf, String instantTime) {
        throw new HoodieNotSupportedException("Expression index not supported for Java metadata table writer yet.");
    }
}

