/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.commons.io;

import java.time.Duration;
import org.apache.hudi.org.apache.commons.io.ThreadUtils;

final class ThreadMonitor
implements Runnable {
    private final Thread thread;
    private final Duration timeout;

    static Thread start(Duration timeout) {
        return ThreadMonitor.start(Thread.currentThread(), timeout);
    }

    static Thread start(Thread thread2, Duration timeout) {
        if (timeout.isZero() || timeout.isNegative()) {
            return null;
        }
        Thread monitor = new Thread((Runnable)new ThreadMonitor(thread2, timeout), ThreadMonitor.class.getSimpleName());
        monitor.setDaemon(true);
        monitor.start();
        return monitor;
    }

    static void stop(Thread thread2) {
        if (thread2 != null) {
            thread2.interrupt();
        }
    }

    private ThreadMonitor(Thread thread2, Duration timeout) {
        this.thread = thread2;
        this.timeout = timeout;
    }

    @Override
    public void run() {
        try {
            ThreadUtils.sleep(this.timeout);
            this.thread.interrupt();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

