/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.deltacommit;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieUpsertException;
import org.apache.hudi.execution.SparkLazyInsertIterable;
import org.apache.hudi.io.AppendHandleFactory;
import org.apache.hudi.io.HoodieAppendHandle;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.WorkloadProfile;
import org.apache.hudi.table.action.commit.BaseSparkCommitActionExecutor;
import org.apache.hudi.table.action.deltacommit.SparkUpsertDeltaCommitPartitioner;
import org.apache.spark.Partitioner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseSparkDeltaCommitActionExecutor<T>
extends BaseSparkCommitActionExecutor<T> {
    private static final Logger LOG = LoggerFactory.getLogger(BaseSparkDeltaCommitActionExecutor.class);
    private SparkUpsertDeltaCommitPartitioner<T> mergeOnReadUpsertPartitioner;

    public BaseSparkDeltaCommitActionExecutor(HoodieSparkEngineContext context, HoodieWriteConfig config, HoodieTable table, String instantTime, WriteOperationType operationType) {
        this(context, config, table, instantTime, operationType, Option.empty());
    }

    public BaseSparkDeltaCommitActionExecutor(HoodieSparkEngineContext context, HoodieWriteConfig config, HoodieTable table, String instantTime, WriteOperationType operationType, Option<Map<String, String>> extraMetadata) {
        super((HoodieEngineContext)context, config, table, instantTime, operationType, extraMetadata);
    }

    @Override
    public Partitioner getUpsertPartitioner(WorkloadProfile profile) {
        if (profile == null) {
            throw new HoodieUpsertException("Need workload profile to construct the upsert partitioner.");
        }
        this.mergeOnReadUpsertPartitioner = new SparkUpsertDeltaCommitPartitioner(profile, (HoodieSparkEngineContext)this.context, this.table, this.config, this.operationType);
        return this.mergeOnReadUpsertPartitioner;
    }

    @Override
    public Iterator<List<WriteStatus>> handleUpdate(String partitionPath, String fileId, Iterator<HoodieRecord<T>> recordItr) throws IOException {
        LOG.info("Merging updates for commit " + this.instantTime + " for file " + fileId);
        if (!this.table.getIndex().canIndexLogFiles() && this.mergeOnReadUpsertPartitioner != null && this.mergeOnReadUpsertPartitioner.getSmallFileIds().contains(fileId)) {
            LOG.info("Small file corrections for updates for commit " + this.instantTime + " for file " + fileId);
            return super.handleUpdate(partitionPath, fileId, recordItr);
        }
        HoodieAppendHandle appendHandle = new HoodieAppendHandle(this.config, this.instantTime, this.table, partitionPath, fileId, recordItr, this.taskContextSupplier);
        appendHandle.doAppend();
        return Collections.singletonList(appendHandle.close()).iterator();
    }

    @Override
    public Iterator<List<WriteStatus>> handleInsert(String idPfx, Iterator<HoodieRecord<T>> recordItr) {
        if (this.table.getIndex().canIndexLogFiles()) {
            return new SparkLazyInsertIterable<T>(recordItr, true, this.config, this.instantTime, this.table, idPfx, this.taskContextSupplier, new AppendHandleFactory());
        }
        return super.handleInsert(idPfx, recordItr);
    }
}

