/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.Functions;
import org.apache.hudi.common.util.hash.BucketIndexUtil;
import org.apache.hudi.index.bucket.BucketIdentifier;
import org.apache.spark.Partitioner;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class BucketPartitionUtils$ {
    public static BucketPartitionUtils$ MODULE$;

    static {
        new BucketPartitionUtils$();
    }

    public Dataset<Row> createDataFrame(Dataset<Row> df, String indexKeyFields, int bucketNum, int partitionNum) {
        Function1 getPartitionKey = BucketPartitionUtils$.getPartitionKeyExtractor$1(indexKeyFields, bucketNum);
        Partitioner partitioner = new Partitioner(bucketNum, partitionNum){
            private final Functions.Function2<String, Integer, Integer> partitionIndexFunc;
            private final int partitionNum$1;

            private Functions.Function2<String, Integer, Integer> partitionIndexFunc() {
                return this.partitionIndexFunc;
            }

            public int numPartitions() {
                return this.partitionNum$1;
            }

            public int getPartition(Object value) {
                Tuple2 partitionKeyPair = (Tuple2)value;
                return Predef$.MODULE$.Integer2int(this.partitionIndexFunc().apply((String)partitionKeyPair._1(), Predef$.MODULE$.int2Integer(partitionKeyPair._2$mcI$sp())));
            }
            {
                this.partitionNum$1 = partitionNum$1;
                this.partitionIndexFunc = BucketIndexUtil.getPartitionIndexFunc(bucketNum$1, partitionNum$1);
            }
        };
        RDD reRdd = RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToOrderedRDDFunctions(df.queryExecution().toRdd().keyBy((Function1 & Serializable & scala.Serializable)row -> (Tuple2)getPartitionKey.apply(row)), Ordering$.MODULE$.Tuple2((Ordering)Ordering.String$.MODULE$, (Ordering)Ordering.Int$.MODULE$), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.apply(InternalRow.class)).repartitionAndSortWithinPartitions(partitioner), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.apply(InternalRow.class), Ordering$.MODULE$.Tuple2((Ordering)Ordering.String$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).values();
        return df.sparkSession().internalCreateDataFrame(reRdd, df.schema(), df.sparkSession().internalCreateDataFrame$default$3());
    }

    private static final Function1 getPartitionKeyExtractor$1(String indexKeyFields$1, int bucketNum$1) {
        return (Function1 & Serializable & scala.Serializable)row -> {
            int kb = BucketIdentifier.getBucketId(row.getString(HoodieRecord.RECORD_KEY_META_FIELD_ORD), indexKeyFields$1, bucketNum$1);
            String partition = row.getString(HoodieRecord.PARTITION_PATH_META_FIELD_ORD);
            return partition == null || partition.trim().isEmpty() ? new Tuple2((Object)"", (Object)BoxesRunTime.boxToInteger((int)kb)) : new Tuple2((Object)partition, (Object)BoxesRunTime.boxToInteger((int)kb));
        };
    }

    private BucketPartitionUtils$() {
        MODULE$ = this;
    }
}

