/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.util.Map;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.MatchError;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class HoodieDataTypeUtils$ {
    public static HoodieDataTypeUtils$ MODULE$;
    private final Logger log;

    static {
        new HoodieDataTypeUtils$();
    }

    private Logger log() {
        return this.log;
    }

    public StructType parseStructTypeFromJson(String jsonSchema) {
        return StructType$.MODULE$.fromString(jsonSchema);
    }

    public boolean canUseRowWriter(Schema schema, Configuration conf) {
        boolean bl;
        if (conf.getBoolean("parquet.avro.write-old-list-structure", true)) {
            bl = true;
        } else if (!HoodieAvroUtils.hasSmallPrecisionDecimalField(schema)) {
            bl = true;
        } else if (HoodieAvroUtils.hasListOrMapField(schema)) {
            this.log().warn("Cannot use row writer due to presence of list or map with a small precision decimal field");
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    public void tryOverrideParquetWriteLegacyFormatProperty(Map<String, String> properties, StructType schema) {
        this.tryOverrideParquetWriteLegacyFormatProperty((Either<Map<String, String>, TypedProperties>)package$.MODULE$.Left().apply(properties), AvroConversionUtils$.MODULE$.convertStructTypeToAvroSchema((DataType)schema, "struct", "hoodie.source"));
    }

    public void tryOverrideParquetWriteLegacyFormatProperty(TypedProperties properties, Schema schema) {
        this.tryOverrideParquetWriteLegacyFormatProperty((Either<Map<String, String>, TypedProperties>)package$.MODULE$.Right().apply((Object)properties), schema);
    }

    private void tryOverrideParquetWriteLegacyFormatProperty(Either<Map<String, String>, TypedProperties> properties, Schema schema) {
        Object object;
        Either<Map<String, String>, TypedProperties> either = properties;
        if (either instanceof Left) {
            Left left = (Left)either;
            Map map = (Map)left.value();
            object = map.get(HoodieStorageConfig.PARQUET_WRITE_LEGACY_FORMAT_ENABLED.key());
        } else if (either instanceof Right) {
            Right right = (Right)either;
            TypedProperties typedProps = (TypedProperties)right.value();
            object = typedProps.get(HoodieStorageConfig.PARQUET_WRITE_LEGACY_FORMAT_ENABLED.key());
        } else {
            throw new MatchError(either);
        }
        Object legacyFormatEnabledProp = object;
        if (legacyFormatEnabledProp == null && HoodieAvroUtils.hasSmallPrecisionDecimalField(schema)) {
            this.log().warn("Small Decimal Type found in the persisted schema, reverting default value of 'hoodie.parquet.writelegacyformat.enabled' to true");
            Either<Map<String, String>, TypedProperties> either2 = properties;
            if (either2 instanceof Left) {
                Left left = (Left)either2;
                Map map = (Map)left.value();
                map.put(HoodieStorageConfig.PARQUET_WRITE_LEGACY_FORMAT_ENABLED.key(), "true");
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (either2 instanceof Right) {
                Right right = (Right)either2;
                TypedProperties typedProps = (TypedProperties)right.value();
                typedProps.put(HoodieStorageConfig.PARQUET_WRITE_LEGACY_FORMAT_ENABLED.key(), "true");
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError(either2);
            }
        }
    }

    private HoodieDataTypeUtils$() {
        MODULE$ = this;
        this.log = LoggerFactory.getLogger(this.getClass());
    }
}

