/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.Serializable;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.HoodieBaseRelation$;
import org.apache.hudi.HoodiePartitionFileSliceMapping;
import org.apache.hudi.HoodieTableSchema;
import org.apache.hudi.HoodieTableState;
import org.apache.hudi.LogFileIterator;
import org.apache.hudi.MergeOnReadSnapshotRelation$;
import org.apache.hudi.RecordMergingFileIterator;
import org.apache.hudi.SparkAdapterSupport;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.storage.StoragePath;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.HoodieCatalystExpressionUtils$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.expressions.JoinedRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.orc.OrcFileFormat;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat;
import org.apache.spark.sql.hudi.SparkAdapter;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.util.SerializableConfiguration;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t\u001df\u0001\u0002\u0012$\u0001AB\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!\u0012\u0005\t\u001d\u0002\u0011\t\u0011)A\u0005\u001f\"A1\u000b\u0001B\u0001B\u0003%A\u000b\u0003\u0005`\u0001\t\u0005\t\u0015!\u0003U\u0011!\u0001\u0007A!A!\u0002\u0013\t\u0007\u0002\u00036\u0001\u0005\u0003\u0005\u000b\u0011B6\t\u00119\u0004!\u0011!Q\u0001\n-D\u0001b\u001c\u0001\u0003\u0002\u0003\u0006I\u0001\u001d\u0005\u0006o\u0002!\t\u0001\u001f\u0005\n\u0003\u000b\u0001!\u0019!C\u0005\u0003\u000fA\u0001\"!\u0006\u0001A\u0003%\u0011\u0011\u0002\u0005\n\u0003/\u0001!\u0019!C\u0005\u00033A\u0001\"a\n\u0001A\u0003%\u00111\u0004\u0005\b\u0003S\u0001A\u0011IA\u0016\u0011\u001d\tY\u0007\u0001C!\u0003[B\u0011\"! \u0001\u0001\u0004%\t!a \t\u0013\u0005\u0005\u0005\u00011A\u0005\u0002\u0005\r\u0005bBAH\u0001\u0001\u0006Ka\u001b\u0005\n\u0003#\u0003\u0001\u0019!C\u0005\u0003\u007fB\u0011\"a%\u0001\u0001\u0004%I!!&\t\u000f\u0005e\u0005\u0001)Q\u0005W\"I\u00111\u0014\u0001A\u0002\u0013%\u0011q\u0010\u0005\n\u0003;\u0003\u0001\u0019!C\u0005\u0003?Cq!a)\u0001A\u0003&1\u000eC\u0004\u0002&\u0002!\t%a*\t\u000f\u0005=\u0006\u0001\"\u0011\u00022\"9\u0011\u0011\u001b\u0001\u0005B\u0005M\u0007b\u0002B\u000b\u0001\u0011E!q\u0003\u0005\b\u0005c\u0001A\u0011\u0003B\u001a\u0011\u001d\u0011)\b\u0001C\t\u0005oBqA!\"\u0001\t#\u00119\tC\u0004\u0003\u0012\u0002!\tBa%\t\u000f\t}\u0005\u0001\"\u0003\u0003\"\na\u0002j\\8eS\u0016lU\u000f\u001c;ja2,')Y:f\r&dWMR8s[\u0006$(B\u0001\u0013&\u0003-!\u0017\r^1t_V\u00148-Z:\u000b\u0005\u0019:\u0013!C3yK\u000e,H/[8o\u0015\tA\u0013&A\u0002tc2T!AK\u0016\u0002\u000bM\u0004\u0018M]6\u000b\u00051j\u0013AB1qC\u000eDWMC\u0001/\u0003\ry'oZ\u0002\u0001'\u0015\u0001\u0011gN\u001eB!\t\u0011T'D\u00014\u0015\u0005!\u0014!B:dC2\f\u0017B\u0001\u001c4\u0005\u0019\te.\u001f*fMB\u0011\u0001(O\u0007\u0002G%\u0011!h\t\u0002\u000b\r&dWMR8s[\u0006$\bC\u0001\u001f@\u001b\u0005i$B\u0001 ,\u0003\u0011AW\u000fZ5\n\u0005\u0001k$aE*qCJ\\\u0017\tZ1qi\u0016\u00148+\u001e9q_J$\bC\u0001\u001aC\u0013\t\u00195G\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0006uC\ndWm\u0015;bi\u0016\u00042AR%L\u001b\u00059%B\u0001%*\u0003%\u0011'o\\1eG\u0006\u001cH/\u0003\u0002K\u000f\nI!I]8bI\u000e\f7\u000f\u001e\t\u0003y1K!!T\u001f\u0003!!{w\u000eZ5f)\u0006\u0014G.Z*uCR,\u0017a\u0003;bE2,7k\u00195f[\u0006\u00042AR%Q!\ta\u0014+\u0003\u0002S{\t\t\u0002j\\8eS\u0016$\u0016M\u00197f'\u000eDW-\\1\u0002\u0013Q\f'\r\\3OC6,\u0007CA+]\u001d\t1&\f\u0005\u0002Xg5\t\u0001L\u0003\u0002Z_\u00051AH]8pizJ!aW\u001a\u0002\rA\u0013X\rZ3g\u0013\tifL\u0001\u0004TiJLgn\u001a\u0006\u00037N\n\u0011\"\\3sO\u0016$\u0016\u0010]3\u0002\u001f5\fg\u000eZ1u_JLh)[3mIN\u00042AY4U\u001d\t\u0019WM\u0004\u0002XI&\tA'\u0003\u0002gg\u00059\u0001/Y2lC\u001e,\u0017B\u00015j\u0005\r\u0019V-\u001d\u0006\u0003MN\nQ![:N\u001fJ\u0003\"A\r7\n\u00055\u001c$a\u0002\"p_2,\u0017M\\\u0001\u000eSNLen\u0019:f[\u0016tG/\u00197\u0002\u001fI,\u0017/^5sK\u00124\u0015\u000e\u001c;feN\u00042AY4r!\t\u0011X/D\u0001t\u0015\t!x%A\u0004t_V\u00148-Z:\n\u0005Y\u001c(A\u0002$jYR,'/\u0001\u0004=S:LGO\u0010\u000b\fsj\\H0 @\u0000\u0003\u0003\t\u0019\u0001\u0005\u00029\u0001!)A)\u0003a\u0001\u000b\")a*\u0003a\u0001\u001f\")1+\u0003a\u0001)\")q,\u0003a\u0001)\")\u0001-\u0003a\u0001C\")!.\u0003a\u0001W\")a.\u0003a\u0001W\")q.\u0003a\u0001a\u0006i\u0001/\u0019:rk\u0016$hi\u001c:nCR,\"!!\u0003\u0011\t\u0005-\u0011\u0011C\u0007\u0003\u0003\u001bQ1!a\u0004$\u0003\u001d\u0001\u0018M]9vKRLA!a\u0005\u0002\u000e\t\t\u0002+\u0019:rk\u0016$h)\u001b7f\r>\u0014X.\u0019;\u0002\u001dA\f'/];fi\u001a{'/\\1uA\u0005IqN]2G_Jl\u0017\r^\u000b\u0003\u00037\u0001B!!\b\u0002$5\u0011\u0011q\u0004\u0006\u0004\u0003C\u0019\u0013aA8sG&!\u0011QEA\u0010\u00055y%o\u0019$jY\u00164uN]7bi\u0006QqN]2G_Jl\u0017\r\u001e\u0011\u0002\u0017%tg-\u001a:TG\",W.\u0019\u000b\t\u0003[\ty$a\u0013\u0002VA)!'a\f\u00024%\u0019\u0011\u0011G\u001a\u0003\r=\u0003H/[8o!\u0011\t)$a\u000f\u000e\u0005\u0005]\"bAA\u001dO\u0005)A/\u001f9fg&!\u0011QHA\u001c\u0005)\u0019FO];diRK\b/\u001a\u0005\b\u0003\u0003r\u0001\u0019AA\"\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o!\u0011\t)%a\u0012\u000e\u0003\u001dJ1!!\u0013(\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0011\u001d\tiE\u0004a\u0001\u0003\u001f\nqa\u001c9uS>t7\u000fE\u0003V\u0003#\"F+C\u0002\u0002Ty\u00131!T1q\u0011\u001d\t9F\u0004a\u0001\u00033\nQAZ5mKN\u0004BAY4\u0002\\A!\u0011QLA4\u001b\t\tyF\u0003\u0003\u0002b\u0005\r\u0014A\u00014t\u0015\r\t)gK\u0001\u0007Q\u0006$wn\u001c9\n\t\u0005%\u0014q\f\u0002\u000b\r&dWm\u0015;biV\u001c\u0018aC5t'Bd\u0017\u000e^1cY\u0016$ra[A8\u0003c\n\u0019\bC\u0004\u0002B=\u0001\r!a\u0011\t\u000f\u00055s\u00021\u0001\u0002P!9\u0011QO\bA\u0002\u0005]\u0014\u0001\u00029bi\"\u0004B!!\u0018\u0002z%!\u00111PA0\u0005\u0011\u0001\u0016\r\u001e5\u0002\u0017%\u001c\bK]8kK\u000e$X\rZ\u000b\u0002W\u0006y\u0011n\u001d)s_*,7\r^3e?\u0012*\u0017\u000f\u0006\u0003\u0002\u0006\u0006-\u0005c\u0001\u001a\u0002\b&\u0019\u0011\u0011R\u001a\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003\u001b\u000b\u0012\u0011!a\u0001W\u0006\u0019\u0001\u0010J\u0019\u0002\u0019%\u001c\bK]8kK\u000e$X\r\u001a\u0011\u0002%M,\b\u000f]8si\n\u000bGo\u00195DC2dW\rZ\u0001\u0017gV\u0004\bo\u001c:u\u0005\u0006$8\r[\"bY2,Gm\u0018\u0013fcR!\u0011QQAL\u0011!\ti\tFA\u0001\u0002\u0004Y\u0017aE:vaB|'\u000f\u001e\"bi\u000eD7)\u00197mK\u0012\u0004\u0013AE:vaB|'\u000f\u001e\"bi\u000eD'+Z:vYR\fac];qa>\u0014HOQ1uG\"\u0014Vm];mi~#S-\u001d\u000b\u0005\u0003\u000b\u000b\t\u000b\u0003\u0005\u0002\u000e^\t\t\u00111\u0001l\u0003M\u0019X\u000f\u001d9peR\u0014\u0015\r^2i%\u0016\u001cX\u000f\u001c;!\u00031\u0019X\u000f\u001d9peR\u0014\u0015\r^2i)\u0015Y\u0017\u0011VAV\u0011\u001d\t\t%\u0007a\u0001\u0003\u0007Bq!!,\u001a\u0001\u0004\t\u0019$\u0001\u0004tG\",W.Y\u0001\raJ,\u0007/\u0019:f/JLG/\u001a\u000b\u000b\u0003g\u000bI,a/\u0002L\u00065\u0007c\u0001\u001d\u00026&\u0019\u0011qW\u0012\u0003'=+H\u000f];u/JLG/\u001a:GC\u000e$xN]=\t\u000f\u0005\u0005#\u00041\u0001\u0002D!9\u0011Q\u0018\u000eA\u0002\u0005}\u0016a\u00016pEB!\u0011\u0011YAd\u001b\t\t\u0019M\u0003\u0003\u0002F\u0006\r\u0014!C7baJ,G-^2f\u0013\u0011\tI-a1\u0003\u0007){'\rC\u0004\u0002Ni\u0001\r!a\u0014\t\u000f\u0005='\u00041\u0001\u00024\u0005QA-\u0019;b'\u000eDW-\\1\u0002=\t,\u0018\u000e\u001c3SK\u0006$WM],ji\"\u0004\u0016M\u001d;ji&|gNV1mk\u0016\u001cH\u0003EAk\u0003g\f)0a>\u0002|\u0006}(1\u0001B\u0003!\u001d\u0011\u0014q[An\u0003CL1!!74\u0005%1UO\\2uS>t\u0017\u0007E\u00029\u0003;L1!a8$\u0005=\u0001\u0016M\u001d;ji&|g.\u001a3GS2,\u0007#\u00022\u0002d\u0006\u001d\u0018bAAsS\nA\u0011\n^3sCR|'\u000f\u0005\u0003\u0002j\u0006=XBAAv\u0015\r\tioJ\u0001\tG\u0006$\u0018\r\\=ti&!\u0011\u0011_Av\u0005-Ie\u000e^3s]\u0006d'k\\<\t\u000f\u0005\u00053\u00041\u0001\u0002D!9\u0011qZ\u000eA\u0002\u0005M\u0002bBA}7\u0001\u0007\u00111G\u0001\u0010a\u0006\u0014H/\u001b;j_:\u001c6\r[3nC\"9\u0011Q`\u000eA\u0002\u0005M\u0012A\u0004:fcVL'/\u001a3TG\",W.\u0019\u0005\u0007\u0005\u0003Y\u0002\u0019\u00019\u0002\u000f\u0019LG\u000e^3sg\"9\u0011QJ\u000eA\u0002\u0005=\u0003b\u0002B\u00047\u0001\u0007!\u0011B\u0001\u000bQ\u0006$wn\u001c9D_:4\u0007\u0003\u0002B\u0006\u0005#i!A!\u0004\u000b\t\t=\u00111M\u0001\u0005G>tg-\u0003\u0003\u0003\u0014\t5!!D\"p]\u001aLw-\u001e:bi&|g.\u0001\tck&dGMR5mKJ+\u0017\rZ3sgR\u0011\"\u0011\u0004B\u0010\u0005C\u0011\u0019C!\n\u0003(\t%\"1\u0006B\u0017!-\u0011$1DAk\u0003+\f).!6\n\u0007\tu1G\u0001\u0004UkBdW\r\u000e\u0005\b\u0003\u0003b\u0002\u0019AA\"\u0011\u001d\ty\r\ba\u0001\u0003gAq!!?\u001d\u0001\u0004\t\u0019\u0004C\u0004\u0002~r\u0001\r!a\r\t\r\t\u0005A\u00041\u0001q\u0011\u001d\ti\u0005\ba\u0001\u0003\u001fBqAa\u0002\u001d\u0001\u0004\u0011I\u0001C\u0004\u00030q\u0001\r!a\r\u00027I,\u0017/^5sK\u0012\u001c6\r[3nC^KG\u000f['b]\u0012\fGo\u001c:z\u0003a\u0011W/\u001b7e\u001b\u0016\u0014x-Z(o%\u0016\fG-\u0013;fe\u0006$xN\u001d\u000b\u0015\u0003C\u0014)D!\u000f\u0003T\t\r$q\rB5\u0005[\u0012yGa\u001d\t\u000f\t]R\u00041\u0001\u0002b\u0006!\u0011\u000e^3s\u0011\u001d\u0011Y$\ba\u0001\u0005{\t\u0001\u0002\\8h\r&dWm\u001d\t\u0006E\n}\"1I\u0005\u0004\u0005\u0003J'\u0001\u0002'jgR\u0004BA!\u0012\u0003P5\u0011!q\t\u0006\u0005\u0005\u0013\u0012Y%A\u0003n_\u0012,GNC\u0002\u0003Nu\naaY8n[>t\u0017\u0002\u0002B)\u0005\u000f\u0012Q\u0002S8pI&,Gj\\4GS2,\u0007b\u0002B+;\u0001\u0007!qK\u0001\u000ea\u0006\u0014H/\u001b;j_:\u0004\u0016\r\u001e5\u0011\t\te#qL\u0007\u0003\u00057R1A!\u0018>\u0003\u001d\u0019Ho\u001c:bO\u0016LAA!\u0019\u0003\\\tY1\u000b^8sC\u001e,\u0007+\u0019;i\u0011\u001d\u0011)'\ba\u0001\u0003g\t1\"\u001b8qkR\u001c6\r[3nC\"9!qF\u000fA\u0002\u0005M\u0002b\u0002B6;\u0001\u0007\u00111G\u0001\r_V$\b/\u001e;TG\",W.\u0019\u0005\b\u0003sl\u0002\u0019AA\u001a\u0011\u001d\u0011\t(\ba\u0001\u0003O\fq\u0002]1si&$\u0018n\u001c8WC2,Xm\u001d\u0005\b\u0005\u000fi\u0002\u0019\u0001B\u0005\u0003e\t\u0007\u000f]3oIB\u000b'\u000f^5uS>t\u0017I\u001c3Qe>TWm\u0019;\u0015\u0019\u0005\u0005(\u0011\u0010B>\u0005{\u0012yHa!\t\u000f\t]b\u00041\u0001\u0002b\"9!Q\r\u0010A\u0002\u0005M\u0002bBA}=\u0001\u0007\u00111\u0007\u0005\b\u0005\u0003s\u0002\u0019AA\u001a\u0003\t!x\u000eC\u0004\u0003ry\u0001\r!a:\u0002\u001bA\u0014xN[3diN\u001b\u0007.Z7b)!\t\tO!#\u0003\f\n=\u0005b\u0002B\u001c?\u0001\u0007\u0011\u0011\u001d\u0005\b\u0005\u001b{\u0002\u0019AA\u001a\u0003\u00111'o\\7\t\u000f\t\u0005u\u00041\u0001\u00024\u0005!r-\u001a;M_\u001e4\u0015\u000e\\3t\rJ|Wn\u00157jG\u0016$BA!\u0010\u0003\u0016\"9!q\u0013\u0011A\u0002\te\u0015!\u00034jY\u0016\u001cF.[2f!\u0011\u0011)Ea'\n\t\tu%q\t\u0002\n\r&dWm\u00157jG\u0016\f\u0001\u0003Z3uK\u000e$h)\u001b7f\r>\u0014X.\u0019;\u0015\u0007Q\u0013\u0019\u000b\u0003\u0004\u0003&\u0006\u0002\r\u0001V\u0001\tM&dW\rU1uQ\u0002")
public class HoodieMultipleBaseFileFormat
implements FileFormat,
SparkAdapterSupport,
scala.Serializable {
    private final Broadcast<HoodieTableState> tableState;
    private final Broadcast<HoodieTableSchema> tableSchema;
    private final String tableName;
    private final String mergeType;
    private final Seq<String> mandatoryFields;
    private final boolean isMOR;
    private final boolean isIncremental;
    private final Seq<Filter> requiredFilters;
    private final ParquetFileFormat parquetFormat;
    private final OrcFileFormat orcFormat;
    private boolean isProjected;
    private boolean supportBatchCalled;
    private boolean supportBatchResult;
    private SparkAdapter sparkAdapter;
    private volatile boolean bitmap$0;

    public Option<Seq<String>> vectorTypes(StructType requiredSchema, StructType partitionSchema, SQLConf sqlConf) {
        return FileFormat.vectorTypes$((FileFormat)this, (StructType)requiredSchema, (StructType)partitionSchema, (SQLConf)sqlConf);
    }

    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        return FileFormat.buildReader$((FileFormat)this, (SparkSession)sparkSession, (StructType)dataSchema, (StructType)partitionSchema, (StructType)requiredSchema, filters, options, (Configuration)hadoopConf);
    }

    public boolean supportDataType(DataType dataType) {
        return FileFormat.supportDataType$((FileFormat)this, (DataType)dataType);
    }

    public boolean supportFieldName(String name) {
        return FileFormat.supportFieldName$((FileFormat)this, (String)name);
    }

    private SparkAdapter sparkAdapter$lzycompute() {
        HoodieMultipleBaseFileFormat hoodieMultipleBaseFileFormat = this;
        synchronized (hoodieMultipleBaseFileFormat) {
            if (!this.bitmap$0) {
                this.sparkAdapter = SparkAdapterSupport.sparkAdapter$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkAdapter;
    }

    @Override
    public SparkAdapter sparkAdapter() {
        return !this.bitmap$0 ? this.sparkAdapter$lzycompute() : this.sparkAdapter;
    }

    private ParquetFileFormat parquetFormat() {
        return this.parquetFormat;
    }

    private OrcFileFormat orcFormat() {
        return this.orcFormat;
    }

    public Option<StructType> inferSchema(SparkSession sparkSession, Map<String, String> options, Seq<FileStatus> files) {
        Option option;
        String fileFormat = this.detectFileFormat(((FileStatus)files.head()).getPath().toString());
        String string = fileFormat;
        if ("parquet".equals(string)) {
            option = this.parquetFormat().inferSchema(sparkSession, options, files);
        } else if ("orc".equals(string)) {
            option = this.orcFormat().inferSchema(sparkSession, options, files);
        } else {
            throw new UnsupportedOperationException(new StringBuilder(30).append("File format ").append(fileFormat).append(" is not supported.").toString());
        }
        return option;
    }

    public boolean isSplitable(SparkSession sparkSession, Map<String, String> options, Path path) {
        return false;
    }

    public boolean isProjected() {
        return this.isProjected;
    }

    public void isProjected_$eq(boolean x$1) {
        this.isProjected = x$1;
    }

    private boolean supportBatchCalled() {
        return this.supportBatchCalled;
    }

    private void supportBatchCalled_$eq(boolean x$1) {
        this.supportBatchCalled = x$1;
    }

    private boolean supportBatchResult() {
        return this.supportBatchResult;
    }

    private void supportBatchResult_$eq(boolean x$1) {
        this.supportBatchResult = x$1;
    }

    public boolean supportBatch(SparkSession sparkSession, StructType schema) {
        block0: {
            if (this.supportBatchCalled()) break block0;
            this.supportBatchCalled_$eq(true);
            this.supportBatchResult_$eq(!this.isMOR && !this.isIncremental && this.parquetFormat().supportBatch(sparkSession, schema) && this.orcFormat().supportBatch(sparkSession, schema));
        }
        return this.supportBatchResult();
    }

    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, Map<String, String> options, StructType dataSchema) {
        throw new UnsupportedOperationException("Write operations are not supported in this example.");
    }

    public Function1<PartitionedFile, Iterator<InternalRow>> buildReaderWithPartitionValues(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        StructType structType;
        StructType outputSchema = new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredSchema.fields())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionSchema.fields())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
        if (this.isIncremental) {
            structType = new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dataSchema.toArray(ClassTag$.MODULE$.apply(StructField.class)))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionSchema.fields())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
        } else if (!this.isMOR || MergeOnReadSnapshotRelation$.MODULE$.isProjectionCompatible((HoodieTableState)this.tableState.value())) {
            Buffer added = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            this.mandatoryFields.foreach((Function1 & Serializable & scala.Serializable)field -> {
                HoodieMultipleBaseFileFormat.$anonfun$buildReaderWithPartitionValues$1(requiredSchema, dataSchema, added, field);
                return BoxedUnit.UNIT;
            });
            StructType addedFields = new StructType((StructField[])added.toArray(ClassTag$.MODULE$.apply(StructField.class)));
            structType = new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredSchema.toArray(ClassTag$.MODULE$.apply(StructField.class)))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])addedFields.fields())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
        } else {
            structType = dataSchema;
        }
        StructType requiredSchemaWithMandatory = structType;
        Tuple4<Function1<PartitionedFile, Iterator<InternalRow>>, Function1<PartitionedFile, Iterator<InternalRow>>, Function1<PartitionedFile, Iterator<InternalRow>>, Function1<PartitionedFile, Iterator<InternalRow>>> tuple4 = this.buildFileReaders(sparkSession, dataSchema, partitionSchema, this.isIncremental ? requiredSchemaWithMandatory : requiredSchema, filters, options, hadoopConf, requiredSchemaWithMandatory);
        if (tuple4 == null) {
            throw new MatchError(tuple4);
        }
        Function1 parquetBaseFileReader = (Function1)tuple4._1();
        Function1 orcBaseFileReader = (Function1)tuple4._2();
        Function1 preMergeParquetBaseFileReader = (Function1)tuple4._3();
        Function1 preMergeOrcBaseFileReader = (Function1)tuple4._4();
        Tuple4 tuple42 = new Tuple4((Object)parquetBaseFileReader, (Object)orcBaseFileReader, (Object)preMergeParquetBaseFileReader, (Object)preMergeOrcBaseFileReader);
        Tuple4 tuple43 = tuple42;
        Function1 parquetBaseFileReader2 = (Function1)tuple43._1();
        Function1 orcBaseFileReader2 = (Function1)tuple43._2();
        Function1 preMergeParquetBaseFileReader2 = (Function1)tuple43._3();
        Function1 preMergeOrcBaseFileReader2 = (Function1)tuple43._4();
        Broadcast broadcastedHadoopConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        return (Function1 & Serializable & scala.Serializable)file -> {
            Iterator iterator2;
            StoragePath filePath = this.sparkAdapter().getSparkPartitionedFileUtils().getPathFromPartitionedFile((PartitionedFile)file);
            String fileFormat = this.detectFileFormat(filePath.toString());
            InternalRow internalRow = file.partitionValues();
            if (internalRow instanceof HoodiePartitionFileSliceMapping) {
                LogFileIterator logFileIterator;
                HoodiePartitionFileSliceMapping hoodiePartitionFileSliceMapping = (HoodiePartitionFileSliceMapping)internalRow;
                if (FSUtils.isLogFile(filePath)) {
                    FileSlice fileSlice = (FileSlice)hoodiePartitionFileSliceMapping.getSlice(FSUtils.getFileId(filePath.getName()).substring(1)).get();
                    List<HoodieLogFile> logFiles = this.getLogFilesFromSlice(fileSlice);
                    Schema outputAvroSchema = HoodieBaseRelation$.MODULE$.convertToAvroSchema(outputSchema, $this.tableName);
                    logFileIterator = new LogFileIterator(logFiles, filePath.getParent(), (HoodieTableSchema)$this.tableSchema.value(), outputSchema, outputAvroSchema, (HoodieTableState)$this.tableState.value(), ((SerializableConfiguration)broadcastedHadoopConf.value()).value());
                } else {
                    Iterator iterator3;
                    Option<FileSlice> option = hoodiePartitionFileSliceMapping.getSlice(FSUtils.getFileId(filePath.getName()));
                    if (option instanceof Some) {
                        Iterator<InternalRow> iterator4;
                        Some some = (Some)option;
                        FileSlice fileSlice = (FileSlice)some.value();
                        HoodieBaseFile hoodieBaseFile = fileSlice.getBaseFile().get();
                        String baseFileFormat = this.detectFileFormat(hoodieBaseFile.getFileName());
                        InternalRow partitionValues = hoodiePartitionFileSliceMapping.getPartitionValues();
                        List<HoodieLogFile> logFiles = this.getLogFilesFromSlice(fileSlice);
                        if (requiredSchemaWithMandatory.isEmpty()) {
                            Iterator<InternalRow> iterator5;
                            PartitionedFile baseFile = MergeOnReadSnapshotRelation$.MODULE$.createPartitionedFile(partitionValues, hoodieBaseFile.getStoragePath(), 0L, hoodieBaseFile.getFileLen());
                            String string = baseFileFormat;
                            if ("parquet".equals(string)) {
                                iterator5 = (Iterator<InternalRow>)parquetBaseFileReader2.apply((Object)baseFile);
                            } else if ("orc".equals(string)) {
                                iterator5 = (Iterator)orcBaseFileReader2.apply((Object)baseFile);
                            } else {
                                throw new UnsupportedOperationException(new StringBuilder(35).append("Base file format ").append(baseFileFormat).append(" is not supported.").toString());
                            }
                            iterator4 = iterator5;
                        } else if (logFiles.nonEmpty()) {
                            Iterator iterator6;
                            PartitionedFile baseFile = MergeOnReadSnapshotRelation$.MODULE$.createPartitionedFile(InternalRow$.MODULE$.empty(), hoodieBaseFile.getStoragePath(), 0L, hoodieBaseFile.getFileLen());
                            String string = baseFileFormat;
                            if ("parquet".equals(string)) {
                                iterator6 = (Iterator)preMergeParquetBaseFileReader2.apply((Object)baseFile);
                            } else if ("orc".equals(string)) {
                                iterator6 = (Iterator)preMergeOrcBaseFileReader2.apply((Object)baseFile);
                            } else {
                                throw new UnsupportedOperationException(new StringBuilder(35).append("Base file format ").append(baseFileFormat).append(" is not supported.").toString());
                            }
                            iterator4 = this.buildMergeOnReadIterator((Iterator<InternalRow>)iterator6, logFiles, filePath.getParent(), requiredSchemaWithMandatory, requiredSchemaWithMandatory, outputSchema, partitionSchema, partitionValues, ((SerializableConfiguration)broadcastedHadoopConf.value()).value());
                        } else {
                            throw new IllegalStateException("should not be here since file slice should not have been broadcasted since it has no log or base files");
                        }
                        iterator3 = iterator4;
                    } else {
                        Iterator iterator7;
                        String string = fileFormat;
                        if ("parquet".equals(string)) {
                            iterator7 = (Iterator)parquetBaseFileReader2.apply(file);
                        } else if ("orc".equals(string)) {
                            iterator7 = (Iterator)orcBaseFileReader2.apply(file);
                        } else {
                            throw new UnsupportedOperationException(new StringBuilder(35).append("Base file format ").append(fileFormat).append(" is not supported.").toString());
                        }
                        iterator3 = iterator7;
                    }
                    logFileIterator = iterator3;
                }
                iterator2 = logFileIterator;
            } else {
                Iterator iterator8;
                String string = fileFormat;
                if ("parquet".equals(string)) {
                    iterator8 = (Iterator)parquetBaseFileReader2.apply(file);
                } else if ("orc".equals(string)) {
                    iterator8 = (Iterator)orcBaseFileReader2.apply(file);
                } else {
                    throw new UnsupportedOperationException(new StringBuilder(35).append("Base file format ").append(fileFormat).append(" is not supported.").toString());
                }
                iterator2 = iterator8;
            }
            return iterator2;
        };
    }

    public Tuple4<Function1<PartitionedFile, Iterator<InternalRow>>, Function1<PartitionedFile, Iterator<InternalRow>>, Function1<PartitionedFile, Iterator<InternalRow>>, Function1<PartitionedFile, Iterator<InternalRow>>> buildFileReaders(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf, StructType requiredSchemaWithMandatory) {
        Function1 parquetBaseFileReader = this.parquetFormat().buildReaderWithPartitionValues(sparkSession, dataSchema, partitionSchema, requiredSchema, (Seq)filters.$plus$plus(this.requiredFilters, Seq$.MODULE$.canBuildFrom()), options, new Configuration(hadoopConf));
        Function1 orcBaseFileReader = this.orcFormat().buildReaderWithPartitionValues(sparkSession, dataSchema, partitionSchema, requiredSchema, (Seq)filters.$plus$plus(this.requiredFilters, Seq$.MODULE$.canBuildFrom()), options, new Configuration(hadoopConf));
        Function1 preMergeParquetBaseFileReader = this.isMOR ? this.parquetFormat().buildReaderWithPartitionValues(sparkSession, dataSchema, StructType$.MODULE$.apply((Seq)Nil$.MODULE$), requiredSchemaWithMandatory, this.requiredFilters, options, new Configuration(hadoopConf)) : x$2 -> package$.MODULE$.Iterator().empty();
        Function1 preMergeOrcBaseFileReader = this.isMOR ? this.orcFormat().buildReaderWithPartitionValues(sparkSession, dataSchema, StructType$.MODULE$.apply((Seq)Nil$.MODULE$), requiredSchemaWithMandatory, this.requiredFilters, options, new Configuration(hadoopConf)) : x$3 -> package$.MODULE$.Iterator().empty();
        return new Tuple4((Object)parquetBaseFileReader, (Object)orcBaseFileReader, (Object)preMergeParquetBaseFileReader, (Object)preMergeOrcBaseFileReader);
    }

    public Iterator<InternalRow> buildMergeOnReadIterator(Iterator<InternalRow> iter, List<HoodieLogFile> logFiles, StoragePath partitionPath, StructType inputSchema, StructType requiredSchemaWithMandatory, StructType outputSchema, StructType partitionSchema, InternalRow partitionValues, Configuration hadoopConf) {
        Schema requiredAvroSchema = HoodieBaseRelation$.MODULE$.convertToAvroSchema(requiredSchemaWithMandatory, this.tableName);
        String string = this.mergeType;
        String string2 = DataSourceReadOptions$.MODULE$.REALTIME_SKIP_MERGE_OPT_VAL();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            throw new UnsupportedOperationException("Skip merge is not currently implemented for the New Hudi Parquet File format");
        }
        String string4 = DataSourceReadOptions$.MODULE$.REALTIME_PAYLOAD_COMBINE_OPT_VAL();
        String string5 = string;
        if (string4 != null ? !string4.equals(string5) : string5 != null) {
            throw new MatchError((Object)string);
        }
        RecordMergingFileIterator recordMergingFileIterator = new RecordMergingFileIterator(logFiles, partitionPath, iter, inputSchema, (HoodieTableSchema)this.tableSchema.value(), requiredSchemaWithMandatory, requiredAvroSchema, (HoodieTableState)this.tableState.value(), hadoopConf);
        RecordMergingFileIterator morIterator = recordMergingFileIterator;
        return this.appendPartitionAndProject(morIterator, requiredSchemaWithMandatory, partitionSchema, outputSchema, partitionValues);
    }

    public Iterator<InternalRow> appendPartitionAndProject(Iterator<InternalRow> iter, StructType inputSchema, StructType partitionSchema, StructType to, InternalRow partitionValues) {
        Iterator iterator2;
        if (partitionSchema.isEmpty()) {
            iterator2 = this.projectSchema(iter, inputSchema, to);
        } else {
            UnsafeProjection unsafeProjection = HoodieCatalystExpressionUtils$.MODULE$.generateUnsafeProjection(new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])inputSchema.fields())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionSchema.fields())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)))), to);
            JoinedRow joinedRow = new JoinedRow();
            iterator2 = iter.map((Function1 & Serializable & scala.Serializable)d -> unsafeProjection.apply((InternalRow)joinedRow.apply(d, partitionValues)));
        }
        return iterator2;
    }

    public Iterator<InternalRow> projectSchema(Iterator<InternalRow> iter, StructType from, StructType to) {
        UnsafeProjection unsafeProjection = HoodieCatalystExpressionUtils$.MODULE$.generateUnsafeProjection(from, to);
        return iter.map((Function1 & Serializable & scala.Serializable)d -> unsafeProjection.apply(d));
    }

    public List<HoodieLogFile> getLogFilesFromSlice(FileSlice fileSlice) {
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(fileSlice.getLogFiles().sorted(HoodieLogFile.getLogFileComparator()).iterator()).asScala()).toList();
    }

    private String detectFileFormat(String filePath) {
        return filePath.endsWith(".parquet") ? "parquet" : (filePath.endsWith(".orc") ? "orc" : "");
    }

    public static final /* synthetic */ void $anonfun$buildReaderWithPartitionValues$1(StructType requiredSchema$1, StructType dataSchema$1, Buffer added$1, String field) {
        block0: {
            if (!requiredSchema$1.getFieldIndex(field).isEmpty()) break block0;
            StructField fieldToAdd = dataSchema$1.fields()[BoxesRunTime.unboxToInt((Object)dataSchema$1.getFieldIndex(field).get())];
            added$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{fieldToAdd}));
        }
    }

    public HoodieMultipleBaseFileFormat(Broadcast<HoodieTableState> tableState, Broadcast<HoodieTableSchema> tableSchema, String tableName, String mergeType, Seq<String> mandatoryFields, boolean isMOR, boolean isIncremental, Seq<Filter> requiredFilters) {
        this.tableState = tableState;
        this.tableSchema = tableSchema;
        this.tableName = tableName;
        this.mergeType = mergeType;
        this.mandatoryFields = mandatoryFields;
        this.isMOR = isMOR;
        this.isIncremental = isIncremental;
        this.requiredFilters = requiredFilters;
        FileFormat.$init$((FileFormat)this);
        SparkAdapterSupport.$init$(this);
        this.parquetFormat = new ParquetFileFormat();
        this.orcFormat = new OrcFileFormat();
        this.isProjected = false;
        this.supportBatchCalled = false;
        this.supportBatchResult = false;
    }
}

