/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.spark.sql.HoodieSchemaUtils;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.codegen.GenerateUnsafeProjection$;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.execution.datasources.parquet.ParquetToSparkSchemaConverter;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenSeq;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class HoodieParquetFileFormatHelper$ {
    public static HoodieParquetFileFormatHelper$ MODULE$;

    static {
        new HoodieParquetFileFormatHelper$();
    }

    public Tuple2<Map<Integer, Pair<DataType, DataType>>, StructType> buildImplicitSchemaChangeInfo(Configuration hadoopConf, FileMetaData parquetFileMetaData, StructType requiredSchema) {
        ParquetToSparkSchemaConverter convert = new ParquetToSparkSchemaConverter(hadoopConf);
        StructType fileStruct = convert.convert(parquetFileMetaData.getSchema());
        return this.buildImplicitSchemaChangeInfo(fileStruct, requiredSchema);
    }

    public Tuple2<Map<Integer, Pair<DataType, DataType>>, StructType> buildImplicitSchemaChangeInfo(StructType fileStruct, StructType requiredSchema) {
        HashMap implicitTypeChangeInfo = new HashMap();
        scala.collection.immutable.Map fileStructMap = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fileStruct.fields())).map((Function1 & Serializable & scala.Serializable)f -> new Tuple2((Object)f.name(), (Object)f.dataType()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        Seq sparkRequestStructFields = (Seq)requiredSchema.map((Function1 & Serializable & scala.Serializable)f -> {
            StructField structField;
            DataType requiredType = f.dataType();
            if (fileStructMap.contains((Object)f.name()) && !MODULE$.isDataTypeEqual(requiredType, (DataType)fileStructMap.apply((Object)f.name()))) {
                DataType readerType = MODULE$.addMissingFields(requiredType, (DataType)fileStructMap.apply((Object)f.name()));
                implicitTypeChangeInfo.put(new Integer(requiredSchema.fieldIndex(f.name())), Pair.of(requiredType, readerType));
                structField = new StructField(f.name(), readerType, f.nullable(), StructField$.MODULE$.apply$default$4());
            } else {
                structField = f;
            }
            return structField;
        }, Seq$.MODULE$.canBuildFrom());
        return new Tuple2(implicitTypeChangeInfo, (Object)StructType$.MODULE$.apply(sparkRequestStructFields));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isDataTypeEqual(DataType requiredType, DataType fileType) {
        Tuple2 tuple2;
        while (true) {
            if ((tuple2 = new Tuple2((Object)requiredType, (Object)fileType)) != null) {
                DataType requiredType2 = (DataType)tuple2._1();
                DataType fileType2 = (DataType)tuple2._2();
                DataType dataType = requiredType2;
                DataType dataType2 = fileType2;
                if (dataType == null) {
                    if (dataType2 == null) return true;
                } else if (dataType.equals(dataType2)) {
                    return true;
                }
            }
            if (tuple2 != null) {
                DataType dataType = (DataType)tuple2._1();
                DataType dataType3 = (DataType)tuple2._2();
                if (dataType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType;
                    DataType rt = arrayType.elementType();
                    if (dataType3 instanceof ArrayType) {
                        DataType ft;
                        ArrayType arrayType2 = (ArrayType)dataType3;
                        fileType = ft = arrayType2.elementType();
                        requiredType = rt;
                        continue;
                    }
                }
            }
            if (tuple2 == null) break;
            DataType dataType = (DataType)tuple2._1();
            DataType dataType4 = (DataType)tuple2._2();
            if (!(dataType instanceof MapType)) break;
            MapType mapType = (MapType)dataType;
            DataType requiredKey = mapType.keyType();
            DataType requiredValue = mapType.valueType();
            if (!(dataType4 instanceof MapType)) break;
            MapType mapType2 = (MapType)dataType4;
            DataType fileKey = mapType2.keyType();
            DataType fileValue = mapType2.valueType();
            if (!this.isDataTypeEqual(requiredKey, fileKey)) return false;
            fileType = fileValue;
            requiredType = requiredValue;
        }
        if (tuple2 == null) return false;
        DataType dataType = (DataType)tuple2._1();
        DataType dataType5 = (DataType)tuple2._2();
        if (!(dataType instanceof StructType)) return false;
        StructType structType = (StructType)dataType;
        StructField[] requiredFields = structType.fields();
        if (!(dataType5 instanceof StructType)) return false;
        StructType structType2 = (StructType)dataType5;
        StructField[] fileFields = structType2.fields();
        String[] commonFieldNames = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredFields)).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).intersect((GenSeq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fileFields)).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))));
        StructField[] fileFilteredFields = (StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fileFields)).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)HoodieParquetFileFormatHelper$.$anonfun$isDataTypeEqual$3(commonFieldNames, f))))).sortWith((Function2 & Serializable & scala.Serializable)(x$3, x$4) -> BoxesRunTime.boxToBoolean((boolean)HoodieParquetFileFormatHelper$.$anonfun$isDataTypeEqual$4(x$3, x$4)));
        StructField[] requiredFilteredFields = (StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredFields)).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)HoodieParquetFileFormatHelper$.$anonfun$isDataTypeEqual$5(commonFieldNames, f))))).sortWith((Function2 & Serializable & scala.Serializable)(x$5, x$6) -> BoxesRunTime.boxToBoolean((boolean)HoodieParquetFileFormatHelper$.$anonfun$isDataTypeEqual$6(x$5, x$6)));
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredFilteredFields)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])fileFilteredFields), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).forall((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)HoodieParquetFileFormatHelper$.$anonfun$isDataTypeEqual$7(x0$1)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DataType addMissingFields(DataType requiredType, DataType fileType) {
        Tuple2 tuple2 = new Tuple2((Object)requiredType, (Object)fileType);
        if (tuple2 != null) {
            DataType requiredType2 = (DataType)tuple2._1();
            DataType fileType2 = (DataType)tuple2._2();
            DataType dataType = requiredType2;
            DataType dataType2 = fileType2;
            if (dataType == null) {
                if (dataType2 == null) return fileType2;
            } else if (dataType.equals(dataType2)) {
                return fileType2;
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType3 = (DataType)tuple2._2();
            if (dataType instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType;
                DataType rt = arrayType.elementType();
                if (dataType3 instanceof ArrayType) {
                    ArrayType arrayType2 = (ArrayType)dataType3;
                    DataType ft = arrayType2.elementType();
                    return ArrayType$.MODULE$.apply(this.addMissingFields(rt, ft));
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType4 = (DataType)tuple2._2();
            if (dataType instanceof MapType) {
                MapType mapType = (MapType)dataType;
                DataType requiredKey = mapType.keyType();
                DataType requiredValue = mapType.valueType();
                if (dataType4 instanceof MapType) {
                    MapType mapType2 = (MapType)dataType4;
                    DataType fileKey = mapType2.keyType();
                    DataType fileValue = mapType2.valueType();
                    return MapType$.MODULE$.apply(this.addMissingFields(requiredKey, fileKey), this.addMissingFields(requiredValue, fileValue));
                }
            }
        }
        if (tuple2 == null) return fileType;
        DataType dataType = (DataType)tuple2._1();
        DataType dataType5 = (DataType)tuple2._2();
        if (!(dataType instanceof StructType)) return fileType;
        StructType structType = (StructType)dataType;
        StructField[] requiredFields = structType.fields();
        if (!(dataType5 instanceof StructType)) return fileType;
        StructType structType2 = (StructType)dataType5;
        StructField[] fileFields = structType2.fields();
        scala.collection.immutable.Map fileFieldMap = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fileFields)).map((Function1 & Serializable & scala.Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.name()), f), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        return new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredFields)).map((Function1 & Serializable & scala.Serializable)f -> {
            StructField structField;
            Option option = fileFieldMap.get((Object)f.name());
            if (option instanceof Some) {
                Some some = (Some)option;
                StructField ff = (StructField)some.value();
                structField = new StructField(ff.name(), MODULE$.addMissingFields(f.dataType(), ff.dataType()), ff.nullable(), ff.metadata());
            } else if (None$.MODULE$.equals(option)) {
                structField = f;
            } else {
                throw new MatchError((Object)option);
            }
            return structField;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
    }

    public UnsafeProjection generateUnsafeProjection(Seq<Attribute> fullSchema, Option<String> timeZoneId, Map<Integer, Pair<DataType, DataType>> typeChangeInfos, StructType requiredSchema, StructType partitionSchema, HoodieSchemaUtils schemaUtils) {
        UnsafeProjection unsafeProjection;
        if (typeChangeInfos.isEmpty()) {
            unsafeProjection = (UnsafeProjection)GenerateUnsafeProjection$.MODULE$.generate(fullSchema, fullSchema);
        } else {
            StructType newSchema = new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredSchema.fields())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                StructField f = (StructField)tuple2._1();
                int i = tuple2._2$mcI$sp();
                StructField structField = typeChangeInfos.containsKey(BoxesRunTime.boxToInteger((int)i)) ? new StructField(f.name(), (DataType)((Pair)typeChangeInfos.get(BoxesRunTime.boxToInteger((int)i))).getRight(), f.nullable(), f.metadata()) : f;
                return structField;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
            Seq newFullSchema = (Seq)schemaUtils.toAttributes(newSchema).$plus$plus(schemaUtils.toAttributes(partitionSchema), Seq$.MODULE$.canBuildFrom());
            Seq castSchema = (Seq)((TraversableLike)newFullSchema.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map(arg_0 -> HoodieParquetFileFormatHelper$.$anonfun$generateUnsafeProjection$2(typeChangeInfos, timeZoneId, arg_0), Seq$.MODULE$.canBuildFrom());
            unsafeProjection = (UnsafeProjection)GenerateUnsafeProjection$.MODULE$.generate((Object)castSchema, newFullSchema);
        }
        return unsafeProjection;
    }

    public static final /* synthetic */ boolean $anonfun$isDataTypeEqual$3(String[] commonFieldNames$1, StructField f) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])commonFieldNames$1)).contains((Object)f.name());
    }

    public static final /* synthetic */ boolean $anonfun$isDataTypeEqual$4(StructField x$3, StructField x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3.name())).$less((Object)x$4.name());
    }

    public static final /* synthetic */ boolean $anonfun$isDataTypeEqual$5(String[] commonFieldNames$1, StructField f) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])commonFieldNames$1)).contains((Object)f.name());
    }

    public static final /* synthetic */ boolean $anonfun$isDataTypeEqual$6(StructField x$5, StructField x$6) {
        return new StringOps(Predef$.MODULE$.augmentString(x$5.name())).$less((Object)x$6.name());
    }

    public static final /* synthetic */ boolean $anonfun$isDataTypeEqual$7(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        StructField requiredField = (StructField)tuple2._1();
        StructField fileFilteredField = (StructField)tuple2._2();
        boolean bl = MODULE$.isDataTypeEqual(requiredField.dataType(), fileFilteredField.dataType());
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ package.NullIntolerant $anonfun$generateUnsafeProjection$2(Map typeChangeInfos$1, Option timeZoneId$1, Tuple2 x0$2) {
        block4: {
            block2: {
                block3: {
                    var4_3 = x0$2;
                    if (var4_3 == null) break block2;
                    attr = (Attribute)var4_3._1();
                    i = var4_3._2$mcI$sp();
                    if (!typeChangeInfos$1.containsKey(BoxesRunTime.boxToInteger((int)i))) break block3;
                    srcType = (DataType)((Pair)typeChangeInfos$1.get(BoxesRunTime.boxToInteger((int)i))).getRight();
                    dstType = (DataType)((Pair)typeChangeInfos$1.get(BoxesRunTime.boxToInteger((int)i))).getLeft();
                    needTimeZone = Cast$.MODULE$.needsTimeZone(srcType, dstType);
                    v0 = srcType;
                    var10_9 = FloatType$.MODULE$;
                    if (v0 != null ? v0.equals(var10_9) == false : var10_9 != null) ** GOTO lbl-1000
                    v1 = dstType;
                    var11_10 = DoubleType$.MODULE$;
                    if (!(v1 != null ? v1.equals(var11_10) == false : var11_10 != null)) {
                        toStringAttr = new Cast((Expression)attr, (DataType)StringType$.MODULE$, (Option)(needTimeZone != false ? timeZoneId$1 : None$.MODULE$), Cast$.MODULE$.apply$default$4());
                        v2 = new Cast((Expression)toStringAttr, dstType, (Option)(needTimeZone != false ? timeZoneId$1 : None$.MODULE$), Cast$.MODULE$.apply$default$4());
                    } else lbl-1000:
                    // 2 sources

                    {
                        v2 = new Cast((Expression)attr, dstType, (Option)(needTimeZone != false ? timeZoneId$1 : None$.MODULE$), Cast$.MODULE$.apply$default$4());
                    }
                    break block4;
                }
                v2 = attr;
                break block4;
            }
            throw new MatchError((Object)var4_3);
        }
        var3_12 = v2;
        return var3_12;
    }

    private HoodieParquetFileFormatHelper$() {
        MODULE$ = this;
    }
}

